/*
 * Copyright (c) 2018, FusionAuth, All Rights Reserved
 */
'use strict';

var FusionAuth = FusionAuth || {};
FusionAuth.UI = FusionAuth.UI || {};

FusionAuth.UI.Main = {
  initialize: function() {
    // Delegate tooltip initialization, we could also move all of this into the ToolTip widget.
    Prime.Document.addDelegatedEventListener('mouseover', '[data-tooltip]', function(event, target) {
      if (typeof(target.toolTipObject) === 'undefined') {
        target.toolTipObject = new Prime.Widgets.Tooltip(target).withClassName('tooltip').initialize();
      }
    });

    // Debounce all toggles to keep them from going cray-cray.
    Prime.Document.query('label.toggle').each(function(e) {
      e.addEventListener('click', function() {
        // Debounce the switch yo!
        e.setStyle('pointer-events', 'none');
        setTimeout(function() {
          e.setStyle('pointer-events', null);
        }, 700);
      });
    });

    Prime.Document.query('[data-slide-open]').each(function(e) {
      e.addEventListener('change', function() {
        var dataSet = e.getDataSet();
        var element = Prime.Document.queryById(dataSet.slideOpen);
        new Prime.Effects.SlideOpen(element).toggle();

        // Allow two separate sections, one to be opened, and the other to be closed in unison
        if (dataSet.slideClosed) {
          var slideClosed = Prime.Document.queryById(dataSet.slideClosed);
          new Prime.Effects.SlideOpen(slideClosed).toggle();
        }
      });
    });

    Prime.Document.query('.multiple-select').each(function(e) {
      new Prime.Widgets.MultipleSelect(e)
          .withCustomAddEnabled(true)
          .withErrorClassHandling('error')
          .withRemoveIcon('')
          .initialize();
    });

    Prime.Document.query('.alert').each(function(e) {
      var dismissButton = e.queryFirst('a.dismiss-button');
      if (dismissButton !== null) {
        new Prime.Widgets.Dismissable(e, dismissButton).initialize();
      }
    });

    var sideBar = Prime.Document.queryFirst('.app-sidebar-toggle');
    if (sideBar !== null) {
      new FusionAuth.Admin.UserSearchBar();
      new Prime.Widgets.SideMenu(Prime.Document.queryFirst('.app-sidebar-toggle'), Prime.Document.queryFirst('.app-sidebar'))
          .withOptions({
            'closedClass': 'app-sidebar-closed',
            'openClass': 'app-sidebar-open'
          })
          .initialize();

      new Prime.Widgets.TreeView(Prime.Document.queryFirst('.treeview')).withFolderToggleClassName('folder-toggle').initialize();
    }

    // Handle the focus for widgets
    Prime.Document.query('input').each(function (input) {
      input.addEventListener('focus', function (event) {
        new Prime.Document.Element(event.target).getParent().addClass('focus');
      }).addEventListener('blur', function (event) {
        new Prime.Document.Element(event.target).getParent().removeClass('focus');
      });
    });

    // Handle vertical scroll so we can preserve the page header, especially on long moderation queues
    var header = Prime.Document.queryFirst('header.page-header');
    function _handlePageScroll() {
      if (window.pageYOffset >= stickyHeight) {
        header.addClass('sticky');
      } else {
        header.removeClass('sticky');
      }
    }

    if (header !== null) {
      window.onscroll = _handlePageScroll;
      // app header height is 45
      var stickyHeight = header.getOffsetTop() - 45;
    }

    // Wire up SplitButtons
    Prime.Document.query('.split-button').each(function(sb) {
      new Prime.Widgets.SplitButton(sb).initialize();
    });
  }
};

Prime.Document.onReady(FusionAuth.UI.Main.initialize);
