/*
 * Copyright (c) 2018, FusionAuth, All Rights Reserved
 */
'use strict';

var FusionAuth = FusionAuth || {};
FusionAuth.Admin = FusionAuth.Admin || {};

/**
 * JavaScript for the add / edit user page.
 *
 * @constructor
 */
FusionAuth.Admin.User = function() {
  Prime.Utils.bindAll(this);

  this.form = Prime.Document.queryById('user-form');
  this.passwordFields = Prime.Document.queryById('password-fields');

  // Edit User Password Options
  this.editUserPasswordOptions = this.form.queryFirst('select[name="editPasswordOption"]');
  if (this.editUserPasswordOptions !== null) {
    this.editUserPasswordOptions.addEventListener('change', this. _handleEditUserPasswordEvent);
  }

  // Birthdate date picker
  var birthDatePicker = this.form.queryFirst('.birthdate-picker');
  var birthDateSet = birthDatePicker.getValue().length > 0;
  new Prime.Widgets.DateTimePicker(birthDatePicker)
      .withCustomFormatHandler(this._handleDateFormat)
      .initialize();

  this.preferredLanguages = this.form.queryFirst('select[name="preferredLanguages"]');
  if (this.preferredLanguages !== null) {
    new Prime.Widgets.MultipleSelect(this.preferredLanguages)
        .withRemoveIcon('')
        .withCustomAddEnabled(false)
        .withPlaceholder('English')
        .initialize();
  }

  // Kind of a hack for now, we should have an option on the date picker to not set the value on initialize unless the field contains a value
  if (!birthDateSet) {
    birthDatePicker.setValue('');
  }

  // handle this for field validation while change password is selected
  this._handleEditUserPasswordEvent();
};

FusionAuth.Admin.User.constructor = FusionAuth.Admin.User;
FusionAuth.Admin.User.prototype = {

  /* ===================================================================================================================
   * Private Methods
   * ===================================================================================================================*/

  /**
   * Handles the select change event.
   * @private
   */
  _handleEditUserPasswordEvent: function() {
    if (this.editUserPasswordOptions !== null) {
      if (this.editUserPasswordOptions.getValue() === 'update') {
        this.passwordFields.addClass('open');
      } else {
        this.passwordFields.removeClass('open');
      }
    }
  },

  /**
   * Hard coding this for now - we should really build a formatter into the Date Picker
   * @param date the current date value of the date picker
   * @returns {string} return a string to be set into the input field
   * @private
   */
  _handleDateFormat: function(date) {
    return (date.getMonth() + 1)  + "/" + date.getDate() + "/" + date.getFullYear();
  }
};