(ns {{ns-name}}.routes.services.graphql
  (:require
    [clj-time.coerce :as tc]
    [clojure.core.async :as a]
    [clojure.edn :as edn]
    [clojure.java.io :as io]
    [clojure.tools.logging :as l]
    [com.walmartlabs.lacinia :as lacinia]
    [com.walmartlabs.lacinia.schema :as lacinia-schema]
    [com.walmartlabs.lacinia.util :refer [attach-resolvers attach-scalar-transformers attach-streamers]]
    [{{ns-name}}.incubator :as i]
    [{{ns-name}}.protocols :as p]
    [{{ns-name}}.utils :as u]
    [{{ns-name}}.utilsc :as uc]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [medley.core :as m]
    [mount.core :refer [defstate]]
    [plumbing.core :refer :all]
    [uncomplicate.fluokitten.core :as f]))

(defn parse-date
  "TODO doc"
  [x]
  (when (string? x)
    (try
      (-> x clojure.edn/read-string tc/from-date)
      (catch Throwable _
        nil))))

(defn serialize-date
  "TODO doc"
  [x]
  (try
    (-> x tc/to-date pr-str)
    (catch Throwable _
      nil)))

(defn get-data
  "TODO doc"
  [context args value]
  (letk [[app] context]
    (-> (p/GetData app)
      ->external-keys)))

(defn set-data
  "TODO doc"
  [context args value]
  (letk [[app] context
         [data] args]
    (-> (p/SetData app data)
      ->external-keys)))

(defn app-events
  "TODO doc"
  [context args source-stream]
  (letk [[app
          session-id
          user] context
         c (p/SubscribeEvents app "app" session-id)]
    (a/pipeline 1
                source-stream
                (comp
                  (map (fnk [event-data
                             event-type
                             :as event]
                         (case event-type

                           :session-expired
                           {:event-type (name event-type)
                            :event-data {}}

                           event)))
                  (map ->external-keys))
                c
                true
                (fn [ex] (fn [ex] (l/error ex ""))))
    #(l/debug "Finalize events stream" (pr-str user))))

(defstate compiled-schema
  :start
  (-> "graphql/schema.edn"
    io/resource
    slurp
    edn/read-string
    (attach-resolvers (->m get-data
                           set-data))
    (attach-scalar-transformers (->m parse-date
                                     serialize-date))
    (attach-streamers (->m app-events))
    lacinia-schema/compile))
