(ns {{ns-name}}.core
  (:require
    [clojure.tools.cli :refer [parse-opts]]
    [clojure.tools.logging :as l]
    [{{ns-name}}.config :refer [env]]
    [{{ns-name}}.handler :as handler]
    [{{ns-name}}.nrepl :as nrepl]
    [luminus.http-server :as http]
    [medley.core :as m]
    [mount.core :as mount]
    [plumbing.core :refer :all]
    [uncomplicate.fluokitten.core :as f])
  (:gen-class))

;; log uncaught exceptions in threads
(Thread/setDefaultUncaughtExceptionHandler
  (reify Thread$UncaughtExceptionHandler
    (uncaughtException [_ thread ex]
      (l/error {:what :uncaught-exception
                :exception ex
                :where (str "Uncaught exception on" (.getName thread))}))))

(def cli-options
  [[nil "--port PORT" "Port number" :parse-fn #(Integer/parseInt %)]
   [nil "--ssl-port PORT" "SSL port number" :parse-fn #(Integer/parseInt %)]])

(mount/defstate ^{:on-reload :noop} http-server
  :start
  (letk [[{javax-net-ssl-keystore nil}
          {javax-net-ssl-keystorepassword nil}
          {port nil}
          {ssl-port nil}] env
         port (or (-> env :options :port) port)
         ssl-port (or (-> env :options :ssl-port) ssl-port)
         update-port (if ssl-port
                       (fn-> (assoc :port nil)
                             (assoc :ssl-port ssl-port)
                             (merge {:key-password  javax-net-ssl-keystorepassword
                                     :keystore      javax-net-ssl-keystore}))
                       (fn-> (assoc :port port)
                             (assoc :ssl-port nil)))]
    (http/start
      (-> env
        (assoc :handler (handler/app))
        (update :io-threads #(or % (* 2 (.availableProcessors (Runtime/getRuntime)))))
        update-port)))
  :stop
  (http/stop http-server))

(mount/defstate ^{:on-reload :noop} repl-server
  :start
  (when (env :nrepl-port)
    (nrepl/start {:bind (env :nrepl-bind)
                  :port (env :nrepl-port)}))
  :stop
  (when repl-server
    (nrepl/stop repl-server)))

(defn stop-app
  "TODO doc"
  []
  (doseq [component (:stopped (mount/stop))]
    (l/info component "stopped"))
  (shutdown-agents))

(defn start-app
  "TODO doc"
  [args]
  (doseq [component (-> args
                      (parse-opts cli-options)
                      mount/start-with-args
                      :started)]
    (l/info component "started"))
  (.addShutdownHook (Runtime/getRuntime) (Thread. stop-app)))

(defn -main
  "TODO doc"
  [& args]
  (start-app args))
