(ns {{ns-name}}.core
  (:require
    [clj-time.coerce :as tc]
    [clj-time.core :as t]
    [clj-time.format :as tf]
    [clojure.core.match :refer [match]]
    [clojure.tools.cli :refer [parse-opts]]
    [clojure.tools.logging :as l]
    [{{ns-name}}.config :refer [env]]
    [{{ns-name}}.global :as global]
    [{{ns-name}}.incubator :as i]
    [{{ns-name}}.protocols :as p]
    [{{ns-name}}.utils :refer :all]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [me.raynes.fs :as fs]
    [medley.core :as m]
    [mount.core :as mount]
    [plumbing.core :refer :all]
    [uncomplicate.fluokitten.core :as f])
  (:gen-class))

(def cli-options
  [["-a" "--action-id ID" "Action ID"]
   ["-h" "--help"]])

(defn stop-app
  []
  (doseq [component (:stopped (mount/stop))]
    (l/info component "stopped"))
  (shutdown-agents))

(defn start-app
  [args]
  (doseq [component (-> args
                      (parse-opts cli-options)
                      mount/start-with-args
                      :started)]
    (l/info component "started"))
  (.addShutdownHook (Runtime/getRuntime) (Thread. stop-app)))

(defn -main
  [& args]
  (letk [[arguments
          errors
          options
          summary :as opts] (parse-opts args cli-options)]

    (cond
      (:help options)
      (do
        (println summary))

      (seq errors)
      (do
        (println errors)
        (println summary))

      :else
      (maybe-ex
        [_ (do (start-app args) true)
         working-folder (:working-folder env)
         app global/app]
        (l/info "Data" (p/GetData app)))))

  (System/exit 0))
