/*
 * Copyright (c) 2019, FusionAuth, All Rights Reserved
 */
'use strict';

var FusionAuth = FusionAuth || {};
FusionAuth.Admin = FusionAuth.Admin || {};

/**
 * Handles the keys stuff.
 *
 * @constructor
 */
FusionAuth.Admin.Keys = function() {
  Prime.Utils.bindAll(this);

  new FusionAuth.UI.Listing(Prime.Document.queryFirst('table'))
      .initialize();

  var keyActions = Prime.Document.queryById('key-actions');
  keyActions.addDelegatedEventListener('click', 'a', this._handleKeyGenerateClick);
};

FusionAuth.Admin.Keys.constructor = FusionAuth.Admin.Keys;
FusionAuth.Admin.Keys.prototype = {

  /* ===================================================================================================================
   * Private methods
   * ===================================================================================================================*/

  _handleDialogOpen: function(dialog) {

    var privateKeyTextArea = dialog.element.queryFirst('textarea[name="key.privateKey"]');
    if (privateKeyTextArea !== null) {
      new FusionAuth.UI.TextEditor(privateKeyTextArea)
          .withOptions({
            'mode': 'properties',
            'lineNumbers': true,
            'lineWrapping': false
          })
          .render()
          .setHeight(200);
    }

    var publicKeyTextArea = dialog.element.queryFirst('textarea[name="key.publicKey"]');
    if (publicKeyTextArea !== null) {
      new FusionAuth.UI.TextEditor(publicKeyTextArea)
          .withOptions({
            'mode': 'properties',
            'lineNumbers': true,
            'lineWrapping': false
          })
          .render()
          .setHeight(200);
    }

    var certificateTextArea = dialog.element.queryFirst('textarea[name="key.certificate"]');
    if (certificateTextArea !== null) {
      new FusionAuth.UI.TextEditor(certificateTextArea)
          .withOptions({
            'mode': 'properties',
            'lineNumbers': true,
            'lineWrapping': false
          })
          .render()
          .setHeight(200);
    }

    var secretTextArea = dialog.element.queryFirst('textarea[name="key.secret"]');
    if (secretTextArea !== null) {
      new FusionAuth.UI.TextEditor(secretTextArea)
          .withOptions({
            'mode': 'properties',
            'lineNumbers': true,
            'lineWrapping': false
          })
          .render()
          .setHeight(50);
    }
  },

  _handleKeyGenerateClick: function(event) {
    Prime.Utils.stopEvent(event);

    var anchor = new Prime.Document.Element(event.target);
    this.dialog = new Prime.Widgets.AJAXDialog()
        .withCallback(this._handleDialogOpen)
        .withFormHandling(true)
        .withAdditionalClasses('wide')
        .withFormSuccessCallback(this._handleFormSuccess)
        .open(anchor.getAttribute('href'));
  },

  _handleFormSuccess: function() {
    this.dialog.close();
    window.location.reload()
  },
};