(ns {{ns-name}}.global
  (:require
    [clojure.core.async :as a]
    [clojure.tools.logging :as l]
    [{{ns-name}}.config :refer [env]]
    [{{ns-name}}.env :refer [defaults]]
    [{{ns-name}}.incubator :as i]
    [{{ns-name}}.protocols :as p]
    [de.elbenwald.common.infra :as eci]
    [de.elbenwald.common.io :as ecio]
    [de.elbenwald.common.lang :refer :all]
    [de.elbenwald.common.utils :refer :all]
    [medley.core :as m]
    [mount.core :as mount]
    [plumbing.core :refer :all]
    [uncomplicate.fluokitten.core :as f]))

(mount/defstate component-factory
  :start
  ((:make-component-factory defaults) env))

(mount/defstate app
  :start
  (eci/CreateComponent component-factory
                       :app
                       {:error-mode :either}))
