(ns de.elbenwald.amazon-tasks.pages.data
  (:require-macros
    [cljs.core.async.macros :refer [go go-loop]]
    [de.elbenwald.common.utils :refer [->m]]
    [plumbing.core :refer [defnk fnk letk fn-> fn->> if-letk when-letk]])
  (:require
    [cljs.core.async :refer [put! chan <! >! timeout close!]]
    [de.elbenwald.common.utils :refer [->external-keys ->internal-keys to-camel-case parse-double]]
    [de.elbenwald.amazon-tasks.i18n :refer [rc]]
    [de.elbenwald.amazon-tasks.utils :refer [elements make-graphql-event-handler]]
    [goog.string :as gs]
    [medley.core :refer [map-kv]]
    [plumbing.core :refer [map-keys map-vals map-from-vals]]
    [re-frame.core :as rf]
    [re-graph.core :as rg]
    [reagent.core :as r]
    [reitit.core :as reitit]))

(rf/reg-event-db
  :init-data
  (fn [db _]
    db))

(rf/reg-event-db
  :data/fetch-data
  (let [h (make-graphql-event-handler :data/data)]
    (fn [db x]
      (h db x))))

(rf/reg-sub
  :data/data
  (fn [db _]
    (:data/data db)))

;
; page
;

(defn data-page
  "TODO doc"
  []
  [:div#data.container
   (when-let [data @(rf/subscribe [:data/data])]
     [:div.row>div.col-sm-12
      [:h2 (str "Data: " data)]])])
