(ns {{ns-name}}.core
  (:require-macros
    [plumbing.core :refer [defnk fnk letk fn-> fn->> if-letk when-letk]])
  (:require
    [clojure.string :as string]
    [day8.re-frame.http-fx]
    [de.elbenwald.common.utils :refer [->external-keys]]
    [{{ns-name}}.ajax :as ajax]
    [{{ns-name}}.events]
    [{{ns-name}}.i18n :refer [rc]]
    [{{ns-name}}.pages.data]
    [{{ns-name}}.utils :refer [elements make-ws-url]]
    [goog.events :as events]
    [goog.history.EventType :as HistoryEventType]
    [markdown.core :refer [md->html]]
    [plumbing.core :refer [aconcat]]
    [re-frame.core :as rf]
    [re-graph.core :as rg]
    [re-graph.internals :as rgi]
    [reagent.core :as r]
    [reitit.core :as reitit])
  (:import goog.History))

;; -------------------------
;; Routes

(def router
  (reitit/router [["/" :home]
                  ["/about" :about]
                  ["/data" :data]]))

(defn nav-link
  "TODO doc"
  [uri title page]
  [:a.navbar-item
   {:href   uri
    :class (when (= page @(rf/subscribe [:page])) :is-active)}
   title])

(defn navbar
  "TODO doc"
  []
  (r/with-let [expanded? (r/atom false)
               user-uris @(rf/subscribe [:user-uris])]
    [:nav.navbar.is-info>div.container
     [:div.navbar-brand
      [:a.navbar-item {:href "/" :style {:font-weight :bold}} "{{name-short}}"]
      [:span.navbar-burger.burger
       {:data-target :nav-menu
        :on-click #(swap! expanded? not)
        :class (when @expanded? :is-active)}
       [:span][:span][:span]]]
     [:div#nav-menu.navbar-menu
      {:class (when @expanded? :is-active)}
      (->> [(->> [["/"       :home]
                  ["/data"   :data]
                  ["/about"  :about]]
              (keep (fn [[uri page]]
                      (when (contains? user-uris uri)
                        (let [title (->> page name (str "navbar.") keyword vector rc)]
                          [nav-link (str "#" uri) title page]))))
              elements)
            [[nav-link "/logout" (rc [:navbar.logout]) nil]]]
        aconcat
        (list* :div.navbar-start)
        vec)]]))

(defn about-page
  "TODO doc"
  []
  [:section.section>div.container>div.content
   [:img {:src "/img/warning-clojure.png"}]])

(defn home-page
  "TODO doc"
  []
  [:div#home.container
   (when-let [user @(rf/subscribe [:user])]
     [:div.row>div.col-sm-12
      [:h2 (str "Hallo " (:name user))]])])

(def pages
  {:about #'about-page
   :home #'home-page
   :data #'{{ns-name}}.pages.data/data-page})

(defn page []
  [:div
   (when @(rf/subscribe [:navbar?]) [navbar])
   [(pages @(rf/subscribe [:page]))]])

;; -------------------------
;; History
;; must be called after routes have been defined
(defn hook-browser-navigation! []
  (doto (History.)
    (events/listen HistoryEventType/NAVIGATE
                   (fn [event]
                     (let [uri (or (not-empty (string/replace (.-token event) #"^.*#" "")) "/")]
                       (rf/dispatch [:navigate (reitit/match-by-path router uri)]))))
    (.setEnabled true)))

;; -------------------------
;; Initialize app
(defn mount-components
  "TODO doc"
  []
  (rf/clear-subscription-cache!)
  (r/render [#'page] (.getElementById js/document "app")))

(defn init!
  "TODO doc"
  []
  (rf/dispatch-sync [:fetch-user])
  (rf/dispatch-sync [:navigate (reitit/match-by-name router :home)])
  (rf/dispatch [:navigate-start-page router])

  (rf/dispatch [::rg/init
                {
                 ; :ws-url                   nil
                 :ws-url                   (make-ws-url "/api/graphql-ws")        ;; override the websocket url (defaults to /graphql-ws, nil to disable)
                 :http-url                 "/api/graphql2"                          ;; override the http url (defaults to /graphql)
                 ; :http-parameters          {:with-credentials? false              ;; any parameters to be merged with the request, see cljs-http for options
                 ;                            :oauth-token "Secret"}
                 :ws-reconnect-timeout     2000                                     ;; attempt reconnect n milliseconds after disconnect (default 5000, nil to disable)
                 :resume-subscriptions?    true                                     ;; start existing subscriptions again when websocket is reconnected after a disconnect
                 :connection-init-payload  {}}])                                    ;; the payload to send in the connection_init message, sent when a websocket connection is made

  (rf/dispatch [::rg/subscribe
                :app-events-subscription  ;; this id should uniquely identify this subscription
                "subscription {
                   appEvents {
                     eventType
                     eventData
                   }
                 }"
                (-> {}
                  ->external-keys)   ;; arguments map
                [:on-app-event]])       ;; callback event when messages are recieved

  (ajax/load-interceptors!)
  ; (rf/dispatch [:fetch-docs])
  (hook-browser-navigation!)
  (mount-components))
