# Elasticsearch on Clojure

There will be seqs.


## Usage

Leiningen setup:

```
[org.elasticsearch/elasticsearch-clojure "0.99.0-SNAPSHOT"]
```

Common namespaces:

```
(:require [elasticsearch.document :as doc]
          [elasticsearch.connection.http :as conn]
          [elasticsearch.indices :as indices]
          [elasticsearch.cluster :as cluster])
```

## Releasing

Make sure you have your lein credentials set up.  If you haven't yet done that, this should get you started:

```
% cat <<EOF | gpg -e -r YOURKEY > ~/.lein/credentials.clj.gpg
{#"https://clojars.org/repo"
 {:username "USER" :password "PASS"}}
EOF
```

Now you should be able to deploy to Clojars.  This will deploy the current snap, feel free to do at will.

```
% lein with-profile package deploy clojars
```

When you're ready to bump versions and make a release (again, make sure your GPG setup is correct or you'll have to `git reset` and `git tag -d` some things):

```
% lein release
```

## Development

### Connection API

#### Single node

The simplest connection. A single node, no auth or encryption.

```
(require '[elasticsearch.connection.http :as conn])
(def conn
  (conn/make {:url "http://localhost:9200"}))
```

#### Encryption and authentication

Configuration is passed straight through to
`#'clj-http.client/request`, so the semantics of `wrap-request` apply
here, like `:url` will overwrite `:scheme` and so forth.

The usual ceremony with Java KeyStores is supported as well.

```
(def conn
  (let [opts {:keystore "path/to/ks"
              :keystore-pass "keystore!"
              :trust-store "path/to/ts"
              :trust-store-pass "truststore!"
              :user-info "foo:pass"}]
    (conn/make
     (merge opts {:url (format "https://node01:9200")}))))
```

#### Multi-node

TODO

```
(def conn
  (let [opts {:user-info "foo:pass"}]
    (conn/make-connection-pool
     (for [i (range 3)]
       (conn/make-connection
        (merge opts {:url (format "https://node%d:9200" i)}))))))
```

### Create Index API

```
(indices/create conn "foo" {:body {:settings {:index.number_of_shards 1}}})
```

### Index API

```
(doc/index conn {:index "foo" :type "t" :id "1" :body {:f "some field"}})
```


### GET API

```
(doc/get conn {:index "foo" :type "t" :id "1"})
```

### Search API

```
(doc/search conn {:body
                  {:query
                   {:match
                    {:field "some"}}}})
```
