(ns elasticsearch.cluster
  (:require
   [elasticsearch.common :refer [format-uri request]]
   [elasticsearch.connection.http :as hconn]
   [elasticsearch.connection :as conn]
   [slingshot.slingshot :refer [try+]]))

(defn info [conn]
  (conn/request conn :get {:uri "/"}))

(defn ping [conn]
  (try
    (conn/request conn :head {:uri "/"})
    true
    (catch Exception _
      false)))

(defmulti stats
  (fn [_ & args]
    (map? (last args))))

(defmethod stats true
  ([conn req]
   (request conn :get (format-uri "_cluster" "stats") req))
  ([conn node-id req]
   (request conn :get (format-uri "_cluster" "stats" "nodes" node-id) req)))

(defmethod stats false
  ([conn]
   (request conn :get (format-uri "_cluster" "stats") {}))
  ([conn node-id]
   (request conn :get (format-uri "_cluster" "stats" "nodes" node-id) {})))

;; Begin generated code. Everything above will be kept and anything below will be regenerated.

(defn reroute
  ([conn] (reroute conn nil))
  ([conn req]
    (request conn :post (format-uri "_cluster" "reroute") req)))

(defn allocation-explain
  ([conn] (allocation-explain conn nil))
  ([conn req]
    (request
      conn
      :post
      (format-uri "_cluster" "allocation" "explain")
      req)))

(defn put-settings
  ([conn] (put-settings conn nil))
  ([conn req]
    (request conn :put (format-uri "_cluster" "settings") req)))

(defn pending-tasks
  ([conn] (pending-tasks conn nil))
  ([conn req]
    (request conn :get (format-uri "_cluster" "pending_tasks") req)))

(defn get-settings
  ([conn] (get-settings conn nil))
  ([conn req]
    (request conn :get (format-uri "_cluster" "settings") req)))

(defmulti state (fn [_ & args] (map? (last args))))

(defmethod
 state
 true
 ([conn req] (state conn nil req))
 ([conn index req] (state conn index nil req))
 ([conn index metric req]
  (request conn :get (format-uri "_cluster" "state" metric index) req)))

(defmethod
 state
 false
 ([conn] (state conn nil))
 ([conn index] (state conn index nil))
 ([conn index metric]
  (request conn :get (format-uri "_cluster" "state" metric index) {})))

(defmulti health (fn [_ & args] (map? (last args))))

(defmethod
 health
 true
 ([conn req] (health conn nil req))
 ([conn index req]
  (request conn :get (format-uri "_cluster" "health" index) req)))

(defmethod
 health
 false
 ([conn] (health conn nil))
 ([conn index]
  (request conn :get (format-uri "_cluster" "health" index) {})))

