(ns elasticsearch.cluster
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [fmt-uri query-params request]]
            [elasticsearch.connection :as conn]))

(defn ping [conn & [req]]
  (try
    (conn/request conn :head (merge {:uri "/"} req (query-params req)))
    true
    (catch Exception _
      false)))

(defn health [conn & [req]]
  (request conn :get (fmt-uri "_cluster" "health") req))

(defn state [conn {:keys [metric index] :as req}]
  (request conn :get (fmt-uri "_cluster" "state" metric index) req))

(defn stats [conn & [req]]
  (request conn :get (fmt-uri "_cluster" "stats") req))

(defn pending-tasks [conn & [req]]
  (request conn :get (fmt-uri "_cluster" "pending_tasks") req))

(defn reroute [conn & [req]]
  (request conn :post (fmt-uri "_cluster" "reroute") req))

(defn put-settings [conn & [req]]
  (request conn :put (fmt-uri "_cluster" "settings") req))

(defn get-settings [conn & [req]]
  (request conn :get (fmt-uri "_cluster" "settings") req))

(defn allocation-explain [conn & [req]]
  (request conn :get (fmt-uri "_cluster" "allocation" "explain") req))

(defn info [conn & [req]]
  (request conn :get "" req))
