(ns elasticsearch.common
  (:require [clojure.string :as str]
            [clojure.spec :as s]
            [clojure.walk :refer [prewalk]]
            [elasticsearch.connection :as conn]
            [elasticsearch.connection.http :as http]
            [ring.util.codec :refer [url-encode]]))

(defn coerce [x]
  (cond  (coll? x) (str/join "," x)
         (string? x) (str/replace x #" " "")
         :else (str x)))

(defn format-uri [& parts]
  (->> parts
       (filter identity)
       (map coerce)
       (map url-encode)
       (str/join "/")
       (format "/%s")))

(defn format-query-params [params]
  (reduce-kv (fn [acc k v]
               (let [v (if (coll? v)
                         (str/join "," v)
                         v)]
                 (assoc acc k v)))
             {}
             params))

(s/fdef request
        :args
        (s/alt
         :no-req
         (s/cat :conn ::http/connection
                :method keyword?
                :uri string?)
         :with-req
         (s/cat :conn ::http/connection
                :method keyword?
                :uri string?
                :req (s/nilable map?))))

(defn request
  ([conn method uri]
   (request {}))
  ([conn method uri req]
   (let [params (format-query-params (:query-params req))
         req (assoc req :uri uri :query-params params)]
     (conn/request conn method req))))
