(ns elasticsearch.tasks
  (:refer-clojure :exclude [get list])
  (:require [clojure.string :as str]
            [elasticsearch.common :refer [fmt-uri request]]
            [elasticsearch.connection :as conn]
            [slingshot.slingshot :refer [try+]]))

(defn get [conn {:keys [task_id] :as req}]
  (request conn :get (fmt-uri "_tasks" task_id) req))

(defn cancel [conn {:keys [task_id actions] :as req}]
  (request conn :post (fmt-uri "_tasks" task_id "_cancel") req))

(def list get)
