(ns elasticsearch.common
  (:require [clojure.string :as str]
            [elasticsearch.connection :as conn]
            [ring.util.codec :refer [url-encode]]))

(defn coerce [x]
  (cond  (coll? x) (str/join "," x)
         (string? x) (str/replace x #" " "")
         :else (str x)))

(defn fmt-uri [& parts]
  (->> parts
       (filter identity)
       (map coerce)
       (map url-encode)
       (str/join "/")
       (format "/%s")))

(defn sanitize-params [req]
  (let [params (dissoc req :index :type :id :body :ignore :uri)]
    (reduce-kv (fn [acc k v]
                 (let [v (if (coll? v)
                           (str/join "," v)
                           v)]
                   (assoc acc k v)))
               {}
               params)))

(defn query-params [req]
  (let [params (sanitize-params req)]
    (assoc {} :query-params params)))

(defn request [conn method uri req & [opts]]
  (let [req (assoc req :uri uri)
        opts (merge-with merge (query-params req) opts)]
    (conn/request conn method (merge-with merge req opts))))
