(defproject elastic/elasticsearch-clojure "0.99.2-SNAPSHOT"
  :description "A low-level HTTP client for Elasticsearch"
  :url "https://github.com/elastic/elasticsearch-clojure"
  :license {:name "Apache License, Version 2.0"
            :url "https://www.apache.org/licenses/LICENSE-2.0"}
  :global-vars {*warn-on-reflection* false}
  :min-lein-version "2.0.0"
  :dependencies [[cheshire "5.6.1"]
                 [circleci/clj-yaml "0.5.5"
                  :exclusions [[org.clojure/clojure]]]
                 [clj-http "2.0.0"]
                 [slingshot "0.12.2"]
                 [prismatic/schema "1.1.0"]]
  :profiles {:dev {:dependencies [[org.clojure/clojure "1.8.0"]]}
             :1.6 {:dependencies [[org.clojure/clojure "1.6.0"]]}
             :1.7 {:dependencies [[org.clojure/clojure "1.7.0"]]}
             :package {:dependencies [[org.clojure/clojure "1.8.0"]]
                       :aot :all}}
  :aliases {"all" ["with-profile" "dev,1.6:dev,1.7:dev"]
            "publish" ["with-profile" "package" "deploy" "clojars"]}
  :plugins []
  :aot :all
  :test-selectors {:default  #(not (:integration %))
                   :integration :integration
                   :all (constantly true)})
