(ns elasticsearch.scroll
  (:require [elasticsearch.connection :as conn]
            [elasticsearch.document :as doc]
            [schema.core :as s]
            [slingshot.slingshot :refer [try+ throw+]]))

(s/defn scroll*
  ([conn id ttl]
   (let [{:keys [_scroll_id hits]}
         (conn/request conn :get {:body {:scroll ttl
                                         :scroll_id id}
                                  :uri "/_search/scroll"})
         hits* (:hits hits)]
     (lazy-seq
      (when (seq hits*)
        (cons (first hits*)
              (concat
               (rest hits*)
               (scroll* conn _scroll_id ttl))))))))


(s/defn scroll
  ""
  ([conn req]
   (let [req* (update-in req [:query-params :scroll] (fnil identity "10s"))
         {:keys [_scroll_id hits] :as resp} (doc/search conn req*)
         hits* (:hits hits)]
     (when (seq hits*)
       (concat hits*  (scroll* conn _scroll_id
                               (get-in req* [:query-params :scroll])))))))
