(ns elasticsearch.indices
  (:refer-clojure :exclude [type count])
  (:require [elasticsearch.connection :as conn]))

(defn request [conn method fmt req]
  (conn/request conn method (assoc req :uri (apply format fmt))))

(defn create
  ([conn index]
   (create conn index {}))
  ([conn index req]
   (request conn :put ["/%s" index] req)))

(defn delete
  ([conn index]
   (delete conn index {}))
  ([conn index req]
   (request conn :delete ["/%s" index] req)))

(defn get-settings
  ([conn index]
   (get-settings conn index {}))
  ([conn index req]
   (request conn :get ["/%s/_settings" index] req)))

(defn put-mapping
  ([conn index type req]
   (request conn :get ["/%s/%s/_mapping" index type] req)))

(defn health
  ([conn idx]
   (health conn idx {}))
  ([conn idx req]
   (request conn :get ["/_cluster/health/%s" idx] req)))

(defn wait-for-health
  ([conn idx status]
   (wait-for-health conn idx status {}))
  ([conn idx status req]
   (health conn idx (merge-with merge
                     {:query-params
                      {:wait_for_status (name status)}}
                     req))))

(defn refresh
  ([conn idx]
   (refresh conn idx {}))
  ([conn idx req]
   (request conn :post ["/%s/_refresh" idx] req)))

(defn count
  ([conn idx]
   (count conn idx {}))
  ([conn idx req]
   (request conn :get ["/%s/_count" idx] req)))
