(ns elasticsearch.search
  (:require [elasticsearch.connection :as conn]))

#_(defn scroll*
  "One set of hits mid-scroll."
  [target id ttl]
  (try+
   (let [resp (http/get
               (scroll-url target)
               (merge {:body id
                       :query-params {:scroll ttl}}
                      (.opts target)))]
     (json/decode (:body resp) true))
   (catch Object {:keys [body]}
     (cond
       (re-find #"SearchContextMissingException" body)
       (throw+ {:type ::search-context-missing})
       :else (throw+ {:type ::wat})))))

#_(defn scroll
  "lazy-seq of hits from on originating scroll_id."
  [target id ttl]
  (let [resp (scroll* target id ttl)
        hits (-> resp :hits :hits)
        new-id (:_scroll_id resp)]
    (lazy-seq
     (when (seq hits)
       (cons (first hits)
             (concat (rest hits)
                     (scroll target new-id ttl)))))))

#_(defn scan1
  "Set up scroll context."
  [target query ttl size]
  (let [resp (http/get
              (search-url target)
              (merge {:body query
                      :query-params
                      {:search_type "scan"
                       :scroll ttl
                       :size size
                       :fields "_source,_routing,_parent"}}
                     (.opts target)))]
    (json/decode (:body resp) true)))

#_(defn scan
  "Client entry point. Returns a scrolling lazy-seq of hits."
  [target query ttl size]
  (let [resp (scan1 target query ttl size)]
        (scroll target (:_scroll_id resp) ttl)))
