/*
 * Decompiled with CFR 0.152.
 */
package com.cartodb;

import com.cartodb.XAuthAPI;
import java.util.Map;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuth10aServiceImpl;

class XAuth
extends OAuth10aServiceImpl {
    private OAuthConfig config;
    private XAuthAPI api;

    public XAuth(XAuthAPI api, OAuthConfig config) {
        super(api, config);
        this.api = api;
        this.config = config;
    }

    @Override
    public Token getAccessToken(Token requestToken, Verifier verifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        if (requestToken != null) {
            request.addOAuthParameter("oauth_token", requestToken.getToken());
            request.addOAuthParameter("oauth_verifier", verifier.getValue());
        }
        request.addBodyParameter("x_auth_username", this.api.getUsername());
        request.addBodyParameter("x_auth_password", this.api.getPassword());
        request.addBodyParameter("x_auth_mode", "client_auth");
        this.addOAuthParams(request, requestToken);
        this.addSignature(request);
        Response response = request.send();
        String body = response.getBody();
        return this.api.getAccessTokenExtractor().extract(body);
    }

    private void addOAuthParams(OAuthRequest request, Token token) {
        request.addOAuthParameter("oauth_timestamp", this.api.getTimestampService().getTimestampInSeconds());
        request.addOAuthParameter("oauth_nonce", this.api.getTimestampService().getNonce());
        request.addOAuthParameter("oauth_consumer_key", this.config.getApiKey());
        request.addOAuthParameter("oauth_signature_method", this.api.getSignatureService().getSignatureMethod());
        request.addOAuthParameter("oauth_version", this.getVersion());
        if (this.config.hasScope()) {
            request.addOAuthParameter("scope", this.config.getScope());
        }
        request.addOAuthParameter("oauth_signature", this.getSignature(request, token));
    }

    private String getSignature(OAuthRequest request, Token token) {
        String baseString = this.api.getBaseStringExtractor().extract(request);
        return this.api.getSignatureService().getSignature(baseString, this.config.getApiSecret(), "");
    }

    private void addSignature(OAuthRequest request) {
        switch (this.config.getSignatureType()) {
            case Header: {
                String oauthHeader = this.api.getHeaderExtractor().extract(request);
                request.addHeader("Authorization", oauthHeader);
                break;
            }
            case QueryString: {
                for (Map.Entry<String, String> entry : request.getOauthParameters().entrySet()) {
                    request.addQuerystringParameter(entry.getKey(), entry.getValue());
                }
                break;
            }
        }
    }
}

