/*
 * Decompiled with CFR 0.152.
 */
package com.cartodb;

import com.cartodb.XAuth;
import com.cartodb.XAuthAPI;
import org.scribe.model.OAuthConfig;
import org.scribe.oauth.OAuthService;

public class CartoDBAPI
extends XAuthAPI {
    private static final String REQUEST_TOKEN_RESOURCE = ".cartodb.com/oauth/request_token";
    private static final String ACCESS_TOKEN_RESOURCE = ".cartodb.com/oauth/access_token";
    protected String username;
    protected String password;

    public CartoDBAPI(String user, String password) {
        this.username = user;
        this.password = password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public OAuthService createService(OAuthConfig config) {
        return new XAuth(this, config);
    }

    @Override
    public String getAccessTokenEndpoint() {
        return "http://" + this.username + ACCESS_TOKEN_RESOURCE;
    }

    @Override
    public String getRequestTokenEndpoint() {
        return "http://" + this.username + REQUEST_TOKEN_RESOURCE;
    }

    public static class SSL
    extends CartoDBAPI {
        public SSL(String user, String password) {
            super(user, password);
        }

        @Override
        public String getAccessTokenEndpoint() {
            return "https://" + this.username + CartoDBAPI.ACCESS_TOKEN_RESOURCE;
        }

        @Override
        public String getRequestTokenEndpoint() {
            return "https://" + this.username + CartoDBAPI.REQUEST_TOKEN_RESOURCE;
        }

        @Override
        public OAuthService createService(OAuthConfig config) {
            return new XAuth(this, config);
        }
    }
}

