(ns writecsv
  (:require [clojure-csv.core :as csv])
  (:require [clojure.java.io :as io]))

(defn write-csv-file
  "Writes a csv file using a key and an s-o-s"
  [out-sos out-file]
  (spit out-file "" :append false)
  (with-open [out-data (io/writer out-file)]
      (println out-data 666 out-sos)
      (csv/write-csv out-data out-sos)))

(write-csv-file ["44999" "186300" "194300" "0" "380600" "325" "57" "0"]
                "/tmp/re_values.csv")

(println (slurp (io/file "/tmp/re_values.csv")))