(ns so.core
  (:use seesaw.core)
  (:use seesaw.mig))

(native!)

(defn mig [cmd-text, result-text]
  (mig-panel
    :constraints ["wrap 2"
                  "[shrink 0]20px[200, grow, fill]"
                  "[shrink 0]5px[]"]
    :items [["Command:"] [cmd-text]
            ["Result:"] [result-text]]))

(let [cmd-text (text)
      result-text (text :editable? false)
      fr (frame :title "my app" :size [600 :by 400])
      close-f (fn [e] (hide! fr))
      a-close (action :handler close-f 
                      :name "Close" 
                      :tip "Close the window"
                      :key "menu W")
      menus (menubar
              :items [(menu :text "File" :items [a-close])])]
  (config! fr :menubar menus)
  (config! fr :content (mig cmd-text result-text))
  (move! fr :to [300 300])
  (listen cmd-text :key-pressed
          (fn [e] (when (= 10 (.getKeyCode e))
                    (config! result-text :content "Doing something!"))))
  (show! fr))