// Compiled by ClojureScript 1.10.238 {}
goog.provide('schema.coerce');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('schema.core');
goog.require('schema.spec.core');
goog.require('schema.utils');
goog.require('clojure.string');
/**
 * A Schema for Schemas
 */
schema.coerce.Schema = cljs.core.with_meta.call(null,schema.core.__GT_Protocol.call(null,schema.core.Schema),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"proto-sym","proto-sym",-886371734),new cljs.core.Symbol("s","Schema","s/Schema",-1305723789,null),new cljs.core.Keyword(null,"proto-pred","proto-pred",1885698716),(function (p1__4894__4895__auto__){
if(!((p1__4894__4895__auto__ == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__4894__4895__auto__.schema$core$Schema$)))){
return true;
} else {
if((!p1__4894__4895__auto__.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__4894__4895__auto__);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,schema.core.Schema,p1__4894__4895__auto__);
}
})], null));
/**
 * A function from schema to coercion function, or nil if no special coercion is needed.
 * The returned function is applied to the corresponding data before validation (or walking/
 * coercion of its sub-schemas, if applicable)
 */
schema.coerce.CoercionMatcher = schema.core.make_fn_schema.call(null,schema.core.maybe.call(null,schema.core.make_fn_schema.call(null,schema.core.Any,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null)], null))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.coerce.Schema,new cljs.core.Symbol(null,"arg0","arg0",-1024593414,null))], null)], null));
var ufv___6685 = schema.utils.use_fn_validation;
var output_schema6678_6686 = schema.core.Any;
var input_schema6679_6687 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.coerce.CoercionMatcher,cljs.core.with_meta(new cljs.core.Symbol(null,"coercion-matcher","coercion-matcher",-1929420453,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null)], null)))], null);
var input_checker6680_6688 = (new cljs.core.Delay(((function (ufv___6685,output_schema6678_6686,input_schema6679_6687){
return (function (){
return schema.core.checker.call(null,input_schema6679_6687);
});})(ufv___6685,output_schema6678_6686,input_schema6679_6687))
,null));
var output_checker6681_6689 = (new cljs.core.Delay(((function (ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688){
return (function (){
return schema.core.checker.call(null,output_schema6678_6686);
});})(ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688))
,null));
var ret__5754__auto___6690 = /**
 * Inputs: [schema coercion-matcher :- CoercionMatcher]
 * 
 *   Produce a function that simultaneously coerces and validates a datum.  Returns
 * a coerced value, or a schema.utils.ErrorContainer describing the error.
 */
schema.coerce.coercer = ((function (ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688,output_checker6681_6689){
return (function schema$coerce$coercer(G__6682,G__6683){
var validate__4173__auto__ = cljs.core.deref.call(null,ufv___6685);
if(cljs.core.truth_(validate__4173__auto__)){
var args__4174__auto___6691 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__6682,G__6683], null);
if(cljs.core.truth_(schema.core.fn_validator)){
schema.core.fn_validator.call(null,new cljs.core.Keyword(null,"input","input",556931961),cljs.core.with_meta(new cljs.core.Symbol(null,"coercer","coercer",-783242414,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Produce a function that simultaneously coerces and validates a datum.  Returns\n   a coerced value, or a schema.utils.ErrorContainer describing the error."], null)),input_schema6679_6687,cljs.core.deref.call(null,input_checker6680_6688),args__4174__auto___6691);
} else {
var temp__5457__auto___6692 = cljs.core.deref.call(null,input_checker6680_6688).call(null,args__4174__auto___6691);
if(cljs.core.truth_(temp__5457__auto___6692)){
var error__4175__auto___6693 = temp__5457__auto___6692;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.with_meta(new cljs.core.Symbol(null,"coercer","coercer",-783242414,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Produce a function that simultaneously coerces and validates a datum.  Returns\n   a coerced value, or a schema.utils.ErrorContainer describing the error."], null)),cljs.core.pr_str.call(null,error__4175__auto___6693)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema6679_6687,new cljs.core.Keyword(null,"value","value",305978217),args__4174__auto___6691,new cljs.core.Keyword(null,"error","error",-978969032),error__4175__auto___6693], null));
} else {
}
}
} else {
}

var o__4176__auto__ = (function (){var schema__$1 = G__6682;
var coercion_matcher = G__6683;
while(true){
return schema.spec.core.run_checker.call(null,((function (validate__4173__auto__,ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688,output_checker6681_6689){
return (function (s,params){
var c = schema.spec.core.checker.call(null,schema.core.spec.call(null,s),params);
var temp__5455__auto__ = coercion_matcher.call(null,s);
if(cljs.core.truth_(temp__5455__auto__)){
var coercer = temp__5455__auto__;
return ((function (coercer,temp__5455__auto__,c,validate__4173__auto__,ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688,output_checker6681_6689){
return (function (x){
try{var v = coercer.call(null,x);
if(cljs.core.truth_(schema.utils.error_QMARK_.call(null,v))){
return v;
} else {
return c.call(null,v);
}
}catch (e6684){if((e6684 instanceof Object)){
var t = e6684;
return schema.utils.error.call(null,schema.utils.make_ValidationError.call(null,s,x,(new cljs.core.Delay(((function (t,coercer,temp__5455__auto__,c,validate__4173__auto__,ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688,output_checker6681_6689){
return (function (){
return t;
});})(t,coercer,temp__5455__auto__,c,validate__4173__auto__,ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688,output_checker6681_6689))
,null)),null));
} else {
throw e6684;

}
}});
;})(coercer,temp__5455__auto__,c,validate__4173__auto__,ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688,output_checker6681_6689))
} else {
return c;
}
});})(validate__4173__auto__,ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688,output_checker6681_6689))
,true,schema__$1);
break;
}
})();
if(cljs.core.truth_(validate__4173__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
schema.core.fn_validator.call(null,new cljs.core.Keyword(null,"output","output",-1105869043),cljs.core.with_meta(new cljs.core.Symbol(null,"coercer","coercer",-783242414,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Produce a function that simultaneously coerces and validates a datum.  Returns\n   a coerced value, or a schema.utils.ErrorContainer describing the error."], null)),output_schema6678_6686,cljs.core.deref.call(null,output_checker6681_6689),o__4176__auto__);
} else {
var temp__5457__auto___6694 = cljs.core.deref.call(null,output_checker6681_6689).call(null,o__4176__auto__);
if(cljs.core.truth_(temp__5457__auto___6694)){
var error__4175__auto___6695 = temp__5457__auto___6694;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.with_meta(new cljs.core.Symbol(null,"coercer","coercer",-783242414,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Produce a function that simultaneously coerces and validates a datum.  Returns\n   a coerced value, or a schema.utils.ErrorContainer describing the error."], null)),cljs.core.pr_str.call(null,error__4175__auto___6695)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema6678_6686,new cljs.core.Keyword(null,"value","value",305978217),o__4176__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__4175__auto___6695], null));
} else {
}
}
} else {
}

return o__4176__auto__;
});})(ufv___6685,output_schema6678_6686,input_schema6679_6687,input_checker6680_6688,output_checker6681_6689))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,schema.coerce.coercer),schema.core.__GT_FnSchema.call(null,output_schema6678_6686,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema6679_6687], null)));

var ufv___6702 = schema.utils.use_fn_validation;
var output_schema6696_6703 = schema.core.Any;
var input_schema6697_6704 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,schema.core.Any,cljs.core.with_meta(new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null)], null))),schema.core.one.call(null,schema.coerce.CoercionMatcher,cljs.core.with_meta(new cljs.core.Symbol(null,"coercion-matcher","coercion-matcher",-1929420453,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null)], null)))], null);
var input_checker6698_6705 = (new cljs.core.Delay(((function (ufv___6702,output_schema6696_6703,input_schema6697_6704){
return (function (){
return schema.core.checker.call(null,input_schema6697_6704);
});})(ufv___6702,output_schema6696_6703,input_schema6697_6704))
,null));
var output_checker6699_6706 = (new cljs.core.Delay(((function (ufv___6702,output_schema6696_6703,input_schema6697_6704,input_checker6698_6705){
return (function (){
return schema.core.checker.call(null,output_schema6696_6703);
});})(ufv___6702,output_schema6696_6703,input_schema6697_6704,input_checker6698_6705))
,null));
var ret__5754__auto___6707 = /**
 * Inputs: [schema coercion-matcher :- CoercionMatcher]
 * 
 *   Like `coercer`, but is guaranteed to return a value that satisfies schema (or throw).
 */
schema.coerce.coercer_BANG_ = ((function (ufv___6702,output_schema6696_6703,input_schema6697_6704,input_checker6698_6705,output_checker6699_6706){
return (function schema$coerce$coercer_BANG_(G__6700,G__6701){
var validate__4173__auto__ = cljs.core.deref.call(null,ufv___6702);
if(cljs.core.truth_(validate__4173__auto__)){
var args__4174__auto___6708 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__6700,G__6701], null);
if(cljs.core.truth_(schema.core.fn_validator)){
schema.core.fn_validator.call(null,new cljs.core.Keyword(null,"input","input",556931961),cljs.core.with_meta(new cljs.core.Symbol(null,"coercer!","coercer!",1324120992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Like `coercer`, but is guaranteed to return a value that satisfies schema (or throw)."], null)),input_schema6697_6704,cljs.core.deref.call(null,input_checker6698_6705),args__4174__auto___6708);
} else {
var temp__5457__auto___6709 = cljs.core.deref.call(null,input_checker6698_6705).call(null,args__4174__auto___6708);
if(cljs.core.truth_(temp__5457__auto___6709)){
var error__4175__auto___6710 = temp__5457__auto___6709;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.with_meta(new cljs.core.Symbol(null,"coercer!","coercer!",1324120992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Like `coercer`, but is guaranteed to return a value that satisfies schema (or throw)."], null)),cljs.core.pr_str.call(null,error__4175__auto___6710)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema6697_6704,new cljs.core.Keyword(null,"value","value",305978217),args__4174__auto___6708,new cljs.core.Keyword(null,"error","error",-978969032),error__4175__auto___6710], null));
} else {
}
}
} else {
}

var o__4176__auto__ = (function (){var schema__$1 = G__6700;
var coercion_matcher = G__6701;
while(true){
var c = schema.coerce.coercer.call(null,schema__$1,coercion_matcher);
return ((function (c,validate__4173__auto__,ufv___6702,output_schema6696_6703,input_schema6697_6704,input_checker6698_6705,output_checker6699_6706){
return (function (value){
var coerced = c.call(null,value);
var temp__5457__auto___6711 = schema.utils.error_val.call(null,coerced);
if(cljs.core.truth_(temp__5457__auto___6711)){
var error_6712 = temp__5457__auto___6711;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Value cannot be coerced to match schema: %s",cljs.core.pr_str.call(null,error_6712)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),schema__$1,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"error","error",-978969032),error_6712], null));
} else {
}

return coerced;
});
;})(c,validate__4173__auto__,ufv___6702,output_schema6696_6703,input_schema6697_6704,input_checker6698_6705,output_checker6699_6706))
break;
}
})();
if(cljs.core.truth_(validate__4173__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
schema.core.fn_validator.call(null,new cljs.core.Keyword(null,"output","output",-1105869043),cljs.core.with_meta(new cljs.core.Symbol(null,"coercer!","coercer!",1324120992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Like `coercer`, but is guaranteed to return a value that satisfies schema (or throw)."], null)),output_schema6696_6703,cljs.core.deref.call(null,output_checker6699_6706),o__4176__auto__);
} else {
var temp__5457__auto___6713 = cljs.core.deref.call(null,output_checker6699_6706).call(null,o__4176__auto__);
if(cljs.core.truth_(temp__5457__auto___6713)){
var error__4175__auto___6714 = temp__5457__auto___6713;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.with_meta(new cljs.core.Symbol(null,"coercer!","coercer!",1324120992,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol("schema.core","Any","schema.core/Any",-1891898271,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"Like `coercer`, but is guaranteed to return a value that satisfies schema (or throw)."], null)),cljs.core.pr_str.call(null,error__4175__auto___6714)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema6696_6703,new cljs.core.Keyword(null,"value","value",305978217),o__4176__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__4175__auto___6714], null));
} else {
}
}
} else {
}

return o__4176__auto__;
});})(ufv___6702,output_schema6696_6703,input_schema6697_6704,input_checker6698_6705,output_checker6699_6706))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,schema.coerce.coercer_BANG_),schema.core.__GT_FnSchema.call(null,output_schema6696_6703,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema6697_6704], null)));

var ufv___6721 = schema.utils.use_fn_validation;
var output_schema6716_6722 = schema.coerce.CoercionMatcher;
var input_schema6717_6723 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.core.one.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [schema.coerce.CoercionMatcher], null),cljs.core.with_meta(new cljs.core.Symbol(null,"matchers","matchers",-39860883,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null)], null)], null)))], null);
var input_checker6718_6724 = (new cljs.core.Delay(((function (ufv___6721,output_schema6716_6722,input_schema6717_6723){
return (function (){
return schema.core.checker.call(null,input_schema6717_6723);
});})(ufv___6721,output_schema6716_6722,input_schema6717_6723))
,null));
var output_checker6719_6725 = (new cljs.core.Delay(((function (ufv___6721,output_schema6716_6722,input_schema6717_6723,input_checker6718_6724){
return (function (){
return schema.core.checker.call(null,output_schema6716_6722);
});})(ufv___6721,output_schema6716_6722,input_schema6717_6723,input_checker6718_6724))
,null));
var ret__5754__auto___6726 = /**
 * Inputs: [matchers :- [CoercionMatcher]]
 *   Returns: CoercionMatcher
 * 
 *   A matcher that takes the first match from matchers.
 */
schema.coerce.first_matcher = ((function (ufv___6721,output_schema6716_6722,input_schema6717_6723,input_checker6718_6724,output_checker6719_6725){
return (function schema$coerce$first_matcher(G__6720){
var validate__4173__auto__ = cljs.core.deref.call(null,ufv___6721);
if(cljs.core.truth_(validate__4173__auto__)){
var args__4174__auto___6727 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [G__6720], null);
if(cljs.core.truth_(schema.core.fn_validator)){
schema.core.fn_validator.call(null,new cljs.core.Keyword(null,"input","input",556931961),cljs.core.with_meta(new cljs.core.Symbol(null,"first-matcher","first-matcher",-2060940642,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"A matcher that takes the first match from matchers."], null)),input_schema6717_6723,cljs.core.deref.call(null,input_checker6718_6724),args__4174__auto___6727);
} else {
var temp__5457__auto___6728 = cljs.core.deref.call(null,input_checker6718_6724).call(null,args__4174__auto___6727);
if(cljs.core.truth_(temp__5457__auto___6728)){
var error__4175__auto___6729 = temp__5457__auto___6728;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Input to %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.with_meta(new cljs.core.Symbol(null,"first-matcher","first-matcher",-2060940642,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"A matcher that takes the first match from matchers."], null)),cljs.core.pr_str.call(null,error__4175__auto___6729)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),input_schema6717_6723,new cljs.core.Keyword(null,"value","value",305978217),args__4174__auto___6727,new cljs.core.Keyword(null,"error","error",-978969032),error__4175__auto___6729], null));
} else {
}
}
} else {
}

var o__4176__auto__ = (function (){var matchers = G__6720;
while(true){
return ((function (validate__4173__auto__,ufv___6721,output_schema6716_6722,input_schema6717_6723,input_checker6718_6724,output_checker6719_6725){
return (function (schema__$1){
return cljs.core.first.call(null,cljs.core.keep.call(null,((function (validate__4173__auto__,ufv___6721,output_schema6716_6722,input_schema6717_6723,input_checker6718_6724,output_checker6719_6725){
return (function (p1__6715_SHARP_){
return p1__6715_SHARP_.call(null,schema__$1);
});})(validate__4173__auto__,ufv___6721,output_schema6716_6722,input_schema6717_6723,input_checker6718_6724,output_checker6719_6725))
,matchers));
});
;})(validate__4173__auto__,ufv___6721,output_schema6716_6722,input_schema6717_6723,input_checker6718_6724,output_checker6719_6725))
break;
}
})();
if(cljs.core.truth_(validate__4173__auto__)){
if(cljs.core.truth_(schema.core.fn_validator)){
schema.core.fn_validator.call(null,new cljs.core.Keyword(null,"output","output",-1105869043),cljs.core.with_meta(new cljs.core.Symbol(null,"first-matcher","first-matcher",-2060940642,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"A matcher that takes the first match from matchers."], null)),output_schema6716_6722,cljs.core.deref.call(null,output_checker6719_6725),o__4176__auto__);
} else {
var temp__5457__auto___6730 = cljs.core.deref.call(null,output_checker6719_6725).call(null,o__4176__auto__);
if(cljs.core.truth_(temp__5457__auto___6730)){
var error__4175__auto___6731 = temp__5457__auto___6730;
throw cljs.core.ex_info.call(null,schema.utils.format_STAR_.call(null,"Output of %s does not match schema: \n\n\t \u001B[0;33m  %s \u001B[0m \n\n",cljs.core.with_meta(new cljs.core.Symbol(null,"first-matcher","first-matcher",-2060940642,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Symbol(null,"CoercionMatcher","CoercionMatcher",1341105319,null),new cljs.core.Keyword(null,"doc","doc",1913296891),"A matcher that takes the first match from matchers."], null)),cljs.core.pr_str.call(null,error__4175__auto___6731)),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword("schema.core","error","schema.core/error",1991454308),new cljs.core.Keyword(null,"schema","schema",-1582001791),output_schema6716_6722,new cljs.core.Keyword(null,"value","value",305978217),o__4176__auto__,new cljs.core.Keyword(null,"error","error",-978969032),error__4175__auto___6731], null));
} else {
}
}
} else {
}

return o__4176__auto__;
});})(ufv___6721,output_schema6716_6722,input_schema6717_6723,input_checker6718_6724,output_checker6719_6725))
;
schema.utils.declare_class_schema_BANG_.call(null,schema.utils.fn_schema_bearer.call(null,schema.coerce.first_matcher),schema.core.__GT_FnSchema.call(null,output_schema6716_6722,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [input_schema6717_6723], null)));

schema.coerce.string__GT_keyword = (function schema$coerce$string__GT_keyword(s){
if(typeof s === 'string'){
return cljs.core.keyword.call(null,s);
} else {
return s;
}
});
/**
 * returns true for strings that are equal, ignoring case, to the string 'true'
 * (following java.lang.Boolean/parseBoolean semantics)
 */
schema.coerce.string__GT_boolean = (function schema$coerce$string__GT_boolean(s){
if(typeof s === 'string'){
return cljs.core._EQ_.call(null,"true",clojure.string.lower_case.call(null,s));
} else {
return s;
}
});
schema.coerce.keyword_enum_matcher = (function schema$coerce$keyword_enum_matcher(schema__$1){
if((((((schema__$1 instanceof schema.core.EnumSchema)) && (cljs.core.every_QMARK_.call(null,cljs.core.keyword_QMARK_,schema__$1.vs)))) || ((((schema__$1 instanceof schema.core.EqSchema)) && ((schema__$1.v instanceof cljs.core.Keyword)))))){
return schema.coerce.string__GT_keyword;
} else {
return null;
}
});
schema.coerce.set_matcher = (function schema$coerce$set_matcher(schema__$1){
if((schema__$1 instanceof cljs.core.PersistentHashSet)){
return (function (x){
if(cljs.core.sequential_QMARK_.call(null,x)){
return cljs.core.set.call(null,x);
} else {
return x;
}
});
} else {
return null;
}
});
/**
 * Take a single-arg function f, and return a single-arg function that acts as identity
 * if f throws an exception, and like f otherwise.  Useful because coercers are not explicitly
 * guarded for exceptions, and failing to coerce will generally produce a more useful error
 * in this case.
 */
schema.coerce.safe = (function schema$coerce$safe(f){
return (function (x){
try{return f.call(null,x);
}catch (e6732){if((e6732 instanceof Object)){
var e = e6732;
return x;
} else {
throw e6732;

}
}});
});
/**
 * Returns instance of UUID if input is a string.
 * Note: in CLJS, this does not guarantee a specific UUID string representation,
 *       similar to #uuid reader
 */
schema.coerce.string__GT_uuid = (function schema$coerce$string__GT_uuid(p1__6733_SHARP_){
if(typeof p1__6733_SHARP_ === 'string'){
return (new cljs.core.UUID(p1__6733_SHARP_));
} else {
return p1__6733_SHARP_;
}
});
schema.coerce._PLUS_json_coercions_PLUS_ = cljs.core.merge.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Keyword,schema.coerce.string__GT_keyword,schema.core.Bool,schema.coerce.string__GT_boolean,schema.core.Uuid,schema.coerce.string__GT_uuid]));
/**
 * A matcher that coerces keywords and keyword eq/enums from strings, and longs and doubles
 *   from numbers on the JVM (without losing precision)
 */
schema.coerce.json_coercion_matcher = (function schema$coerce$json_coercion_matcher(schema__$1){
var or__3922__auto__ = schema.coerce._PLUS_json_coercions_PLUS_.call(null,schema__$1);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = schema.coerce.keyword_enum_matcher.call(null,schema__$1);
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
return schema.coerce.set_matcher.call(null,schema__$1);
}
}
});
/**
 * Reads one object from a string. Returns nil when string is nil or empty
 */
schema.coerce.edn_read_string = cljs.reader.read_string;
schema.coerce._PLUS_string_coercions_PLUS_ = cljs.core.merge.call(null,schema.coerce._PLUS_json_coercions_PLUS_,cljs.core.PersistentArrayMap.createAsIfByAssoc([schema.core.Num,schema.coerce.safe.call(null,schema.coerce.edn_read_string),schema.core.Int,schema.coerce.safe.call(null,schema.coerce.edn_read_string)]));
/**
 * A matcher that coerces keywords, keyword eq/enums, s/Num and s/Int,
 *   and long and doubles (JVM only) from strings.
 */
schema.coerce.string_coercion_matcher = (function schema$coerce$string_coercion_matcher(schema__$1){
var or__3922__auto__ = schema.coerce._PLUS_string_coercions_PLUS_.call(null,schema__$1);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
var or__3922__auto____$1 = schema.coerce.keyword_enum_matcher.call(null,schema__$1);
if(cljs.core.truth_(or__3922__auto____$1)){
return or__3922__auto____$1;
} else {
return schema.coerce.set_matcher.call(null,schema__$1);
}
}
});

//# sourceMappingURL=coerce.js.map?rel=1531077718522
