// Compiled by ClojureScript 1.10.238 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__8624 = arguments.length;
switch (G__8624) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async8625 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8625 = (function (f,blockable,meta8626){
this.f = f;
this.blockable = blockable;
this.meta8626 = meta8626;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8625.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8627,meta8626__$1){
var self__ = this;
var _8627__$1 = this;
return (new cljs.core.async.t_cljs$core$async8625(self__.f,self__.blockable,meta8626__$1));
});

cljs.core.async.t_cljs$core$async8625.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8627){
var self__ = this;
var _8627__$1 = this;
return self__.meta8626;
});

cljs.core.async.t_cljs$core$async8625.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8625.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8625.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async8625.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async8625.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta8626","meta8626",-818298351,null)], null);
});

cljs.core.async.t_cljs$core$async8625.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8625.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8625";

cljs.core.async.t_cljs$core$async8625.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async8625");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8625.
 */
cljs.core.async.__GT_t_cljs$core$async8625 = (function cljs$core$async$__GT_t_cljs$core$async8625(f__$1,blockable__$1,meta8626){
return (new cljs.core.async.t_cljs$core$async8625(f__$1,blockable__$1,meta8626));
});

}

return (new cljs.core.async.t_cljs$core$async8625(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__8631 = arguments.length;
switch (G__8631) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__8634 = arguments.length;
switch (G__8634) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__8637 = arguments.length;
switch (G__8637) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_8639 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_8639);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_8639,ret){
return (function (){
return fn1.call(null,val_8639);
});})(val_8639,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__8641 = arguments.length;
switch (G__8641) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4376__auto___8643 = n;
var x_8644 = (0);
while(true){
if((x_8644 < n__4376__auto___8643)){
(a[x_8644] = (0));

var G__8645 = (x_8644 + (1));
x_8644 = G__8645;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__8646 = (i + (1));
i = G__8646;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async8647 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8647 = (function (flag,meta8648){
this.flag = flag;
this.meta8648 = meta8648;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8647.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_8649,meta8648__$1){
var self__ = this;
var _8649__$1 = this;
return (new cljs.core.async.t_cljs$core$async8647(self__.flag,meta8648__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async8647.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_8649){
var self__ = this;
var _8649__$1 = this;
return self__.meta8648;
});})(flag))
;

cljs.core.async.t_cljs$core$async8647.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8647.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async8647.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8647.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async8647.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta8648","meta8648",420975195,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async8647.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8647.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8647";

cljs.core.async.t_cljs$core$async8647.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async8647");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8647.
 */
cljs.core.async.__GT_t_cljs$core$async8647 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async8647(flag__$1,meta8648){
return (new cljs.core.async.t_cljs$core$async8647(flag__$1,meta8648));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async8647(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async8650 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8650 = (function (flag,cb,meta8651){
this.flag = flag;
this.cb = cb;
this.meta8651 = meta8651;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async8650.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8652,meta8651__$1){
var self__ = this;
var _8652__$1 = this;
return (new cljs.core.async.t_cljs$core$async8650(self__.flag,self__.cb,meta8651__$1));
});

cljs.core.async.t_cljs$core$async8650.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8652){
var self__ = this;
var _8652__$1 = this;
return self__.meta8651;
});

cljs.core.async.t_cljs$core$async8650.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async8650.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async8650.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async8650.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async8650.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta8651","meta8651",-1553627596,null)], null);
});

cljs.core.async.t_cljs$core$async8650.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async8650.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8650";

cljs.core.async.t_cljs$core$async8650.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async8650");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8650.
 */
cljs.core.async.__GT_t_cljs$core$async8650 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async8650(flag__$1,cb__$1,meta8651){
return (new cljs.core.async.t_cljs$core$async8650(flag__$1,cb__$1,meta8651));
});

}

return (new cljs.core.async.t_cljs$core$async8650(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8653_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8653_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8654_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8654_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__3922__auto__ = wport;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return port;
}
})()], null));
} else {
var G__8655 = (i + (1));
i = G__8655;
continue;
}
} else {
return null;
}
break;
}
})();
var or__3922__auto__ = ret;
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__3911__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__3911__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__3911__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___8661 = arguments.length;
var i__4500__auto___8662 = (0);
while(true){
if((i__4500__auto___8662 < len__4499__auto___8661)){
args__4502__auto__.push((arguments[i__4500__auto___8662]));

var G__8663 = (i__4500__auto___8662 + (1));
i__4500__auto___8662 = G__8663;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((1) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4503__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__8658){
var map__8659 = p__8658;
var map__8659__$1 = ((((!((map__8659 == null)))?(((((map__8659.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8659.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__8659):map__8659);
var opts = map__8659__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq8656){
var G__8657 = cljs.core.first.call(null,seq8656);
var seq8656__$1 = cljs.core.next.call(null,seq8656);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8657,seq8656__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__8665 = arguments.length;
switch (G__8665) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8564__auto___8711 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___8711){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___8711){
return (function (state_8689){
var state_val_8690 = (state_8689[(1)]);
if((state_val_8690 === (7))){
var inst_8685 = (state_8689[(2)]);
var state_8689__$1 = state_8689;
var statearr_8691_8712 = state_8689__$1;
(statearr_8691_8712[(2)] = inst_8685);

(statearr_8691_8712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (1))){
var state_8689__$1 = state_8689;
var statearr_8692_8713 = state_8689__$1;
(statearr_8692_8713[(2)] = null);

(statearr_8692_8713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (4))){
var inst_8668 = (state_8689[(7)]);
var inst_8668__$1 = (state_8689[(2)]);
var inst_8669 = (inst_8668__$1 == null);
var state_8689__$1 = (function (){var statearr_8693 = state_8689;
(statearr_8693[(7)] = inst_8668__$1);

return statearr_8693;
})();
if(cljs.core.truth_(inst_8669)){
var statearr_8694_8714 = state_8689__$1;
(statearr_8694_8714[(1)] = (5));

} else {
var statearr_8695_8715 = state_8689__$1;
(statearr_8695_8715[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (13))){
var state_8689__$1 = state_8689;
var statearr_8696_8716 = state_8689__$1;
(statearr_8696_8716[(2)] = null);

(statearr_8696_8716[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (6))){
var inst_8668 = (state_8689[(7)]);
var state_8689__$1 = state_8689;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8689__$1,(11),to,inst_8668);
} else {
if((state_val_8690 === (3))){
var inst_8687 = (state_8689[(2)]);
var state_8689__$1 = state_8689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8689__$1,inst_8687);
} else {
if((state_val_8690 === (12))){
var state_8689__$1 = state_8689;
var statearr_8697_8717 = state_8689__$1;
(statearr_8697_8717[(2)] = null);

(statearr_8697_8717[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (2))){
var state_8689__$1 = state_8689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8689__$1,(4),from);
} else {
if((state_val_8690 === (11))){
var inst_8678 = (state_8689[(2)]);
var state_8689__$1 = state_8689;
if(cljs.core.truth_(inst_8678)){
var statearr_8698_8718 = state_8689__$1;
(statearr_8698_8718[(1)] = (12));

} else {
var statearr_8699_8719 = state_8689__$1;
(statearr_8699_8719[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (9))){
var state_8689__$1 = state_8689;
var statearr_8700_8720 = state_8689__$1;
(statearr_8700_8720[(2)] = null);

(statearr_8700_8720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (5))){
var state_8689__$1 = state_8689;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8701_8721 = state_8689__$1;
(statearr_8701_8721[(1)] = (8));

} else {
var statearr_8702_8722 = state_8689__$1;
(statearr_8702_8722[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (14))){
var inst_8683 = (state_8689[(2)]);
var state_8689__$1 = state_8689;
var statearr_8703_8723 = state_8689__$1;
(statearr_8703_8723[(2)] = inst_8683);

(statearr_8703_8723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (10))){
var inst_8675 = (state_8689[(2)]);
var state_8689__$1 = state_8689;
var statearr_8704_8724 = state_8689__$1;
(statearr_8704_8724[(2)] = inst_8675);

(statearr_8704_8724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8690 === (8))){
var inst_8672 = cljs.core.async.close_BANG_.call(null,to);
var state_8689__$1 = state_8689;
var statearr_8705_8725 = state_8689__$1;
(statearr_8705_8725[(2)] = inst_8672);

(statearr_8705_8725[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___8711))
;
return ((function (switch__8474__auto__,c__8564__auto___8711){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_8706 = [null,null,null,null,null,null,null,null];
(statearr_8706[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_8706[(1)] = (1));

return statearr_8706;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_8689){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_8689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e8707){if((e8707 instanceof Object)){
var ex__8478__auto__ = e8707;
var statearr_8708_8726 = state_8689;
(statearr_8708_8726[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8707;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8727 = state_8689;
state_8689 = G__8727;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_8689){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_8689);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___8711))
})();
var state__8566__auto__ = (function (){var statearr_8709 = f__8565__auto__.call(null);
(statearr_8709[(6)] = c__8564__auto___8711);

return statearr_8709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___8711))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__8728){
var vec__8729 = p__8728;
var v = cljs.core.nth.call(null,vec__8729,(0),null);
var p = cljs.core.nth.call(null,vec__8729,(1),null);
var job = vec__8729;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__8564__auto___8900 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___8900,res,vec__8729,v,p,job,jobs,results){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___8900,res,vec__8729,v,p,job,jobs,results){
return (function (state_8736){
var state_val_8737 = (state_8736[(1)]);
if((state_val_8737 === (1))){
var state_8736__$1 = state_8736;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8736__$1,(2),res,v);
} else {
if((state_val_8737 === (2))){
var inst_8733 = (state_8736[(2)]);
var inst_8734 = cljs.core.async.close_BANG_.call(null,res);
var state_8736__$1 = (function (){var statearr_8738 = state_8736;
(statearr_8738[(7)] = inst_8733);

return statearr_8738;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8736__$1,inst_8734);
} else {
return null;
}
}
});})(c__8564__auto___8900,res,vec__8729,v,p,job,jobs,results))
;
return ((function (switch__8474__auto__,c__8564__auto___8900,res,vec__8729,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0 = (function (){
var statearr_8739 = [null,null,null,null,null,null,null,null];
(statearr_8739[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__);

(statearr_8739[(1)] = (1));

return statearr_8739;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1 = (function (state_8736){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_8736);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e8740){if((e8740 instanceof Object)){
var ex__8478__auto__ = e8740;
var statearr_8741_8901 = state_8736;
(statearr_8741_8901[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8736);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8740;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8902 = state_8736;
state_8736 = G__8902;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = function(state_8736){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1.call(this,state_8736);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___8900,res,vec__8729,v,p,job,jobs,results))
})();
var state__8566__auto__ = (function (){var statearr_8742 = f__8565__auto__.call(null);
(statearr_8742[(6)] = c__8564__auto___8900);

return statearr_8742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___8900,res,vec__8729,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__8743){
var vec__8744 = p__8743;
var v = cljs.core.nth.call(null,vec__8744,(0),null);
var p = cljs.core.nth.call(null,vec__8744,(1),null);
var job = vec__8744;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4376__auto___8903 = n;
var __8904 = (0);
while(true){
if((__8904 < n__4376__auto___8903)){
var G__8747_8905 = type;
var G__8747_8906__$1 = (((G__8747_8905 instanceof cljs.core.Keyword))?G__8747_8905.fqn:null);
switch (G__8747_8906__$1) {
case "compute":
var c__8564__auto___8908 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__8904,c__8564__auto___8908,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (__8904,c__8564__auto___8908,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async){
return (function (state_8760){
var state_val_8761 = (state_8760[(1)]);
if((state_val_8761 === (1))){
var state_8760__$1 = state_8760;
var statearr_8762_8909 = state_8760__$1;
(statearr_8762_8909[(2)] = null);

(statearr_8762_8909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8761 === (2))){
var state_8760__$1 = state_8760;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8760__$1,(4),jobs);
} else {
if((state_val_8761 === (3))){
var inst_8758 = (state_8760[(2)]);
var state_8760__$1 = state_8760;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8760__$1,inst_8758);
} else {
if((state_val_8761 === (4))){
var inst_8750 = (state_8760[(2)]);
var inst_8751 = process.call(null,inst_8750);
var state_8760__$1 = state_8760;
if(cljs.core.truth_(inst_8751)){
var statearr_8763_8910 = state_8760__$1;
(statearr_8763_8910[(1)] = (5));

} else {
var statearr_8764_8911 = state_8760__$1;
(statearr_8764_8911[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8761 === (5))){
var state_8760__$1 = state_8760;
var statearr_8765_8912 = state_8760__$1;
(statearr_8765_8912[(2)] = null);

(statearr_8765_8912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8761 === (6))){
var state_8760__$1 = state_8760;
var statearr_8766_8913 = state_8760__$1;
(statearr_8766_8913[(2)] = null);

(statearr_8766_8913[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8761 === (7))){
var inst_8756 = (state_8760[(2)]);
var state_8760__$1 = state_8760;
var statearr_8767_8914 = state_8760__$1;
(statearr_8767_8914[(2)] = inst_8756);

(statearr_8767_8914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8904,c__8564__auto___8908,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async))
;
return ((function (__8904,switch__8474__auto__,c__8564__auto___8908,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0 = (function (){
var statearr_8768 = [null,null,null,null,null,null,null];
(statearr_8768[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__);

(statearr_8768[(1)] = (1));

return statearr_8768;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1 = (function (state_8760){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_8760);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e8769){if((e8769 instanceof Object)){
var ex__8478__auto__ = e8769;
var statearr_8770_8915 = state_8760;
(statearr_8770_8915[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8760);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8769;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8916 = state_8760;
state_8760 = G__8916;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = function(state_8760){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1.call(this,state_8760);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__;
})()
;})(__8904,switch__8474__auto__,c__8564__auto___8908,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async))
})();
var state__8566__auto__ = (function (){var statearr_8771 = f__8565__auto__.call(null);
(statearr_8771[(6)] = c__8564__auto___8908);

return statearr_8771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(__8904,c__8564__auto___8908,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async))
);


break;
case "async":
var c__8564__auto___8917 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__8904,c__8564__auto___8917,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (__8904,c__8564__auto___8917,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async){
return (function (state_8784){
var state_val_8785 = (state_8784[(1)]);
if((state_val_8785 === (1))){
var state_8784__$1 = state_8784;
var statearr_8786_8918 = state_8784__$1;
(statearr_8786_8918[(2)] = null);

(statearr_8786_8918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8785 === (2))){
var state_8784__$1 = state_8784;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8784__$1,(4),jobs);
} else {
if((state_val_8785 === (3))){
var inst_8782 = (state_8784[(2)]);
var state_8784__$1 = state_8784;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8784__$1,inst_8782);
} else {
if((state_val_8785 === (4))){
var inst_8774 = (state_8784[(2)]);
var inst_8775 = async.call(null,inst_8774);
var state_8784__$1 = state_8784;
if(cljs.core.truth_(inst_8775)){
var statearr_8787_8919 = state_8784__$1;
(statearr_8787_8919[(1)] = (5));

} else {
var statearr_8788_8920 = state_8784__$1;
(statearr_8788_8920[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8785 === (5))){
var state_8784__$1 = state_8784;
var statearr_8789_8921 = state_8784__$1;
(statearr_8789_8921[(2)] = null);

(statearr_8789_8921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8785 === (6))){
var state_8784__$1 = state_8784;
var statearr_8790_8922 = state_8784__$1;
(statearr_8790_8922[(2)] = null);

(statearr_8790_8922[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8785 === (7))){
var inst_8780 = (state_8784[(2)]);
var state_8784__$1 = state_8784;
var statearr_8791_8923 = state_8784__$1;
(statearr_8791_8923[(2)] = inst_8780);

(statearr_8791_8923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8904,c__8564__auto___8917,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async))
;
return ((function (__8904,switch__8474__auto__,c__8564__auto___8917,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0 = (function (){
var statearr_8792 = [null,null,null,null,null,null,null];
(statearr_8792[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__);

(statearr_8792[(1)] = (1));

return statearr_8792;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1 = (function (state_8784){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_8784);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e8793){if((e8793 instanceof Object)){
var ex__8478__auto__ = e8793;
var statearr_8794_8924 = state_8784;
(statearr_8794_8924[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8784);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8793;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8925 = state_8784;
state_8784 = G__8925;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = function(state_8784){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1.call(this,state_8784);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__;
})()
;})(__8904,switch__8474__auto__,c__8564__auto___8917,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async))
})();
var state__8566__auto__ = (function (){var statearr_8795 = f__8565__auto__.call(null);
(statearr_8795[(6)] = c__8564__auto___8917);

return statearr_8795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(__8904,c__8564__auto___8917,G__8747_8905,G__8747_8906__$1,n__4376__auto___8903,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__8747_8906__$1)].join('')));

}

var G__8926 = (__8904 + (1));
__8904 = G__8926;
continue;
} else {
}
break;
}

var c__8564__auto___8927 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___8927,jobs,results,process,async){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___8927,jobs,results,process,async){
return (function (state_8817){
var state_val_8818 = (state_8817[(1)]);
if((state_val_8818 === (1))){
var state_8817__$1 = state_8817;
var statearr_8819_8928 = state_8817__$1;
(statearr_8819_8928[(2)] = null);

(statearr_8819_8928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8818 === (2))){
var state_8817__$1 = state_8817;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8817__$1,(4),from);
} else {
if((state_val_8818 === (3))){
var inst_8815 = (state_8817[(2)]);
var state_8817__$1 = state_8817;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8817__$1,inst_8815);
} else {
if((state_val_8818 === (4))){
var inst_8798 = (state_8817[(7)]);
var inst_8798__$1 = (state_8817[(2)]);
var inst_8799 = (inst_8798__$1 == null);
var state_8817__$1 = (function (){var statearr_8820 = state_8817;
(statearr_8820[(7)] = inst_8798__$1);

return statearr_8820;
})();
if(cljs.core.truth_(inst_8799)){
var statearr_8821_8929 = state_8817__$1;
(statearr_8821_8929[(1)] = (5));

} else {
var statearr_8822_8930 = state_8817__$1;
(statearr_8822_8930[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8818 === (5))){
var inst_8801 = cljs.core.async.close_BANG_.call(null,jobs);
var state_8817__$1 = state_8817;
var statearr_8823_8931 = state_8817__$1;
(statearr_8823_8931[(2)] = inst_8801);

(statearr_8823_8931[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8818 === (6))){
var inst_8803 = (state_8817[(8)]);
var inst_8798 = (state_8817[(7)]);
var inst_8803__$1 = cljs.core.async.chan.call(null,(1));
var inst_8804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_8805 = [inst_8798,inst_8803__$1];
var inst_8806 = (new cljs.core.PersistentVector(null,2,(5),inst_8804,inst_8805,null));
var state_8817__$1 = (function (){var statearr_8824 = state_8817;
(statearr_8824[(8)] = inst_8803__$1);

return statearr_8824;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8817__$1,(8),jobs,inst_8806);
} else {
if((state_val_8818 === (7))){
var inst_8813 = (state_8817[(2)]);
var state_8817__$1 = state_8817;
var statearr_8825_8932 = state_8817__$1;
(statearr_8825_8932[(2)] = inst_8813);

(statearr_8825_8932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8818 === (8))){
var inst_8803 = (state_8817[(8)]);
var inst_8808 = (state_8817[(2)]);
var state_8817__$1 = (function (){var statearr_8826 = state_8817;
(statearr_8826[(9)] = inst_8808);

return statearr_8826;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8817__$1,(9),results,inst_8803);
} else {
if((state_val_8818 === (9))){
var inst_8810 = (state_8817[(2)]);
var state_8817__$1 = (function (){var statearr_8827 = state_8817;
(statearr_8827[(10)] = inst_8810);

return statearr_8827;
})();
var statearr_8828_8933 = state_8817__$1;
(statearr_8828_8933[(2)] = null);

(statearr_8828_8933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___8927,jobs,results,process,async))
;
return ((function (switch__8474__auto__,c__8564__auto___8927,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0 = (function (){
var statearr_8829 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8829[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__);

(statearr_8829[(1)] = (1));

return statearr_8829;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1 = (function (state_8817){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_8817);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e8830){if((e8830 instanceof Object)){
var ex__8478__auto__ = e8830;
var statearr_8831_8934 = state_8817;
(statearr_8831_8934[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8817);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8830;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8935 = state_8817;
state_8817 = G__8935;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = function(state_8817){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1.call(this,state_8817);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___8927,jobs,results,process,async))
})();
var state__8566__auto__ = (function (){var statearr_8832 = f__8565__auto__.call(null);
(statearr_8832[(6)] = c__8564__auto___8927);

return statearr_8832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___8927,jobs,results,process,async))
);


var c__8564__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto__,jobs,results,process,async){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto__,jobs,results,process,async){
return (function (state_8870){
var state_val_8871 = (state_8870[(1)]);
if((state_val_8871 === (7))){
var inst_8866 = (state_8870[(2)]);
var state_8870__$1 = state_8870;
var statearr_8872_8936 = state_8870__$1;
(statearr_8872_8936[(2)] = inst_8866);

(statearr_8872_8936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (20))){
var state_8870__$1 = state_8870;
var statearr_8873_8937 = state_8870__$1;
(statearr_8873_8937[(2)] = null);

(statearr_8873_8937[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (1))){
var state_8870__$1 = state_8870;
var statearr_8874_8938 = state_8870__$1;
(statearr_8874_8938[(2)] = null);

(statearr_8874_8938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (4))){
var inst_8835 = (state_8870[(7)]);
var inst_8835__$1 = (state_8870[(2)]);
var inst_8836 = (inst_8835__$1 == null);
var state_8870__$1 = (function (){var statearr_8875 = state_8870;
(statearr_8875[(7)] = inst_8835__$1);

return statearr_8875;
})();
if(cljs.core.truth_(inst_8836)){
var statearr_8876_8939 = state_8870__$1;
(statearr_8876_8939[(1)] = (5));

} else {
var statearr_8877_8940 = state_8870__$1;
(statearr_8877_8940[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (15))){
var inst_8848 = (state_8870[(8)]);
var state_8870__$1 = state_8870;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8870__$1,(18),to,inst_8848);
} else {
if((state_val_8871 === (21))){
var inst_8861 = (state_8870[(2)]);
var state_8870__$1 = state_8870;
var statearr_8878_8941 = state_8870__$1;
(statearr_8878_8941[(2)] = inst_8861);

(statearr_8878_8941[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (13))){
var inst_8863 = (state_8870[(2)]);
var state_8870__$1 = (function (){var statearr_8879 = state_8870;
(statearr_8879[(9)] = inst_8863);

return statearr_8879;
})();
var statearr_8880_8942 = state_8870__$1;
(statearr_8880_8942[(2)] = null);

(statearr_8880_8942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (6))){
var inst_8835 = (state_8870[(7)]);
var state_8870__$1 = state_8870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8870__$1,(11),inst_8835);
} else {
if((state_val_8871 === (17))){
var inst_8856 = (state_8870[(2)]);
var state_8870__$1 = state_8870;
if(cljs.core.truth_(inst_8856)){
var statearr_8881_8943 = state_8870__$1;
(statearr_8881_8943[(1)] = (19));

} else {
var statearr_8882_8944 = state_8870__$1;
(statearr_8882_8944[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (3))){
var inst_8868 = (state_8870[(2)]);
var state_8870__$1 = state_8870;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8870__$1,inst_8868);
} else {
if((state_val_8871 === (12))){
var inst_8845 = (state_8870[(10)]);
var state_8870__$1 = state_8870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8870__$1,(14),inst_8845);
} else {
if((state_val_8871 === (2))){
var state_8870__$1 = state_8870;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8870__$1,(4),results);
} else {
if((state_val_8871 === (19))){
var state_8870__$1 = state_8870;
var statearr_8883_8945 = state_8870__$1;
(statearr_8883_8945[(2)] = null);

(statearr_8883_8945[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (11))){
var inst_8845 = (state_8870[(2)]);
var state_8870__$1 = (function (){var statearr_8884 = state_8870;
(statearr_8884[(10)] = inst_8845);

return statearr_8884;
})();
var statearr_8885_8946 = state_8870__$1;
(statearr_8885_8946[(2)] = null);

(statearr_8885_8946[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (9))){
var state_8870__$1 = state_8870;
var statearr_8886_8947 = state_8870__$1;
(statearr_8886_8947[(2)] = null);

(statearr_8886_8947[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (5))){
var state_8870__$1 = state_8870;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8887_8948 = state_8870__$1;
(statearr_8887_8948[(1)] = (8));

} else {
var statearr_8888_8949 = state_8870__$1;
(statearr_8888_8949[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (14))){
var inst_8848 = (state_8870[(8)]);
var inst_8850 = (state_8870[(11)]);
var inst_8848__$1 = (state_8870[(2)]);
var inst_8849 = (inst_8848__$1 == null);
var inst_8850__$1 = cljs.core.not.call(null,inst_8849);
var state_8870__$1 = (function (){var statearr_8889 = state_8870;
(statearr_8889[(8)] = inst_8848__$1);

(statearr_8889[(11)] = inst_8850__$1);

return statearr_8889;
})();
if(inst_8850__$1){
var statearr_8890_8950 = state_8870__$1;
(statearr_8890_8950[(1)] = (15));

} else {
var statearr_8891_8951 = state_8870__$1;
(statearr_8891_8951[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (16))){
var inst_8850 = (state_8870[(11)]);
var state_8870__$1 = state_8870;
var statearr_8892_8952 = state_8870__$1;
(statearr_8892_8952[(2)] = inst_8850);

(statearr_8892_8952[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (10))){
var inst_8842 = (state_8870[(2)]);
var state_8870__$1 = state_8870;
var statearr_8893_8953 = state_8870__$1;
(statearr_8893_8953[(2)] = inst_8842);

(statearr_8893_8953[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (18))){
var inst_8853 = (state_8870[(2)]);
var state_8870__$1 = state_8870;
var statearr_8894_8954 = state_8870__$1;
(statearr_8894_8954[(2)] = inst_8853);

(statearr_8894_8954[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8871 === (8))){
var inst_8839 = cljs.core.async.close_BANG_.call(null,to);
var state_8870__$1 = state_8870;
var statearr_8895_8955 = state_8870__$1;
(statearr_8895_8955[(2)] = inst_8839);

(statearr_8895_8955[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto__,jobs,results,process,async))
;
return ((function (switch__8474__auto__,c__8564__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0 = (function (){
var statearr_8896 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_8896[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__);

(statearr_8896[(1)] = (1));

return statearr_8896;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1 = (function (state_8870){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_8870);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e8897){if((e8897 instanceof Object)){
var ex__8478__auto__ = e8897;
var statearr_8898_8956 = state_8870;
(statearr_8898_8956[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8870);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8897;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8957 = state_8870;
state_8870 = G__8957;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__ = function(state_8870){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1.call(this,state_8870);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8475__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto__,jobs,results,process,async))
})();
var state__8566__auto__ = (function (){var statearr_8899 = f__8565__auto__.call(null);
(statearr_8899[(6)] = c__8564__auto__);

return statearr_8899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto__,jobs,results,process,async))
);

return c__8564__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__8959 = arguments.length;
switch (G__8959) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__8962 = arguments.length;
switch (G__8962) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__8965 = arguments.length;
switch (G__8965) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__8564__auto___9014 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___9014,tc,fc){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___9014,tc,fc){
return (function (state_8991){
var state_val_8992 = (state_8991[(1)]);
if((state_val_8992 === (7))){
var inst_8987 = (state_8991[(2)]);
var state_8991__$1 = state_8991;
var statearr_8993_9015 = state_8991__$1;
(statearr_8993_9015[(2)] = inst_8987);

(statearr_8993_9015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (1))){
var state_8991__$1 = state_8991;
var statearr_8994_9016 = state_8991__$1;
(statearr_8994_9016[(2)] = null);

(statearr_8994_9016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (4))){
var inst_8968 = (state_8991[(7)]);
var inst_8968__$1 = (state_8991[(2)]);
var inst_8969 = (inst_8968__$1 == null);
var state_8991__$1 = (function (){var statearr_8995 = state_8991;
(statearr_8995[(7)] = inst_8968__$1);

return statearr_8995;
})();
if(cljs.core.truth_(inst_8969)){
var statearr_8996_9017 = state_8991__$1;
(statearr_8996_9017[(1)] = (5));

} else {
var statearr_8997_9018 = state_8991__$1;
(statearr_8997_9018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (13))){
var state_8991__$1 = state_8991;
var statearr_8998_9019 = state_8991__$1;
(statearr_8998_9019[(2)] = null);

(statearr_8998_9019[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (6))){
var inst_8968 = (state_8991[(7)]);
var inst_8974 = p.call(null,inst_8968);
var state_8991__$1 = state_8991;
if(cljs.core.truth_(inst_8974)){
var statearr_8999_9020 = state_8991__$1;
(statearr_8999_9020[(1)] = (9));

} else {
var statearr_9000_9021 = state_8991__$1;
(statearr_9000_9021[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (3))){
var inst_8989 = (state_8991[(2)]);
var state_8991__$1 = state_8991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8991__$1,inst_8989);
} else {
if((state_val_8992 === (12))){
var state_8991__$1 = state_8991;
var statearr_9001_9022 = state_8991__$1;
(statearr_9001_9022[(2)] = null);

(statearr_9001_9022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (2))){
var state_8991__$1 = state_8991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8991__$1,(4),ch);
} else {
if((state_val_8992 === (11))){
var inst_8968 = (state_8991[(7)]);
var inst_8978 = (state_8991[(2)]);
var state_8991__$1 = state_8991;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_8991__$1,(8),inst_8978,inst_8968);
} else {
if((state_val_8992 === (9))){
var state_8991__$1 = state_8991;
var statearr_9002_9023 = state_8991__$1;
(statearr_9002_9023[(2)] = tc);

(statearr_9002_9023[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (5))){
var inst_8971 = cljs.core.async.close_BANG_.call(null,tc);
var inst_8972 = cljs.core.async.close_BANG_.call(null,fc);
var state_8991__$1 = (function (){var statearr_9003 = state_8991;
(statearr_9003[(8)] = inst_8971);

return statearr_9003;
})();
var statearr_9004_9024 = state_8991__$1;
(statearr_9004_9024[(2)] = inst_8972);

(statearr_9004_9024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (14))){
var inst_8985 = (state_8991[(2)]);
var state_8991__$1 = state_8991;
var statearr_9005_9025 = state_8991__$1;
(statearr_9005_9025[(2)] = inst_8985);

(statearr_9005_9025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (10))){
var state_8991__$1 = state_8991;
var statearr_9006_9026 = state_8991__$1;
(statearr_9006_9026[(2)] = fc);

(statearr_9006_9026[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8992 === (8))){
var inst_8980 = (state_8991[(2)]);
var state_8991__$1 = state_8991;
if(cljs.core.truth_(inst_8980)){
var statearr_9007_9027 = state_8991__$1;
(statearr_9007_9027[(1)] = (12));

} else {
var statearr_9008_9028 = state_8991__$1;
(statearr_9008_9028[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___9014,tc,fc))
;
return ((function (switch__8474__auto__,c__8564__auto___9014,tc,fc){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_9009 = [null,null,null,null,null,null,null,null,null];
(statearr_9009[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_9009[(1)] = (1));

return statearr_9009;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_8991){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_8991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9010){if((e9010 instanceof Object)){
var ex__8478__auto__ = e9010;
var statearr_9011_9029 = state_8991;
(statearr_9011_9029[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8991);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9010;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9030 = state_8991;
state_8991 = G__9030;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_8991){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_8991);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___9014,tc,fc))
})();
var state__8566__auto__ = (function (){var statearr_9012 = f__8565__auto__.call(null);
(statearr_9012[(6)] = c__8564__auto___9014);

return statearr_9012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___9014,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8564__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto__){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto__){
return (function (state_9051){
var state_val_9052 = (state_9051[(1)]);
if((state_val_9052 === (7))){
var inst_9047 = (state_9051[(2)]);
var state_9051__$1 = state_9051;
var statearr_9053_9071 = state_9051__$1;
(statearr_9053_9071[(2)] = inst_9047);

(statearr_9053_9071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9052 === (1))){
var inst_9031 = init;
var state_9051__$1 = (function (){var statearr_9054 = state_9051;
(statearr_9054[(7)] = inst_9031);

return statearr_9054;
})();
var statearr_9055_9072 = state_9051__$1;
(statearr_9055_9072[(2)] = null);

(statearr_9055_9072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9052 === (4))){
var inst_9034 = (state_9051[(8)]);
var inst_9034__$1 = (state_9051[(2)]);
var inst_9035 = (inst_9034__$1 == null);
var state_9051__$1 = (function (){var statearr_9056 = state_9051;
(statearr_9056[(8)] = inst_9034__$1);

return statearr_9056;
})();
if(cljs.core.truth_(inst_9035)){
var statearr_9057_9073 = state_9051__$1;
(statearr_9057_9073[(1)] = (5));

} else {
var statearr_9058_9074 = state_9051__$1;
(statearr_9058_9074[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9052 === (6))){
var inst_9038 = (state_9051[(9)]);
var inst_9034 = (state_9051[(8)]);
var inst_9031 = (state_9051[(7)]);
var inst_9038__$1 = f.call(null,inst_9031,inst_9034);
var inst_9039 = cljs.core.reduced_QMARK_.call(null,inst_9038__$1);
var state_9051__$1 = (function (){var statearr_9059 = state_9051;
(statearr_9059[(9)] = inst_9038__$1);

return statearr_9059;
})();
if(inst_9039){
var statearr_9060_9075 = state_9051__$1;
(statearr_9060_9075[(1)] = (8));

} else {
var statearr_9061_9076 = state_9051__$1;
(statearr_9061_9076[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9052 === (3))){
var inst_9049 = (state_9051[(2)]);
var state_9051__$1 = state_9051;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9051__$1,inst_9049);
} else {
if((state_val_9052 === (2))){
var state_9051__$1 = state_9051;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9051__$1,(4),ch);
} else {
if((state_val_9052 === (9))){
var inst_9038 = (state_9051[(9)]);
var inst_9031 = inst_9038;
var state_9051__$1 = (function (){var statearr_9062 = state_9051;
(statearr_9062[(7)] = inst_9031);

return statearr_9062;
})();
var statearr_9063_9077 = state_9051__$1;
(statearr_9063_9077[(2)] = null);

(statearr_9063_9077[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9052 === (5))){
var inst_9031 = (state_9051[(7)]);
var state_9051__$1 = state_9051;
var statearr_9064_9078 = state_9051__$1;
(statearr_9064_9078[(2)] = inst_9031);

(statearr_9064_9078[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9052 === (10))){
var inst_9045 = (state_9051[(2)]);
var state_9051__$1 = state_9051;
var statearr_9065_9079 = state_9051__$1;
(statearr_9065_9079[(2)] = inst_9045);

(statearr_9065_9079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9052 === (8))){
var inst_9038 = (state_9051[(9)]);
var inst_9041 = cljs.core.deref.call(null,inst_9038);
var state_9051__$1 = state_9051;
var statearr_9066_9080 = state_9051__$1;
(statearr_9066_9080[(2)] = inst_9041);

(statearr_9066_9080[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto__))
;
return ((function (switch__8474__auto__,c__8564__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__8475__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8475__auto____0 = (function (){
var statearr_9067 = [null,null,null,null,null,null,null,null,null,null];
(statearr_9067[(0)] = cljs$core$async$reduce_$_state_machine__8475__auto__);

(statearr_9067[(1)] = (1));

return statearr_9067;
});
var cljs$core$async$reduce_$_state_machine__8475__auto____1 = (function (state_9051){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_9051);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9068){if((e9068 instanceof Object)){
var ex__8478__auto__ = e9068;
var statearr_9069_9081 = state_9051;
(statearr_9069_9081[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9051);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9068;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9082 = state_9051;
state_9051 = G__9082;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8475__auto__ = function(state_9051){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8475__auto____1.call(this,state_9051);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8475__auto____0;
cljs$core$async$reduce_$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8475__auto____1;
return cljs$core$async$reduce_$_state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto__))
})();
var state__8566__auto__ = (function (){var statearr_9070 = f__8565__auto__.call(null);
(statearr_9070[(6)] = c__8564__auto__);

return statearr_9070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto__))
);

return c__8564__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__8564__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto__,f__$1){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto__,f__$1){
return (function (state_9088){
var state_val_9089 = (state_9088[(1)]);
if((state_val_9089 === (1))){
var inst_9083 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_9088__$1 = state_9088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9088__$1,(2),inst_9083);
} else {
if((state_val_9089 === (2))){
var inst_9085 = (state_9088[(2)]);
var inst_9086 = f__$1.call(null,inst_9085);
var state_9088__$1 = state_9088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9088__$1,inst_9086);
} else {
return null;
}
}
});})(c__8564__auto__,f__$1))
;
return ((function (switch__8474__auto__,c__8564__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__8475__auto__ = null;
var cljs$core$async$transduce_$_state_machine__8475__auto____0 = (function (){
var statearr_9090 = [null,null,null,null,null,null,null];
(statearr_9090[(0)] = cljs$core$async$transduce_$_state_machine__8475__auto__);

(statearr_9090[(1)] = (1));

return statearr_9090;
});
var cljs$core$async$transduce_$_state_machine__8475__auto____1 = (function (state_9088){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_9088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9091){if((e9091 instanceof Object)){
var ex__8478__auto__ = e9091;
var statearr_9092_9094 = state_9088;
(statearr_9092_9094[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9088);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9091;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9095 = state_9088;
state_9088 = G__9095;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__8475__auto__ = function(state_9088){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__8475__auto____1.call(this,state_9088);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__8475__auto____0;
cljs$core$async$transduce_$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__8475__auto____1;
return cljs$core$async$transduce_$_state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto__,f__$1))
})();
var state__8566__auto__ = (function (){var statearr_9093 = f__8565__auto__.call(null);
(statearr_9093[(6)] = c__8564__auto__);

return statearr_9093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto__,f__$1))
);

return c__8564__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__9097 = arguments.length;
switch (G__9097) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8564__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto__){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto__){
return (function (state_9122){
var state_val_9123 = (state_9122[(1)]);
if((state_val_9123 === (7))){
var inst_9104 = (state_9122[(2)]);
var state_9122__$1 = state_9122;
var statearr_9124_9145 = state_9122__$1;
(statearr_9124_9145[(2)] = inst_9104);

(statearr_9124_9145[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (1))){
var inst_9098 = cljs.core.seq.call(null,coll);
var inst_9099 = inst_9098;
var state_9122__$1 = (function (){var statearr_9125 = state_9122;
(statearr_9125[(7)] = inst_9099);

return statearr_9125;
})();
var statearr_9126_9146 = state_9122__$1;
(statearr_9126_9146[(2)] = null);

(statearr_9126_9146[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (4))){
var inst_9099 = (state_9122[(7)]);
var inst_9102 = cljs.core.first.call(null,inst_9099);
var state_9122__$1 = state_9122;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9122__$1,(7),ch,inst_9102);
} else {
if((state_val_9123 === (13))){
var inst_9116 = (state_9122[(2)]);
var state_9122__$1 = state_9122;
var statearr_9127_9147 = state_9122__$1;
(statearr_9127_9147[(2)] = inst_9116);

(statearr_9127_9147[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (6))){
var inst_9107 = (state_9122[(2)]);
var state_9122__$1 = state_9122;
if(cljs.core.truth_(inst_9107)){
var statearr_9128_9148 = state_9122__$1;
(statearr_9128_9148[(1)] = (8));

} else {
var statearr_9129_9149 = state_9122__$1;
(statearr_9129_9149[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (3))){
var inst_9120 = (state_9122[(2)]);
var state_9122__$1 = state_9122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9122__$1,inst_9120);
} else {
if((state_val_9123 === (12))){
var state_9122__$1 = state_9122;
var statearr_9130_9150 = state_9122__$1;
(statearr_9130_9150[(2)] = null);

(statearr_9130_9150[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (2))){
var inst_9099 = (state_9122[(7)]);
var state_9122__$1 = state_9122;
if(cljs.core.truth_(inst_9099)){
var statearr_9131_9151 = state_9122__$1;
(statearr_9131_9151[(1)] = (4));

} else {
var statearr_9132_9152 = state_9122__$1;
(statearr_9132_9152[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (11))){
var inst_9113 = cljs.core.async.close_BANG_.call(null,ch);
var state_9122__$1 = state_9122;
var statearr_9133_9153 = state_9122__$1;
(statearr_9133_9153[(2)] = inst_9113);

(statearr_9133_9153[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (9))){
var state_9122__$1 = state_9122;
if(cljs.core.truth_(close_QMARK_)){
var statearr_9134_9154 = state_9122__$1;
(statearr_9134_9154[(1)] = (11));

} else {
var statearr_9135_9155 = state_9122__$1;
(statearr_9135_9155[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (5))){
var inst_9099 = (state_9122[(7)]);
var state_9122__$1 = state_9122;
var statearr_9136_9156 = state_9122__$1;
(statearr_9136_9156[(2)] = inst_9099);

(statearr_9136_9156[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (10))){
var inst_9118 = (state_9122[(2)]);
var state_9122__$1 = state_9122;
var statearr_9137_9157 = state_9122__$1;
(statearr_9137_9157[(2)] = inst_9118);

(statearr_9137_9157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9123 === (8))){
var inst_9099 = (state_9122[(7)]);
var inst_9109 = cljs.core.next.call(null,inst_9099);
var inst_9099__$1 = inst_9109;
var state_9122__$1 = (function (){var statearr_9138 = state_9122;
(statearr_9138[(7)] = inst_9099__$1);

return statearr_9138;
})();
var statearr_9139_9158 = state_9122__$1;
(statearr_9139_9158[(2)] = null);

(statearr_9139_9158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto__))
;
return ((function (switch__8474__auto__,c__8564__auto__){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_9140 = [null,null,null,null,null,null,null,null];
(statearr_9140[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_9140[(1)] = (1));

return statearr_9140;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_9122){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_9122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9141){if((e9141 instanceof Object)){
var ex__8478__auto__ = e9141;
var statearr_9142_9159 = state_9122;
(statearr_9142_9159[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9122);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9141;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9160 = state_9122;
state_9122 = G__9160;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_9122){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_9122);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto__))
})();
var state__8566__auto__ = (function (){var statearr_9143 = f__8565__auto__.call(null);
(statearr_9143[(6)] = c__8564__auto__);

return statearr_9143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto__))
);

return c__8564__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if(((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4211__auto__ = (((_ == null))?null:_);
var m__4212__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,_);
} else {
var m__4212__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4212__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m);
} else {
var m__4212__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async9161 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9161 = (function (ch,cs,meta9162){
this.ch = ch;
this.cs = cs;
this.meta9162 = meta9162;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9161.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_9163,meta9162__$1){
var self__ = this;
var _9163__$1 = this;
return (new cljs.core.async.t_cljs$core$async9161(self__.ch,self__.cs,meta9162__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async9161.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_9163){
var self__ = this;
var _9163__$1 = this;
return self__.meta9162;
});})(cs))
;

cljs.core.async.t_cljs$core$async9161.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9161.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async9161.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9161.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9161.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9161.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async9161.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta9162","meta9162",-434020479,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async9161.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9161.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9161";

cljs.core.async.t_cljs$core$async9161.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async9161");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9161.
 */
cljs.core.async.__GT_t_cljs$core$async9161 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async9161(ch__$1,cs__$1,meta9162){
return (new cljs.core.async.t_cljs$core$async9161(ch__$1,cs__$1,meta9162));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async9161(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__8564__auto___9383 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___9383,cs,m,dchan,dctr,done){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___9383,cs,m,dchan,dctr,done){
return (function (state_9298){
var state_val_9299 = (state_9298[(1)]);
if((state_val_9299 === (7))){
var inst_9294 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9300_9384 = state_9298__$1;
(statearr_9300_9384[(2)] = inst_9294);

(statearr_9300_9384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (20))){
var inst_9197 = (state_9298[(7)]);
var inst_9209 = cljs.core.first.call(null,inst_9197);
var inst_9210 = cljs.core.nth.call(null,inst_9209,(0),null);
var inst_9211 = cljs.core.nth.call(null,inst_9209,(1),null);
var state_9298__$1 = (function (){var statearr_9301 = state_9298;
(statearr_9301[(8)] = inst_9210);

return statearr_9301;
})();
if(cljs.core.truth_(inst_9211)){
var statearr_9302_9385 = state_9298__$1;
(statearr_9302_9385[(1)] = (22));

} else {
var statearr_9303_9386 = state_9298__$1;
(statearr_9303_9386[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (27))){
var inst_9166 = (state_9298[(9)]);
var inst_9241 = (state_9298[(10)]);
var inst_9246 = (state_9298[(11)]);
var inst_9239 = (state_9298[(12)]);
var inst_9246__$1 = cljs.core._nth.call(null,inst_9239,inst_9241);
var inst_9247 = cljs.core.async.put_BANG_.call(null,inst_9246__$1,inst_9166,done);
var state_9298__$1 = (function (){var statearr_9304 = state_9298;
(statearr_9304[(11)] = inst_9246__$1);

return statearr_9304;
})();
if(cljs.core.truth_(inst_9247)){
var statearr_9305_9387 = state_9298__$1;
(statearr_9305_9387[(1)] = (30));

} else {
var statearr_9306_9388 = state_9298__$1;
(statearr_9306_9388[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (1))){
var state_9298__$1 = state_9298;
var statearr_9307_9389 = state_9298__$1;
(statearr_9307_9389[(2)] = null);

(statearr_9307_9389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (24))){
var inst_9197 = (state_9298[(7)]);
var inst_9216 = (state_9298[(2)]);
var inst_9217 = cljs.core.next.call(null,inst_9197);
var inst_9175 = inst_9217;
var inst_9176 = null;
var inst_9177 = (0);
var inst_9178 = (0);
var state_9298__$1 = (function (){var statearr_9308 = state_9298;
(statearr_9308[(13)] = inst_9176);

(statearr_9308[(14)] = inst_9175);

(statearr_9308[(15)] = inst_9177);

(statearr_9308[(16)] = inst_9216);

(statearr_9308[(17)] = inst_9178);

return statearr_9308;
})();
var statearr_9309_9390 = state_9298__$1;
(statearr_9309_9390[(2)] = null);

(statearr_9309_9390[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (39))){
var state_9298__$1 = state_9298;
var statearr_9313_9391 = state_9298__$1;
(statearr_9313_9391[(2)] = null);

(statearr_9313_9391[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (4))){
var inst_9166 = (state_9298[(9)]);
var inst_9166__$1 = (state_9298[(2)]);
var inst_9167 = (inst_9166__$1 == null);
var state_9298__$1 = (function (){var statearr_9314 = state_9298;
(statearr_9314[(9)] = inst_9166__$1);

return statearr_9314;
})();
if(cljs.core.truth_(inst_9167)){
var statearr_9315_9392 = state_9298__$1;
(statearr_9315_9392[(1)] = (5));

} else {
var statearr_9316_9393 = state_9298__$1;
(statearr_9316_9393[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (15))){
var inst_9176 = (state_9298[(13)]);
var inst_9175 = (state_9298[(14)]);
var inst_9177 = (state_9298[(15)]);
var inst_9178 = (state_9298[(17)]);
var inst_9193 = (state_9298[(2)]);
var inst_9194 = (inst_9178 + (1));
var tmp9310 = inst_9176;
var tmp9311 = inst_9175;
var tmp9312 = inst_9177;
var inst_9175__$1 = tmp9311;
var inst_9176__$1 = tmp9310;
var inst_9177__$1 = tmp9312;
var inst_9178__$1 = inst_9194;
var state_9298__$1 = (function (){var statearr_9317 = state_9298;
(statearr_9317[(13)] = inst_9176__$1);

(statearr_9317[(14)] = inst_9175__$1);

(statearr_9317[(15)] = inst_9177__$1);

(statearr_9317[(18)] = inst_9193);

(statearr_9317[(17)] = inst_9178__$1);

return statearr_9317;
})();
var statearr_9318_9394 = state_9298__$1;
(statearr_9318_9394[(2)] = null);

(statearr_9318_9394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (21))){
var inst_9220 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9322_9395 = state_9298__$1;
(statearr_9322_9395[(2)] = inst_9220);

(statearr_9322_9395[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (31))){
var inst_9246 = (state_9298[(11)]);
var inst_9250 = done.call(null,null);
var inst_9251 = cljs.core.async.untap_STAR_.call(null,m,inst_9246);
var state_9298__$1 = (function (){var statearr_9323 = state_9298;
(statearr_9323[(19)] = inst_9250);

return statearr_9323;
})();
var statearr_9324_9396 = state_9298__$1;
(statearr_9324_9396[(2)] = inst_9251);

(statearr_9324_9396[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (32))){
var inst_9241 = (state_9298[(10)]);
var inst_9239 = (state_9298[(12)]);
var inst_9238 = (state_9298[(20)]);
var inst_9240 = (state_9298[(21)]);
var inst_9253 = (state_9298[(2)]);
var inst_9254 = (inst_9241 + (1));
var tmp9319 = inst_9239;
var tmp9320 = inst_9238;
var tmp9321 = inst_9240;
var inst_9238__$1 = tmp9320;
var inst_9239__$1 = tmp9319;
var inst_9240__$1 = tmp9321;
var inst_9241__$1 = inst_9254;
var state_9298__$1 = (function (){var statearr_9325 = state_9298;
(statearr_9325[(10)] = inst_9241__$1);

(statearr_9325[(12)] = inst_9239__$1);

(statearr_9325[(22)] = inst_9253);

(statearr_9325[(20)] = inst_9238__$1);

(statearr_9325[(21)] = inst_9240__$1);

return statearr_9325;
})();
var statearr_9326_9397 = state_9298__$1;
(statearr_9326_9397[(2)] = null);

(statearr_9326_9397[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (40))){
var inst_9266 = (state_9298[(23)]);
var inst_9270 = done.call(null,null);
var inst_9271 = cljs.core.async.untap_STAR_.call(null,m,inst_9266);
var state_9298__$1 = (function (){var statearr_9327 = state_9298;
(statearr_9327[(24)] = inst_9270);

return statearr_9327;
})();
var statearr_9328_9398 = state_9298__$1;
(statearr_9328_9398[(2)] = inst_9271);

(statearr_9328_9398[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (33))){
var inst_9257 = (state_9298[(25)]);
var inst_9259 = cljs.core.chunked_seq_QMARK_.call(null,inst_9257);
var state_9298__$1 = state_9298;
if(inst_9259){
var statearr_9329_9399 = state_9298__$1;
(statearr_9329_9399[(1)] = (36));

} else {
var statearr_9330_9400 = state_9298__$1;
(statearr_9330_9400[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (13))){
var inst_9187 = (state_9298[(26)]);
var inst_9190 = cljs.core.async.close_BANG_.call(null,inst_9187);
var state_9298__$1 = state_9298;
var statearr_9331_9401 = state_9298__$1;
(statearr_9331_9401[(2)] = inst_9190);

(statearr_9331_9401[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (22))){
var inst_9210 = (state_9298[(8)]);
var inst_9213 = cljs.core.async.close_BANG_.call(null,inst_9210);
var state_9298__$1 = state_9298;
var statearr_9332_9402 = state_9298__$1;
(statearr_9332_9402[(2)] = inst_9213);

(statearr_9332_9402[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (36))){
var inst_9257 = (state_9298[(25)]);
var inst_9261 = cljs.core.chunk_first.call(null,inst_9257);
var inst_9262 = cljs.core.chunk_rest.call(null,inst_9257);
var inst_9263 = cljs.core.count.call(null,inst_9261);
var inst_9238 = inst_9262;
var inst_9239 = inst_9261;
var inst_9240 = inst_9263;
var inst_9241 = (0);
var state_9298__$1 = (function (){var statearr_9333 = state_9298;
(statearr_9333[(10)] = inst_9241);

(statearr_9333[(12)] = inst_9239);

(statearr_9333[(20)] = inst_9238);

(statearr_9333[(21)] = inst_9240);

return statearr_9333;
})();
var statearr_9334_9403 = state_9298__$1;
(statearr_9334_9403[(2)] = null);

(statearr_9334_9403[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (41))){
var inst_9257 = (state_9298[(25)]);
var inst_9273 = (state_9298[(2)]);
var inst_9274 = cljs.core.next.call(null,inst_9257);
var inst_9238 = inst_9274;
var inst_9239 = null;
var inst_9240 = (0);
var inst_9241 = (0);
var state_9298__$1 = (function (){var statearr_9335 = state_9298;
(statearr_9335[(10)] = inst_9241);

(statearr_9335[(12)] = inst_9239);

(statearr_9335[(20)] = inst_9238);

(statearr_9335[(27)] = inst_9273);

(statearr_9335[(21)] = inst_9240);

return statearr_9335;
})();
var statearr_9336_9404 = state_9298__$1;
(statearr_9336_9404[(2)] = null);

(statearr_9336_9404[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (43))){
var state_9298__$1 = state_9298;
var statearr_9337_9405 = state_9298__$1;
(statearr_9337_9405[(2)] = null);

(statearr_9337_9405[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (29))){
var inst_9282 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9338_9406 = state_9298__$1;
(statearr_9338_9406[(2)] = inst_9282);

(statearr_9338_9406[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (44))){
var inst_9291 = (state_9298[(2)]);
var state_9298__$1 = (function (){var statearr_9339 = state_9298;
(statearr_9339[(28)] = inst_9291);

return statearr_9339;
})();
var statearr_9340_9407 = state_9298__$1;
(statearr_9340_9407[(2)] = null);

(statearr_9340_9407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (6))){
var inst_9230 = (state_9298[(29)]);
var inst_9229 = cljs.core.deref.call(null,cs);
var inst_9230__$1 = cljs.core.keys.call(null,inst_9229);
var inst_9231 = cljs.core.count.call(null,inst_9230__$1);
var inst_9232 = cljs.core.reset_BANG_.call(null,dctr,inst_9231);
var inst_9237 = cljs.core.seq.call(null,inst_9230__$1);
var inst_9238 = inst_9237;
var inst_9239 = null;
var inst_9240 = (0);
var inst_9241 = (0);
var state_9298__$1 = (function (){var statearr_9341 = state_9298;
(statearr_9341[(30)] = inst_9232);

(statearr_9341[(10)] = inst_9241);

(statearr_9341[(12)] = inst_9239);

(statearr_9341[(20)] = inst_9238);

(statearr_9341[(29)] = inst_9230__$1);

(statearr_9341[(21)] = inst_9240);

return statearr_9341;
})();
var statearr_9342_9408 = state_9298__$1;
(statearr_9342_9408[(2)] = null);

(statearr_9342_9408[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (28))){
var inst_9257 = (state_9298[(25)]);
var inst_9238 = (state_9298[(20)]);
var inst_9257__$1 = cljs.core.seq.call(null,inst_9238);
var state_9298__$1 = (function (){var statearr_9343 = state_9298;
(statearr_9343[(25)] = inst_9257__$1);

return statearr_9343;
})();
if(inst_9257__$1){
var statearr_9344_9409 = state_9298__$1;
(statearr_9344_9409[(1)] = (33));

} else {
var statearr_9345_9410 = state_9298__$1;
(statearr_9345_9410[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (25))){
var inst_9241 = (state_9298[(10)]);
var inst_9240 = (state_9298[(21)]);
var inst_9243 = (inst_9241 < inst_9240);
var inst_9244 = inst_9243;
var state_9298__$1 = state_9298;
if(cljs.core.truth_(inst_9244)){
var statearr_9346_9411 = state_9298__$1;
(statearr_9346_9411[(1)] = (27));

} else {
var statearr_9347_9412 = state_9298__$1;
(statearr_9347_9412[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (34))){
var state_9298__$1 = state_9298;
var statearr_9348_9413 = state_9298__$1;
(statearr_9348_9413[(2)] = null);

(statearr_9348_9413[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (17))){
var state_9298__$1 = state_9298;
var statearr_9349_9414 = state_9298__$1;
(statearr_9349_9414[(2)] = null);

(statearr_9349_9414[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (3))){
var inst_9296 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9298__$1,inst_9296);
} else {
if((state_val_9299 === (12))){
var inst_9225 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9350_9415 = state_9298__$1;
(statearr_9350_9415[(2)] = inst_9225);

(statearr_9350_9415[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (2))){
var state_9298__$1 = state_9298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9298__$1,(4),ch);
} else {
if((state_val_9299 === (23))){
var state_9298__$1 = state_9298;
var statearr_9351_9416 = state_9298__$1;
(statearr_9351_9416[(2)] = null);

(statearr_9351_9416[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (35))){
var inst_9280 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9352_9417 = state_9298__$1;
(statearr_9352_9417[(2)] = inst_9280);

(statearr_9352_9417[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (19))){
var inst_9197 = (state_9298[(7)]);
var inst_9201 = cljs.core.chunk_first.call(null,inst_9197);
var inst_9202 = cljs.core.chunk_rest.call(null,inst_9197);
var inst_9203 = cljs.core.count.call(null,inst_9201);
var inst_9175 = inst_9202;
var inst_9176 = inst_9201;
var inst_9177 = inst_9203;
var inst_9178 = (0);
var state_9298__$1 = (function (){var statearr_9353 = state_9298;
(statearr_9353[(13)] = inst_9176);

(statearr_9353[(14)] = inst_9175);

(statearr_9353[(15)] = inst_9177);

(statearr_9353[(17)] = inst_9178);

return statearr_9353;
})();
var statearr_9354_9418 = state_9298__$1;
(statearr_9354_9418[(2)] = null);

(statearr_9354_9418[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (11))){
var inst_9175 = (state_9298[(14)]);
var inst_9197 = (state_9298[(7)]);
var inst_9197__$1 = cljs.core.seq.call(null,inst_9175);
var state_9298__$1 = (function (){var statearr_9355 = state_9298;
(statearr_9355[(7)] = inst_9197__$1);

return statearr_9355;
})();
if(inst_9197__$1){
var statearr_9356_9419 = state_9298__$1;
(statearr_9356_9419[(1)] = (16));

} else {
var statearr_9357_9420 = state_9298__$1;
(statearr_9357_9420[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (9))){
var inst_9227 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9358_9421 = state_9298__$1;
(statearr_9358_9421[(2)] = inst_9227);

(statearr_9358_9421[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (5))){
var inst_9173 = cljs.core.deref.call(null,cs);
var inst_9174 = cljs.core.seq.call(null,inst_9173);
var inst_9175 = inst_9174;
var inst_9176 = null;
var inst_9177 = (0);
var inst_9178 = (0);
var state_9298__$1 = (function (){var statearr_9359 = state_9298;
(statearr_9359[(13)] = inst_9176);

(statearr_9359[(14)] = inst_9175);

(statearr_9359[(15)] = inst_9177);

(statearr_9359[(17)] = inst_9178);

return statearr_9359;
})();
var statearr_9360_9422 = state_9298__$1;
(statearr_9360_9422[(2)] = null);

(statearr_9360_9422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (14))){
var state_9298__$1 = state_9298;
var statearr_9361_9423 = state_9298__$1;
(statearr_9361_9423[(2)] = null);

(statearr_9361_9423[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (45))){
var inst_9288 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9362_9424 = state_9298__$1;
(statearr_9362_9424[(2)] = inst_9288);

(statearr_9362_9424[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (26))){
var inst_9230 = (state_9298[(29)]);
var inst_9284 = (state_9298[(2)]);
var inst_9285 = cljs.core.seq.call(null,inst_9230);
var state_9298__$1 = (function (){var statearr_9363 = state_9298;
(statearr_9363[(31)] = inst_9284);

return statearr_9363;
})();
if(inst_9285){
var statearr_9364_9425 = state_9298__$1;
(statearr_9364_9425[(1)] = (42));

} else {
var statearr_9365_9426 = state_9298__$1;
(statearr_9365_9426[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (16))){
var inst_9197 = (state_9298[(7)]);
var inst_9199 = cljs.core.chunked_seq_QMARK_.call(null,inst_9197);
var state_9298__$1 = state_9298;
if(inst_9199){
var statearr_9366_9427 = state_9298__$1;
(statearr_9366_9427[(1)] = (19));

} else {
var statearr_9367_9428 = state_9298__$1;
(statearr_9367_9428[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (38))){
var inst_9277 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9368_9429 = state_9298__$1;
(statearr_9368_9429[(2)] = inst_9277);

(statearr_9368_9429[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (30))){
var state_9298__$1 = state_9298;
var statearr_9369_9430 = state_9298__$1;
(statearr_9369_9430[(2)] = null);

(statearr_9369_9430[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (10))){
var inst_9176 = (state_9298[(13)]);
var inst_9178 = (state_9298[(17)]);
var inst_9186 = cljs.core._nth.call(null,inst_9176,inst_9178);
var inst_9187 = cljs.core.nth.call(null,inst_9186,(0),null);
var inst_9188 = cljs.core.nth.call(null,inst_9186,(1),null);
var state_9298__$1 = (function (){var statearr_9370 = state_9298;
(statearr_9370[(26)] = inst_9187);

return statearr_9370;
})();
if(cljs.core.truth_(inst_9188)){
var statearr_9371_9431 = state_9298__$1;
(statearr_9371_9431[(1)] = (13));

} else {
var statearr_9372_9432 = state_9298__$1;
(statearr_9372_9432[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (18))){
var inst_9223 = (state_9298[(2)]);
var state_9298__$1 = state_9298;
var statearr_9373_9433 = state_9298__$1;
(statearr_9373_9433[(2)] = inst_9223);

(statearr_9373_9433[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (42))){
var state_9298__$1 = state_9298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9298__$1,(45),dchan);
} else {
if((state_val_9299 === (37))){
var inst_9166 = (state_9298[(9)]);
var inst_9257 = (state_9298[(25)]);
var inst_9266 = (state_9298[(23)]);
var inst_9266__$1 = cljs.core.first.call(null,inst_9257);
var inst_9267 = cljs.core.async.put_BANG_.call(null,inst_9266__$1,inst_9166,done);
var state_9298__$1 = (function (){var statearr_9374 = state_9298;
(statearr_9374[(23)] = inst_9266__$1);

return statearr_9374;
})();
if(cljs.core.truth_(inst_9267)){
var statearr_9375_9434 = state_9298__$1;
(statearr_9375_9434[(1)] = (39));

} else {
var statearr_9376_9435 = state_9298__$1;
(statearr_9376_9435[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9299 === (8))){
var inst_9177 = (state_9298[(15)]);
var inst_9178 = (state_9298[(17)]);
var inst_9180 = (inst_9178 < inst_9177);
var inst_9181 = inst_9180;
var state_9298__$1 = state_9298;
if(cljs.core.truth_(inst_9181)){
var statearr_9377_9436 = state_9298__$1;
(statearr_9377_9436[(1)] = (10));

} else {
var statearr_9378_9437 = state_9298__$1;
(statearr_9378_9437[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___9383,cs,m,dchan,dctr,done))
;
return ((function (switch__8474__auto__,c__8564__auto___9383,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__8475__auto__ = null;
var cljs$core$async$mult_$_state_machine__8475__auto____0 = (function (){
var statearr_9379 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9379[(0)] = cljs$core$async$mult_$_state_machine__8475__auto__);

(statearr_9379[(1)] = (1));

return statearr_9379;
});
var cljs$core$async$mult_$_state_machine__8475__auto____1 = (function (state_9298){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_9298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9380){if((e9380 instanceof Object)){
var ex__8478__auto__ = e9380;
var statearr_9381_9438 = state_9298;
(statearr_9381_9438[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9380;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9439 = state_9298;
state_9298 = G__9439;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8475__auto__ = function(state_9298){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8475__auto____1.call(this,state_9298);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8475__auto____0;
cljs$core$async$mult_$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8475__auto____1;
return cljs$core$async$mult_$_state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___9383,cs,m,dchan,dctr,done))
})();
var state__8566__auto__ = (function (){var statearr_9382 = f__8565__auto__.call(null);
(statearr_9382[(6)] = c__8564__auto___9383);

return statearr_9382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___9383,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__9441 = arguments.length;
switch (G__9441) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m);
} else {
var m__4212__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,state_map);
} else {
var m__4212__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if(((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4211__auto__ = (((m == null))?null:m);
var m__4212__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,m,mode);
} else {
var m__4212__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4502__auto__ = [];
var len__4499__auto___9453 = arguments.length;
var i__4500__auto___9454 = (0);
while(true){
if((i__4500__auto___9454 < len__4499__auto___9453)){
args__4502__auto__.push((arguments[i__4500__auto___9454]));

var G__9455 = (i__4500__auto___9454 + (1));
i__4500__auto___9454 = G__9455;
continue;
} else {
}
break;
}

var argseq__4503__auto__ = ((((3) < args__4502__auto__.length))?(new cljs.core.IndexedSeq(args__4502__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4503__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__9447){
var map__9448 = p__9447;
var map__9448__$1 = ((((!((map__9448 == null)))?(((((map__9448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__9448):map__9448);
var opts = map__9448__$1;
var statearr_9450_9456 = state;
(statearr_9450_9456[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__9448,map__9448__$1,opts){
return (function (val){
var statearr_9451_9457 = state;
(statearr_9451_9457[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__9448,map__9448__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_9452_9458 = state;
(statearr_9452_9458[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq9443){
var G__9444 = cljs.core.first.call(null,seq9443);
var seq9443__$1 = cljs.core.next.call(null,seq9443);
var G__9445 = cljs.core.first.call(null,seq9443__$1);
var seq9443__$2 = cljs.core.next.call(null,seq9443__$1);
var G__9446 = cljs.core.first.call(null,seq9443__$2);
var seq9443__$3 = cljs.core.next.call(null,seq9443__$2);
var self__4486__auto__ = this;
return self__4486__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9444,G__9445,G__9446,seq9443__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos)))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async9459 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9459 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta9460){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta9460 = meta9460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_9461,meta9460__$1){
var self__ = this;
var _9461__$1 = this;
return (new cljs.core.async.t_cljs$core$async9459(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta9460__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_9461){
var self__ = this;
var _9461__$1 = this;
return self__.meta9460;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta9460","meta9460",1867313105,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async9459.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9459.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9459";

cljs.core.async.t_cljs$core$async9459.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async9459");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9459.
 */
cljs.core.async.__GT_t_cljs$core$async9459 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async9459(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta9460){
return (new cljs.core.async.t_cljs$core$async9459(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta9460));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async9459(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8564__auto___9623 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___9623,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___9623,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_9563){
var state_val_9564 = (state_9563[(1)]);
if((state_val_9564 === (7))){
var inst_9478 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9565_9624 = state_9563__$1;
(statearr_9565_9624[(2)] = inst_9478);

(statearr_9565_9624[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (20))){
var inst_9490 = (state_9563[(7)]);
var state_9563__$1 = state_9563;
var statearr_9566_9625 = state_9563__$1;
(statearr_9566_9625[(2)] = inst_9490);

(statearr_9566_9625[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (27))){
var state_9563__$1 = state_9563;
var statearr_9567_9626 = state_9563__$1;
(statearr_9567_9626[(2)] = null);

(statearr_9567_9626[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (1))){
var inst_9465 = (state_9563[(8)]);
var inst_9465__$1 = calc_state.call(null);
var inst_9467 = (inst_9465__$1 == null);
var inst_9468 = cljs.core.not.call(null,inst_9467);
var state_9563__$1 = (function (){var statearr_9568 = state_9563;
(statearr_9568[(8)] = inst_9465__$1);

return statearr_9568;
})();
if(inst_9468){
var statearr_9569_9627 = state_9563__$1;
(statearr_9569_9627[(1)] = (2));

} else {
var statearr_9570_9628 = state_9563__$1;
(statearr_9570_9628[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (24))){
var inst_9523 = (state_9563[(9)]);
var inst_9514 = (state_9563[(10)]);
var inst_9537 = (state_9563[(11)]);
var inst_9537__$1 = inst_9514.call(null,inst_9523);
var state_9563__$1 = (function (){var statearr_9571 = state_9563;
(statearr_9571[(11)] = inst_9537__$1);

return statearr_9571;
})();
if(cljs.core.truth_(inst_9537__$1)){
var statearr_9572_9629 = state_9563__$1;
(statearr_9572_9629[(1)] = (29));

} else {
var statearr_9573_9630 = state_9563__$1;
(statearr_9573_9630[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (4))){
var inst_9481 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9481)){
var statearr_9574_9631 = state_9563__$1;
(statearr_9574_9631[(1)] = (8));

} else {
var statearr_9575_9632 = state_9563__$1;
(statearr_9575_9632[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (15))){
var inst_9508 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9508)){
var statearr_9576_9633 = state_9563__$1;
(statearr_9576_9633[(1)] = (19));

} else {
var statearr_9577_9634 = state_9563__$1;
(statearr_9577_9634[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (21))){
var inst_9513 = (state_9563[(12)]);
var inst_9513__$1 = (state_9563[(2)]);
var inst_9514 = cljs.core.get.call(null,inst_9513__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9515 = cljs.core.get.call(null,inst_9513__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9516 = cljs.core.get.call(null,inst_9513__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_9563__$1 = (function (){var statearr_9578 = state_9563;
(statearr_9578[(13)] = inst_9515);

(statearr_9578[(12)] = inst_9513__$1);

(statearr_9578[(10)] = inst_9514);

return statearr_9578;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_9563__$1,(22),inst_9516);
} else {
if((state_val_9564 === (31))){
var inst_9545 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9545)){
var statearr_9579_9635 = state_9563__$1;
(statearr_9579_9635[(1)] = (32));

} else {
var statearr_9580_9636 = state_9563__$1;
(statearr_9580_9636[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (32))){
var inst_9522 = (state_9563[(14)]);
var state_9563__$1 = state_9563;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9563__$1,(35),out,inst_9522);
} else {
if((state_val_9564 === (33))){
var inst_9513 = (state_9563[(12)]);
var inst_9490 = inst_9513;
var state_9563__$1 = (function (){var statearr_9581 = state_9563;
(statearr_9581[(7)] = inst_9490);

return statearr_9581;
})();
var statearr_9582_9637 = state_9563__$1;
(statearr_9582_9637[(2)] = null);

(statearr_9582_9637[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (13))){
var inst_9490 = (state_9563[(7)]);
var inst_9497 = inst_9490.cljs$lang$protocol_mask$partition0$;
var inst_9498 = (inst_9497 & (64));
var inst_9499 = inst_9490.cljs$core$ISeq$;
var inst_9500 = (cljs.core.PROTOCOL_SENTINEL === inst_9499);
var inst_9501 = ((inst_9498) || (inst_9500));
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9501)){
var statearr_9583_9638 = state_9563__$1;
(statearr_9583_9638[(1)] = (16));

} else {
var statearr_9584_9639 = state_9563__$1;
(statearr_9584_9639[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (22))){
var inst_9523 = (state_9563[(9)]);
var inst_9522 = (state_9563[(14)]);
var inst_9521 = (state_9563[(2)]);
var inst_9522__$1 = cljs.core.nth.call(null,inst_9521,(0),null);
var inst_9523__$1 = cljs.core.nth.call(null,inst_9521,(1),null);
var inst_9524 = (inst_9522__$1 == null);
var inst_9525 = cljs.core._EQ_.call(null,inst_9523__$1,change);
var inst_9526 = ((inst_9524) || (inst_9525));
var state_9563__$1 = (function (){var statearr_9585 = state_9563;
(statearr_9585[(9)] = inst_9523__$1);

(statearr_9585[(14)] = inst_9522__$1);

return statearr_9585;
})();
if(cljs.core.truth_(inst_9526)){
var statearr_9586_9640 = state_9563__$1;
(statearr_9586_9640[(1)] = (23));

} else {
var statearr_9587_9641 = state_9563__$1;
(statearr_9587_9641[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (36))){
var inst_9513 = (state_9563[(12)]);
var inst_9490 = inst_9513;
var state_9563__$1 = (function (){var statearr_9588 = state_9563;
(statearr_9588[(7)] = inst_9490);

return statearr_9588;
})();
var statearr_9589_9642 = state_9563__$1;
(statearr_9589_9642[(2)] = null);

(statearr_9589_9642[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (29))){
var inst_9537 = (state_9563[(11)]);
var state_9563__$1 = state_9563;
var statearr_9590_9643 = state_9563__$1;
(statearr_9590_9643[(2)] = inst_9537);

(statearr_9590_9643[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (6))){
var state_9563__$1 = state_9563;
var statearr_9591_9644 = state_9563__$1;
(statearr_9591_9644[(2)] = false);

(statearr_9591_9644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (28))){
var inst_9533 = (state_9563[(2)]);
var inst_9534 = calc_state.call(null);
var inst_9490 = inst_9534;
var state_9563__$1 = (function (){var statearr_9592 = state_9563;
(statearr_9592[(7)] = inst_9490);

(statearr_9592[(15)] = inst_9533);

return statearr_9592;
})();
var statearr_9593_9645 = state_9563__$1;
(statearr_9593_9645[(2)] = null);

(statearr_9593_9645[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (25))){
var inst_9559 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9594_9646 = state_9563__$1;
(statearr_9594_9646[(2)] = inst_9559);

(statearr_9594_9646[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (34))){
var inst_9557 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9595_9647 = state_9563__$1;
(statearr_9595_9647[(2)] = inst_9557);

(statearr_9595_9647[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (17))){
var state_9563__$1 = state_9563;
var statearr_9596_9648 = state_9563__$1;
(statearr_9596_9648[(2)] = false);

(statearr_9596_9648[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (3))){
var state_9563__$1 = state_9563;
var statearr_9597_9649 = state_9563__$1;
(statearr_9597_9649[(2)] = false);

(statearr_9597_9649[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (12))){
var inst_9561 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9563__$1,inst_9561);
} else {
if((state_val_9564 === (2))){
var inst_9465 = (state_9563[(8)]);
var inst_9470 = inst_9465.cljs$lang$protocol_mask$partition0$;
var inst_9471 = (inst_9470 & (64));
var inst_9472 = inst_9465.cljs$core$ISeq$;
var inst_9473 = (cljs.core.PROTOCOL_SENTINEL === inst_9472);
var inst_9474 = ((inst_9471) || (inst_9473));
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9474)){
var statearr_9598_9650 = state_9563__$1;
(statearr_9598_9650[(1)] = (5));

} else {
var statearr_9599_9651 = state_9563__$1;
(statearr_9599_9651[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (23))){
var inst_9522 = (state_9563[(14)]);
var inst_9528 = (inst_9522 == null);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9528)){
var statearr_9600_9652 = state_9563__$1;
(statearr_9600_9652[(1)] = (26));

} else {
var statearr_9601_9653 = state_9563__$1;
(statearr_9601_9653[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (35))){
var inst_9548 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9548)){
var statearr_9602_9654 = state_9563__$1;
(statearr_9602_9654[(1)] = (36));

} else {
var statearr_9603_9655 = state_9563__$1;
(statearr_9603_9655[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (19))){
var inst_9490 = (state_9563[(7)]);
var inst_9510 = cljs.core.apply.call(null,cljs.core.hash_map,inst_9490);
var state_9563__$1 = state_9563;
var statearr_9604_9656 = state_9563__$1;
(statearr_9604_9656[(2)] = inst_9510);

(statearr_9604_9656[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (11))){
var inst_9490 = (state_9563[(7)]);
var inst_9494 = (inst_9490 == null);
var inst_9495 = cljs.core.not.call(null,inst_9494);
var state_9563__$1 = state_9563;
if(inst_9495){
var statearr_9605_9657 = state_9563__$1;
(statearr_9605_9657[(1)] = (13));

} else {
var statearr_9606_9658 = state_9563__$1;
(statearr_9606_9658[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (9))){
var inst_9465 = (state_9563[(8)]);
var state_9563__$1 = state_9563;
var statearr_9607_9659 = state_9563__$1;
(statearr_9607_9659[(2)] = inst_9465);

(statearr_9607_9659[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (5))){
var state_9563__$1 = state_9563;
var statearr_9608_9660 = state_9563__$1;
(statearr_9608_9660[(2)] = true);

(statearr_9608_9660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (14))){
var state_9563__$1 = state_9563;
var statearr_9609_9661 = state_9563__$1;
(statearr_9609_9661[(2)] = false);

(statearr_9609_9661[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (26))){
var inst_9523 = (state_9563[(9)]);
var inst_9530 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_9523);
var state_9563__$1 = state_9563;
var statearr_9610_9662 = state_9563__$1;
(statearr_9610_9662[(2)] = inst_9530);

(statearr_9610_9662[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (16))){
var state_9563__$1 = state_9563;
var statearr_9611_9663 = state_9563__$1;
(statearr_9611_9663[(2)] = true);

(statearr_9611_9663[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (38))){
var inst_9553 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9612_9664 = state_9563__$1;
(statearr_9612_9664[(2)] = inst_9553);

(statearr_9612_9664[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (30))){
var inst_9515 = (state_9563[(13)]);
var inst_9523 = (state_9563[(9)]);
var inst_9514 = (state_9563[(10)]);
var inst_9540 = cljs.core.empty_QMARK_.call(null,inst_9514);
var inst_9541 = inst_9515.call(null,inst_9523);
var inst_9542 = cljs.core.not.call(null,inst_9541);
var inst_9543 = ((inst_9540) && (inst_9542));
var state_9563__$1 = state_9563;
var statearr_9613_9665 = state_9563__$1;
(statearr_9613_9665[(2)] = inst_9543);

(statearr_9613_9665[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (10))){
var inst_9465 = (state_9563[(8)]);
var inst_9486 = (state_9563[(2)]);
var inst_9487 = cljs.core.get.call(null,inst_9486,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9488 = cljs.core.get.call(null,inst_9486,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9489 = cljs.core.get.call(null,inst_9486,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_9490 = inst_9465;
var state_9563__$1 = (function (){var statearr_9614 = state_9563;
(statearr_9614[(7)] = inst_9490);

(statearr_9614[(16)] = inst_9489);

(statearr_9614[(17)] = inst_9487);

(statearr_9614[(18)] = inst_9488);

return statearr_9614;
})();
var statearr_9615_9666 = state_9563__$1;
(statearr_9615_9666[(2)] = null);

(statearr_9615_9666[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (18))){
var inst_9505 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9616_9667 = state_9563__$1;
(statearr_9616_9667[(2)] = inst_9505);

(statearr_9616_9667[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (37))){
var state_9563__$1 = state_9563;
var statearr_9617_9668 = state_9563__$1;
(statearr_9617_9668[(2)] = null);

(statearr_9617_9668[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (8))){
var inst_9465 = (state_9563[(8)]);
var inst_9483 = cljs.core.apply.call(null,cljs.core.hash_map,inst_9465);
var state_9563__$1 = state_9563;
var statearr_9618_9669 = state_9563__$1;
(statearr_9618_9669[(2)] = inst_9483);

(statearr_9618_9669[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___9623,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__8474__auto__,c__8564__auto___9623,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__8475__auto__ = null;
var cljs$core$async$mix_$_state_machine__8475__auto____0 = (function (){
var statearr_9619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9619[(0)] = cljs$core$async$mix_$_state_machine__8475__auto__);

(statearr_9619[(1)] = (1));

return statearr_9619;
});
var cljs$core$async$mix_$_state_machine__8475__auto____1 = (function (state_9563){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_9563);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9620){if((e9620 instanceof Object)){
var ex__8478__auto__ = e9620;
var statearr_9621_9670 = state_9563;
(statearr_9621_9670[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9563);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9620;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9671 = state_9563;
state_9563 = G__9671;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8475__auto__ = function(state_9563){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8475__auto____1.call(this,state_9563);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8475__auto____0;
cljs$core$async$mix_$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8475__auto____1;
return cljs$core$async$mix_$_state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___9623,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__8566__auto__ = (function (){var statearr_9622 = f__8565__auto__.call(null);
(statearr_9622[(6)] = c__8564__auto___9623);

return statearr_9622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___9623,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4212__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v,ch);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__9673 = arguments.length;
switch (G__9673) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if(((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4211__auto__ = (((p == null))?null:p);
var m__4212__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4211__auto__)]);
if(!((m__4212__auto__ == null))){
return m__4212__auto__.call(null,p,v);
} else {
var m__4212__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__4212__auto____$1 == null))){
return m__4212__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__9677 = arguments.length;
switch (G__9677) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__3922__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__3922__auto__)){
return or__3922__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__3922__auto__,mults){
return (function (p1__9675_SHARP_){
if(cljs.core.truth_(p1__9675_SHARP_.call(null,topic))){
return p1__9675_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__9675_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__3922__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async9678 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9678 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta9679){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta9679 = meta9679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_9680,meta9679__$1){
var self__ = this;
var _9680__$1 = this;
return (new cljs.core.async.t_cljs$core$async9678(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta9679__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_9680){
var self__ = this;
var _9680__$1 = this;
return self__.meta9679;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9678.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9678.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta9679","meta9679",-471882570,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async9678.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async9678.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9678";

cljs.core.async.t_cljs$core$async9678.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async9678");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9678.
 */
cljs.core.async.__GT_t_cljs$core$async9678 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async9678(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta9679){
return (new cljs.core.async.t_cljs$core$async9678(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta9679));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async9678(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8564__auto___9798 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___9798,mults,ensure_mult,p){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___9798,mults,ensure_mult,p){
return (function (state_9752){
var state_val_9753 = (state_9752[(1)]);
if((state_val_9753 === (7))){
var inst_9748 = (state_9752[(2)]);
var state_9752__$1 = state_9752;
var statearr_9754_9799 = state_9752__$1;
(statearr_9754_9799[(2)] = inst_9748);

(statearr_9754_9799[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (20))){
var state_9752__$1 = state_9752;
var statearr_9755_9800 = state_9752__$1;
(statearr_9755_9800[(2)] = null);

(statearr_9755_9800[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (1))){
var state_9752__$1 = state_9752;
var statearr_9756_9801 = state_9752__$1;
(statearr_9756_9801[(2)] = null);

(statearr_9756_9801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (24))){
var inst_9731 = (state_9752[(7)]);
var inst_9740 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_9731);
var state_9752__$1 = state_9752;
var statearr_9757_9802 = state_9752__$1;
(statearr_9757_9802[(2)] = inst_9740);

(statearr_9757_9802[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (4))){
var inst_9683 = (state_9752[(8)]);
var inst_9683__$1 = (state_9752[(2)]);
var inst_9684 = (inst_9683__$1 == null);
var state_9752__$1 = (function (){var statearr_9758 = state_9752;
(statearr_9758[(8)] = inst_9683__$1);

return statearr_9758;
})();
if(cljs.core.truth_(inst_9684)){
var statearr_9759_9803 = state_9752__$1;
(statearr_9759_9803[(1)] = (5));

} else {
var statearr_9760_9804 = state_9752__$1;
(statearr_9760_9804[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (15))){
var inst_9725 = (state_9752[(2)]);
var state_9752__$1 = state_9752;
var statearr_9761_9805 = state_9752__$1;
(statearr_9761_9805[(2)] = inst_9725);

(statearr_9761_9805[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (21))){
var inst_9745 = (state_9752[(2)]);
var state_9752__$1 = (function (){var statearr_9762 = state_9752;
(statearr_9762[(9)] = inst_9745);

return statearr_9762;
})();
var statearr_9763_9806 = state_9752__$1;
(statearr_9763_9806[(2)] = null);

(statearr_9763_9806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (13))){
var inst_9707 = (state_9752[(10)]);
var inst_9709 = cljs.core.chunked_seq_QMARK_.call(null,inst_9707);
var state_9752__$1 = state_9752;
if(inst_9709){
var statearr_9764_9807 = state_9752__$1;
(statearr_9764_9807[(1)] = (16));

} else {
var statearr_9765_9808 = state_9752__$1;
(statearr_9765_9808[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (22))){
var inst_9737 = (state_9752[(2)]);
var state_9752__$1 = state_9752;
if(cljs.core.truth_(inst_9737)){
var statearr_9766_9809 = state_9752__$1;
(statearr_9766_9809[(1)] = (23));

} else {
var statearr_9767_9810 = state_9752__$1;
(statearr_9767_9810[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (6))){
var inst_9683 = (state_9752[(8)]);
var inst_9733 = (state_9752[(11)]);
var inst_9731 = (state_9752[(7)]);
var inst_9731__$1 = topic_fn.call(null,inst_9683);
var inst_9732 = cljs.core.deref.call(null,mults);
var inst_9733__$1 = cljs.core.get.call(null,inst_9732,inst_9731__$1);
var state_9752__$1 = (function (){var statearr_9768 = state_9752;
(statearr_9768[(11)] = inst_9733__$1);

(statearr_9768[(7)] = inst_9731__$1);

return statearr_9768;
})();
if(cljs.core.truth_(inst_9733__$1)){
var statearr_9769_9811 = state_9752__$1;
(statearr_9769_9811[(1)] = (19));

} else {
var statearr_9770_9812 = state_9752__$1;
(statearr_9770_9812[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (25))){
var inst_9742 = (state_9752[(2)]);
var state_9752__$1 = state_9752;
var statearr_9771_9813 = state_9752__$1;
(statearr_9771_9813[(2)] = inst_9742);

(statearr_9771_9813[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (17))){
var inst_9707 = (state_9752[(10)]);
var inst_9716 = cljs.core.first.call(null,inst_9707);
var inst_9717 = cljs.core.async.muxch_STAR_.call(null,inst_9716);
var inst_9718 = cljs.core.async.close_BANG_.call(null,inst_9717);
var inst_9719 = cljs.core.next.call(null,inst_9707);
var inst_9693 = inst_9719;
var inst_9694 = null;
var inst_9695 = (0);
var inst_9696 = (0);
var state_9752__$1 = (function (){var statearr_9772 = state_9752;
(statearr_9772[(12)] = inst_9694);

(statearr_9772[(13)] = inst_9695);

(statearr_9772[(14)] = inst_9693);

(statearr_9772[(15)] = inst_9718);

(statearr_9772[(16)] = inst_9696);

return statearr_9772;
})();
var statearr_9773_9814 = state_9752__$1;
(statearr_9773_9814[(2)] = null);

(statearr_9773_9814[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (3))){
var inst_9750 = (state_9752[(2)]);
var state_9752__$1 = state_9752;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9752__$1,inst_9750);
} else {
if((state_val_9753 === (12))){
var inst_9727 = (state_9752[(2)]);
var state_9752__$1 = state_9752;
var statearr_9774_9815 = state_9752__$1;
(statearr_9774_9815[(2)] = inst_9727);

(statearr_9774_9815[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (2))){
var state_9752__$1 = state_9752;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9752__$1,(4),ch);
} else {
if((state_val_9753 === (23))){
var state_9752__$1 = state_9752;
var statearr_9775_9816 = state_9752__$1;
(statearr_9775_9816[(2)] = null);

(statearr_9775_9816[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (19))){
var inst_9683 = (state_9752[(8)]);
var inst_9733 = (state_9752[(11)]);
var inst_9735 = cljs.core.async.muxch_STAR_.call(null,inst_9733);
var state_9752__$1 = state_9752;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9752__$1,(22),inst_9735,inst_9683);
} else {
if((state_val_9753 === (11))){
var inst_9707 = (state_9752[(10)]);
var inst_9693 = (state_9752[(14)]);
var inst_9707__$1 = cljs.core.seq.call(null,inst_9693);
var state_9752__$1 = (function (){var statearr_9776 = state_9752;
(statearr_9776[(10)] = inst_9707__$1);

return statearr_9776;
})();
if(inst_9707__$1){
var statearr_9777_9817 = state_9752__$1;
(statearr_9777_9817[(1)] = (13));

} else {
var statearr_9778_9818 = state_9752__$1;
(statearr_9778_9818[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (9))){
var inst_9729 = (state_9752[(2)]);
var state_9752__$1 = state_9752;
var statearr_9779_9819 = state_9752__$1;
(statearr_9779_9819[(2)] = inst_9729);

(statearr_9779_9819[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (5))){
var inst_9690 = cljs.core.deref.call(null,mults);
var inst_9691 = cljs.core.vals.call(null,inst_9690);
var inst_9692 = cljs.core.seq.call(null,inst_9691);
var inst_9693 = inst_9692;
var inst_9694 = null;
var inst_9695 = (0);
var inst_9696 = (0);
var state_9752__$1 = (function (){var statearr_9780 = state_9752;
(statearr_9780[(12)] = inst_9694);

(statearr_9780[(13)] = inst_9695);

(statearr_9780[(14)] = inst_9693);

(statearr_9780[(16)] = inst_9696);

return statearr_9780;
})();
var statearr_9781_9820 = state_9752__$1;
(statearr_9781_9820[(2)] = null);

(statearr_9781_9820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (14))){
var state_9752__$1 = state_9752;
var statearr_9785_9821 = state_9752__$1;
(statearr_9785_9821[(2)] = null);

(statearr_9785_9821[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (16))){
var inst_9707 = (state_9752[(10)]);
var inst_9711 = cljs.core.chunk_first.call(null,inst_9707);
var inst_9712 = cljs.core.chunk_rest.call(null,inst_9707);
var inst_9713 = cljs.core.count.call(null,inst_9711);
var inst_9693 = inst_9712;
var inst_9694 = inst_9711;
var inst_9695 = inst_9713;
var inst_9696 = (0);
var state_9752__$1 = (function (){var statearr_9786 = state_9752;
(statearr_9786[(12)] = inst_9694);

(statearr_9786[(13)] = inst_9695);

(statearr_9786[(14)] = inst_9693);

(statearr_9786[(16)] = inst_9696);

return statearr_9786;
})();
var statearr_9787_9822 = state_9752__$1;
(statearr_9787_9822[(2)] = null);

(statearr_9787_9822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (10))){
var inst_9694 = (state_9752[(12)]);
var inst_9695 = (state_9752[(13)]);
var inst_9693 = (state_9752[(14)]);
var inst_9696 = (state_9752[(16)]);
var inst_9701 = cljs.core._nth.call(null,inst_9694,inst_9696);
var inst_9702 = cljs.core.async.muxch_STAR_.call(null,inst_9701);
var inst_9703 = cljs.core.async.close_BANG_.call(null,inst_9702);
var inst_9704 = (inst_9696 + (1));
var tmp9782 = inst_9694;
var tmp9783 = inst_9695;
var tmp9784 = inst_9693;
var inst_9693__$1 = tmp9784;
var inst_9694__$1 = tmp9782;
var inst_9695__$1 = tmp9783;
var inst_9696__$1 = inst_9704;
var state_9752__$1 = (function (){var statearr_9788 = state_9752;
(statearr_9788[(12)] = inst_9694__$1);

(statearr_9788[(13)] = inst_9695__$1);

(statearr_9788[(14)] = inst_9693__$1);

(statearr_9788[(17)] = inst_9703);

(statearr_9788[(16)] = inst_9696__$1);

return statearr_9788;
})();
var statearr_9789_9823 = state_9752__$1;
(statearr_9789_9823[(2)] = null);

(statearr_9789_9823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (18))){
var inst_9722 = (state_9752[(2)]);
var state_9752__$1 = state_9752;
var statearr_9790_9824 = state_9752__$1;
(statearr_9790_9824[(2)] = inst_9722);

(statearr_9790_9824[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9753 === (8))){
var inst_9695 = (state_9752[(13)]);
var inst_9696 = (state_9752[(16)]);
var inst_9698 = (inst_9696 < inst_9695);
var inst_9699 = inst_9698;
var state_9752__$1 = state_9752;
if(cljs.core.truth_(inst_9699)){
var statearr_9791_9825 = state_9752__$1;
(statearr_9791_9825[(1)] = (10));

} else {
var statearr_9792_9826 = state_9752__$1;
(statearr_9792_9826[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___9798,mults,ensure_mult,p))
;
return ((function (switch__8474__auto__,c__8564__auto___9798,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_9793 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9793[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_9793[(1)] = (1));

return statearr_9793;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_9752){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_9752);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9794){if((e9794 instanceof Object)){
var ex__8478__auto__ = e9794;
var statearr_9795_9827 = state_9752;
(statearr_9795_9827[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9752);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9794;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9828 = state_9752;
state_9752 = G__9828;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_9752){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_9752);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___9798,mults,ensure_mult,p))
})();
var state__8566__auto__ = (function (){var statearr_9796 = f__8565__auto__.call(null);
(statearr_9796[(6)] = c__8564__auto___9798);

return statearr_9796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___9798,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__9830 = arguments.length;
switch (G__9830) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__9833 = arguments.length;
switch (G__9833) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__9836 = arguments.length;
switch (G__9836) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__8564__auto___9903 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___9903,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___9903,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_9875){
var state_val_9876 = (state_9875[(1)]);
if((state_val_9876 === (7))){
var state_9875__$1 = state_9875;
var statearr_9877_9904 = state_9875__$1;
(statearr_9877_9904[(2)] = null);

(statearr_9877_9904[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (1))){
var state_9875__$1 = state_9875;
var statearr_9878_9905 = state_9875__$1;
(statearr_9878_9905[(2)] = null);

(statearr_9878_9905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (4))){
var inst_9839 = (state_9875[(7)]);
var inst_9841 = (inst_9839 < cnt);
var state_9875__$1 = state_9875;
if(cljs.core.truth_(inst_9841)){
var statearr_9879_9906 = state_9875__$1;
(statearr_9879_9906[(1)] = (6));

} else {
var statearr_9880_9907 = state_9875__$1;
(statearr_9880_9907[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (15))){
var inst_9871 = (state_9875[(2)]);
var state_9875__$1 = state_9875;
var statearr_9881_9908 = state_9875__$1;
(statearr_9881_9908[(2)] = inst_9871);

(statearr_9881_9908[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (13))){
var inst_9864 = cljs.core.async.close_BANG_.call(null,out);
var state_9875__$1 = state_9875;
var statearr_9882_9909 = state_9875__$1;
(statearr_9882_9909[(2)] = inst_9864);

(statearr_9882_9909[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (6))){
var state_9875__$1 = state_9875;
var statearr_9883_9910 = state_9875__$1;
(statearr_9883_9910[(2)] = null);

(statearr_9883_9910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (3))){
var inst_9873 = (state_9875[(2)]);
var state_9875__$1 = state_9875;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9875__$1,inst_9873);
} else {
if((state_val_9876 === (12))){
var inst_9861 = (state_9875[(8)]);
var inst_9861__$1 = (state_9875[(2)]);
var inst_9862 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_9861__$1);
var state_9875__$1 = (function (){var statearr_9884 = state_9875;
(statearr_9884[(8)] = inst_9861__$1);

return statearr_9884;
})();
if(cljs.core.truth_(inst_9862)){
var statearr_9885_9911 = state_9875__$1;
(statearr_9885_9911[(1)] = (13));

} else {
var statearr_9886_9912 = state_9875__$1;
(statearr_9886_9912[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (2))){
var inst_9838 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_9839 = (0);
var state_9875__$1 = (function (){var statearr_9887 = state_9875;
(statearr_9887[(9)] = inst_9838);

(statearr_9887[(7)] = inst_9839);

return statearr_9887;
})();
var statearr_9888_9913 = state_9875__$1;
(statearr_9888_9913[(2)] = null);

(statearr_9888_9913[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (11))){
var inst_9839 = (state_9875[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_9875,(10),Object,null,(9));
var inst_9848 = chs__$1.call(null,inst_9839);
var inst_9849 = done.call(null,inst_9839);
var inst_9850 = cljs.core.async.take_BANG_.call(null,inst_9848,inst_9849);
var state_9875__$1 = state_9875;
var statearr_9889_9914 = state_9875__$1;
(statearr_9889_9914[(2)] = inst_9850);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9875__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (9))){
var inst_9839 = (state_9875[(7)]);
var inst_9852 = (state_9875[(2)]);
var inst_9853 = (inst_9839 + (1));
var inst_9839__$1 = inst_9853;
var state_9875__$1 = (function (){var statearr_9890 = state_9875;
(statearr_9890[(10)] = inst_9852);

(statearr_9890[(7)] = inst_9839__$1);

return statearr_9890;
})();
var statearr_9891_9915 = state_9875__$1;
(statearr_9891_9915[(2)] = null);

(statearr_9891_9915[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (5))){
var inst_9859 = (state_9875[(2)]);
var state_9875__$1 = (function (){var statearr_9892 = state_9875;
(statearr_9892[(11)] = inst_9859);

return statearr_9892;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_9875__$1,(12),dchan);
} else {
if((state_val_9876 === (14))){
var inst_9861 = (state_9875[(8)]);
var inst_9866 = cljs.core.apply.call(null,f,inst_9861);
var state_9875__$1 = state_9875;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9875__$1,(16),out,inst_9866);
} else {
if((state_val_9876 === (16))){
var inst_9868 = (state_9875[(2)]);
var state_9875__$1 = (function (){var statearr_9893 = state_9875;
(statearr_9893[(12)] = inst_9868);

return statearr_9893;
})();
var statearr_9894_9916 = state_9875__$1;
(statearr_9894_9916[(2)] = null);

(statearr_9894_9916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (10))){
var inst_9843 = (state_9875[(2)]);
var inst_9844 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_9875__$1 = (function (){var statearr_9895 = state_9875;
(statearr_9895[(13)] = inst_9843);

return statearr_9895;
})();
var statearr_9896_9917 = state_9875__$1;
(statearr_9896_9917[(2)] = inst_9844);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9875__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9876 === (8))){
var inst_9857 = (state_9875[(2)]);
var state_9875__$1 = state_9875;
var statearr_9897_9918 = state_9875__$1;
(statearr_9897_9918[(2)] = inst_9857);

(statearr_9897_9918[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___9903,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__8474__auto__,c__8564__auto___9903,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_9898 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9898[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_9898[(1)] = (1));

return statearr_9898;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_9875){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_9875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9899){if((e9899 instanceof Object)){
var ex__8478__auto__ = e9899;
var statearr_9900_9919 = state_9875;
(statearr_9900_9919[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9875);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9899;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9920 = state_9875;
state_9875 = G__9920;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_9875){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_9875);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___9903,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__8566__auto__ = (function (){var statearr_9901 = f__8565__auto__.call(null);
(statearr_9901[(6)] = c__8564__auto___9903);

return statearr_9901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___9903,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__9923 = arguments.length;
switch (G__9923) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8564__auto___9977 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___9977,out){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___9977,out){
return (function (state_9955){
var state_val_9956 = (state_9955[(1)]);
if((state_val_9956 === (7))){
var inst_9935 = (state_9955[(7)]);
var inst_9934 = (state_9955[(8)]);
var inst_9934__$1 = (state_9955[(2)]);
var inst_9935__$1 = cljs.core.nth.call(null,inst_9934__$1,(0),null);
var inst_9936 = cljs.core.nth.call(null,inst_9934__$1,(1),null);
var inst_9937 = (inst_9935__$1 == null);
var state_9955__$1 = (function (){var statearr_9957 = state_9955;
(statearr_9957[(7)] = inst_9935__$1);

(statearr_9957[(9)] = inst_9936);

(statearr_9957[(8)] = inst_9934__$1);

return statearr_9957;
})();
if(cljs.core.truth_(inst_9937)){
var statearr_9958_9978 = state_9955__$1;
(statearr_9958_9978[(1)] = (8));

} else {
var statearr_9959_9979 = state_9955__$1;
(statearr_9959_9979[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9956 === (1))){
var inst_9924 = cljs.core.vec.call(null,chs);
var inst_9925 = inst_9924;
var state_9955__$1 = (function (){var statearr_9960 = state_9955;
(statearr_9960[(10)] = inst_9925);

return statearr_9960;
})();
var statearr_9961_9980 = state_9955__$1;
(statearr_9961_9980[(2)] = null);

(statearr_9961_9980[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9956 === (4))){
var inst_9925 = (state_9955[(10)]);
var state_9955__$1 = state_9955;
return cljs.core.async.ioc_alts_BANG_.call(null,state_9955__$1,(7),inst_9925);
} else {
if((state_val_9956 === (6))){
var inst_9951 = (state_9955[(2)]);
var state_9955__$1 = state_9955;
var statearr_9962_9981 = state_9955__$1;
(statearr_9962_9981[(2)] = inst_9951);

(statearr_9962_9981[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9956 === (3))){
var inst_9953 = (state_9955[(2)]);
var state_9955__$1 = state_9955;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_9955__$1,inst_9953);
} else {
if((state_val_9956 === (2))){
var inst_9925 = (state_9955[(10)]);
var inst_9927 = cljs.core.count.call(null,inst_9925);
var inst_9928 = (inst_9927 > (0));
var state_9955__$1 = state_9955;
if(cljs.core.truth_(inst_9928)){
var statearr_9964_9982 = state_9955__$1;
(statearr_9964_9982[(1)] = (4));

} else {
var statearr_9965_9983 = state_9955__$1;
(statearr_9965_9983[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9956 === (11))){
var inst_9925 = (state_9955[(10)]);
var inst_9944 = (state_9955[(2)]);
var tmp9963 = inst_9925;
var inst_9925__$1 = tmp9963;
var state_9955__$1 = (function (){var statearr_9966 = state_9955;
(statearr_9966[(11)] = inst_9944);

(statearr_9966[(10)] = inst_9925__$1);

return statearr_9966;
})();
var statearr_9967_9984 = state_9955__$1;
(statearr_9967_9984[(2)] = null);

(statearr_9967_9984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9956 === (9))){
var inst_9935 = (state_9955[(7)]);
var state_9955__$1 = state_9955;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_9955__$1,(11),out,inst_9935);
} else {
if((state_val_9956 === (5))){
var inst_9949 = cljs.core.async.close_BANG_.call(null,out);
var state_9955__$1 = state_9955;
var statearr_9968_9985 = state_9955__$1;
(statearr_9968_9985[(2)] = inst_9949);

(statearr_9968_9985[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9956 === (10))){
var inst_9947 = (state_9955[(2)]);
var state_9955__$1 = state_9955;
var statearr_9969_9986 = state_9955__$1;
(statearr_9969_9986[(2)] = inst_9947);

(statearr_9969_9986[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9956 === (8))){
var inst_9935 = (state_9955[(7)]);
var inst_9936 = (state_9955[(9)]);
var inst_9925 = (state_9955[(10)]);
var inst_9934 = (state_9955[(8)]);
var inst_9939 = (function (){var cs = inst_9925;
var vec__9930 = inst_9934;
var v = inst_9935;
var c = inst_9936;
return ((function (cs,vec__9930,v,c,inst_9935,inst_9936,inst_9925,inst_9934,state_val_9956,c__8564__auto___9977,out){
return (function (p1__9921_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__9921_SHARP_);
});
;})(cs,vec__9930,v,c,inst_9935,inst_9936,inst_9925,inst_9934,state_val_9956,c__8564__auto___9977,out))
})();
var inst_9940 = cljs.core.filterv.call(null,inst_9939,inst_9925);
var inst_9925__$1 = inst_9940;
var state_9955__$1 = (function (){var statearr_9970 = state_9955;
(statearr_9970[(10)] = inst_9925__$1);

return statearr_9970;
})();
var statearr_9971_9987 = state_9955__$1;
(statearr_9971_9987[(2)] = null);

(statearr_9971_9987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___9977,out))
;
return ((function (switch__8474__auto__,c__8564__auto___9977,out){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_9972 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9972[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_9972[(1)] = (1));

return statearr_9972;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_9955){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_9955);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e9973){if((e9973 instanceof Object)){
var ex__8478__auto__ = e9973;
var statearr_9974_9988 = state_9955;
(statearr_9974_9988[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_9955);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e9973;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9989 = state_9955;
state_9955 = G__9989;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_9955){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_9955);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___9977,out))
})();
var state__8566__auto__ = (function (){var statearr_9975 = f__8565__auto__.call(null);
(statearr_9975[(6)] = c__8564__auto___9977);

return statearr_9975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___9977,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__9991 = arguments.length;
switch (G__9991) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8564__auto___10036 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___10036,out){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___10036,out){
return (function (state_10015){
var state_val_10016 = (state_10015[(1)]);
if((state_val_10016 === (7))){
var inst_9997 = (state_10015[(7)]);
var inst_9997__$1 = (state_10015[(2)]);
var inst_9998 = (inst_9997__$1 == null);
var inst_9999 = cljs.core.not.call(null,inst_9998);
var state_10015__$1 = (function (){var statearr_10017 = state_10015;
(statearr_10017[(7)] = inst_9997__$1);

return statearr_10017;
})();
if(inst_9999){
var statearr_10018_10037 = state_10015__$1;
(statearr_10018_10037[(1)] = (8));

} else {
var statearr_10019_10038 = state_10015__$1;
(statearr_10019_10038[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10016 === (1))){
var inst_9992 = (0);
var state_10015__$1 = (function (){var statearr_10020 = state_10015;
(statearr_10020[(8)] = inst_9992);

return statearr_10020;
})();
var statearr_10021_10039 = state_10015__$1;
(statearr_10021_10039[(2)] = null);

(statearr_10021_10039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10016 === (4))){
var state_10015__$1 = state_10015;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10015__$1,(7),ch);
} else {
if((state_val_10016 === (6))){
var inst_10010 = (state_10015[(2)]);
var state_10015__$1 = state_10015;
var statearr_10022_10040 = state_10015__$1;
(statearr_10022_10040[(2)] = inst_10010);

(statearr_10022_10040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10016 === (3))){
var inst_10012 = (state_10015[(2)]);
var inst_10013 = cljs.core.async.close_BANG_.call(null,out);
var state_10015__$1 = (function (){var statearr_10023 = state_10015;
(statearr_10023[(9)] = inst_10012);

return statearr_10023;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10015__$1,inst_10013);
} else {
if((state_val_10016 === (2))){
var inst_9992 = (state_10015[(8)]);
var inst_9994 = (inst_9992 < n);
var state_10015__$1 = state_10015;
if(cljs.core.truth_(inst_9994)){
var statearr_10024_10041 = state_10015__$1;
(statearr_10024_10041[(1)] = (4));

} else {
var statearr_10025_10042 = state_10015__$1;
(statearr_10025_10042[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10016 === (11))){
var inst_9992 = (state_10015[(8)]);
var inst_10002 = (state_10015[(2)]);
var inst_10003 = (inst_9992 + (1));
var inst_9992__$1 = inst_10003;
var state_10015__$1 = (function (){var statearr_10026 = state_10015;
(statearr_10026[(10)] = inst_10002);

(statearr_10026[(8)] = inst_9992__$1);

return statearr_10026;
})();
var statearr_10027_10043 = state_10015__$1;
(statearr_10027_10043[(2)] = null);

(statearr_10027_10043[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10016 === (9))){
var state_10015__$1 = state_10015;
var statearr_10028_10044 = state_10015__$1;
(statearr_10028_10044[(2)] = null);

(statearr_10028_10044[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10016 === (5))){
var state_10015__$1 = state_10015;
var statearr_10029_10045 = state_10015__$1;
(statearr_10029_10045[(2)] = null);

(statearr_10029_10045[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10016 === (10))){
var inst_10007 = (state_10015[(2)]);
var state_10015__$1 = state_10015;
var statearr_10030_10046 = state_10015__$1;
(statearr_10030_10046[(2)] = inst_10007);

(statearr_10030_10046[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10016 === (8))){
var inst_9997 = (state_10015[(7)]);
var state_10015__$1 = state_10015;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10015__$1,(11),out,inst_9997);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___10036,out))
;
return ((function (switch__8474__auto__,c__8564__auto___10036,out){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_10031 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10031[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_10031[(1)] = (1));

return statearr_10031;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_10015){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_10015);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e10032){if((e10032 instanceof Object)){
var ex__8478__auto__ = e10032;
var statearr_10033_10047 = state_10015;
(statearr_10033_10047[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10015);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10048 = state_10015;
state_10015 = G__10048;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_10015){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_10015);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___10036,out))
})();
var state__8566__auto__ = (function (){var statearr_10034 = f__8565__auto__.call(null);
(statearr_10034[(6)] = c__8564__auto___10036);

return statearr_10034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___10036,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async10050 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10050 = (function (f,ch,meta10051){
this.f = f;
this.ch = ch;
this.meta10051 = meta10051;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10052,meta10051__$1){
var self__ = this;
var _10052__$1 = this;
return (new cljs.core.async.t_cljs$core$async10050(self__.f,self__.ch,meta10051__$1));
});

cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10052){
var self__ = this;
var _10052__$1 = this;
return self__.meta10051;
});

cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async10053 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10053 = (function (f,ch,meta10051,_,fn1,meta10054){
this.f = f;
this.ch = ch;
this.meta10051 = meta10051;
this._ = _;
this.fn1 = fn1;
this.meta10054 = meta10054;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10053.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_10055,meta10054__$1){
var self__ = this;
var _10055__$1 = this;
return (new cljs.core.async.t_cljs$core$async10053(self__.f,self__.ch,self__.meta10051,self__._,self__.fn1,meta10054__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async10053.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_10055){
var self__ = this;
var _10055__$1 = this;
return self__.meta10054;
});})(___$1))
;

cljs.core.async.t_cljs$core$async10053.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10053.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async10053.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async10053.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__10049_SHARP_){
return f1.call(null,(((p1__10049_SHARP_ == null))?null:self__.f.call(null,p1__10049_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async10053.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10051","meta10051",-2066131970,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async10050","cljs.core.async/t_cljs$core$async10050",1993547363,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta10054","meta10054",-467940211,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async10053.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10053.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10053";

cljs.core.async.t_cljs$core$async10053.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async10053");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10053.
 */
cljs.core.async.__GT_t_cljs$core$async10053 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10053(f__$1,ch__$1,meta10051__$1,___$2,fn1__$1,meta10054){
return (new cljs.core.async.t_cljs$core$async10053(f__$1,ch__$1,meta10051__$1,___$2,fn1__$1,meta10054));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async10053(self__.f,self__.ch,self__.meta10051,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__3911__auto__ = ret;
if(cljs.core.truth_(and__3911__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__3911__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10050.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async10050.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10051","meta10051",-2066131970,null)], null);
});

cljs.core.async.t_cljs$core$async10050.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10050.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10050";

cljs.core.async.t_cljs$core$async10050.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async10050");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10050.
 */
cljs.core.async.__GT_t_cljs$core$async10050 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10050(f__$1,ch__$1,meta10051){
return (new cljs.core.async.t_cljs$core$async10050(f__$1,ch__$1,meta10051));
});

}

return (new cljs.core.async.t_cljs$core$async10050(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async10056 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10056 = (function (f,ch,meta10057){
this.f = f;
this.ch = ch;
this.meta10057 = meta10057;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10056.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10058,meta10057__$1){
var self__ = this;
var _10058__$1 = this;
return (new cljs.core.async.t_cljs$core$async10056(self__.f,self__.ch,meta10057__$1));
});

cljs.core.async.t_cljs$core$async10056.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10058){
var self__ = this;
var _10058__$1 = this;
return self__.meta10057;
});

cljs.core.async.t_cljs$core$async10056.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10056.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10056.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10056.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async10056.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10056.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async10056.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10057","meta10057",2073905796,null)], null);
});

cljs.core.async.t_cljs$core$async10056.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10056.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10056";

cljs.core.async.t_cljs$core$async10056.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async10056");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10056.
 */
cljs.core.async.__GT_t_cljs$core$async10056 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async10056(f__$1,ch__$1,meta10057){
return (new cljs.core.async.t_cljs$core$async10056(f__$1,ch__$1,meta10057));
});

}

return (new cljs.core.async.t_cljs$core$async10056(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async10059 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10059 = (function (p,ch,meta10060){
this.p = p;
this.ch = ch;
this.meta10060 = meta10060;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10061,meta10060__$1){
var self__ = this;
var _10061__$1 = this;
return (new cljs.core.async.t_cljs$core$async10059(self__.p,self__.ch,meta10060__$1));
});

cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10061){
var self__ = this;
var _10061__$1 = this;
return self__.meta10060;
});

cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async10059.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async10059.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10060","meta10060",897584734,null)], null);
});

cljs.core.async.t_cljs$core$async10059.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async10059.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10059";

cljs.core.async.t_cljs$core$async10059.cljs$lang$ctorPrWriter = (function (this__4161__auto__,writer__4162__auto__,opt__4163__auto__){
return cljs.core._write.call(null,writer__4162__auto__,"cljs.core.async/t_cljs$core$async10059");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10059.
 */
cljs.core.async.__GT_t_cljs$core$async10059 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async10059(p__$1,ch__$1,meta10060){
return (new cljs.core.async.t_cljs$core$async10059(p__$1,ch__$1,meta10060));
});

}

return (new cljs.core.async.t_cljs$core$async10059(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__10063 = arguments.length;
switch (G__10063) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8564__auto___10103 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___10103,out){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___10103,out){
return (function (state_10084){
var state_val_10085 = (state_10084[(1)]);
if((state_val_10085 === (7))){
var inst_10080 = (state_10084[(2)]);
var state_10084__$1 = state_10084;
var statearr_10086_10104 = state_10084__$1;
(statearr_10086_10104[(2)] = inst_10080);

(statearr_10086_10104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10085 === (1))){
var state_10084__$1 = state_10084;
var statearr_10087_10105 = state_10084__$1;
(statearr_10087_10105[(2)] = null);

(statearr_10087_10105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10085 === (4))){
var inst_10066 = (state_10084[(7)]);
var inst_10066__$1 = (state_10084[(2)]);
var inst_10067 = (inst_10066__$1 == null);
var state_10084__$1 = (function (){var statearr_10088 = state_10084;
(statearr_10088[(7)] = inst_10066__$1);

return statearr_10088;
})();
if(cljs.core.truth_(inst_10067)){
var statearr_10089_10106 = state_10084__$1;
(statearr_10089_10106[(1)] = (5));

} else {
var statearr_10090_10107 = state_10084__$1;
(statearr_10090_10107[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10085 === (6))){
var inst_10066 = (state_10084[(7)]);
var inst_10071 = p.call(null,inst_10066);
var state_10084__$1 = state_10084;
if(cljs.core.truth_(inst_10071)){
var statearr_10091_10108 = state_10084__$1;
(statearr_10091_10108[(1)] = (8));

} else {
var statearr_10092_10109 = state_10084__$1;
(statearr_10092_10109[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10085 === (3))){
var inst_10082 = (state_10084[(2)]);
var state_10084__$1 = state_10084;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10084__$1,inst_10082);
} else {
if((state_val_10085 === (2))){
var state_10084__$1 = state_10084;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10084__$1,(4),ch);
} else {
if((state_val_10085 === (11))){
var inst_10074 = (state_10084[(2)]);
var state_10084__$1 = state_10084;
var statearr_10093_10110 = state_10084__$1;
(statearr_10093_10110[(2)] = inst_10074);

(statearr_10093_10110[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10085 === (9))){
var state_10084__$1 = state_10084;
var statearr_10094_10111 = state_10084__$1;
(statearr_10094_10111[(2)] = null);

(statearr_10094_10111[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10085 === (5))){
var inst_10069 = cljs.core.async.close_BANG_.call(null,out);
var state_10084__$1 = state_10084;
var statearr_10095_10112 = state_10084__$1;
(statearr_10095_10112[(2)] = inst_10069);

(statearr_10095_10112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10085 === (10))){
var inst_10077 = (state_10084[(2)]);
var state_10084__$1 = (function (){var statearr_10096 = state_10084;
(statearr_10096[(8)] = inst_10077);

return statearr_10096;
})();
var statearr_10097_10113 = state_10084__$1;
(statearr_10097_10113[(2)] = null);

(statearr_10097_10113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10085 === (8))){
var inst_10066 = (state_10084[(7)]);
var state_10084__$1 = state_10084;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10084__$1,(11),out,inst_10066);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___10103,out))
;
return ((function (switch__8474__auto__,c__8564__auto___10103,out){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_10098 = [null,null,null,null,null,null,null,null,null];
(statearr_10098[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_10098[(1)] = (1));

return statearr_10098;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_10084){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_10084);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e10099){if((e10099 instanceof Object)){
var ex__8478__auto__ = e10099;
var statearr_10100_10114 = state_10084;
(statearr_10100_10114[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10084);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10099;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10115 = state_10084;
state_10084 = G__10115;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_10084){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_10084);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___10103,out))
})();
var state__8566__auto__ = (function (){var statearr_10101 = f__8565__auto__.call(null);
(statearr_10101[(6)] = c__8564__auto___10103);

return statearr_10101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___10103,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__10117 = arguments.length;
switch (G__10117) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8564__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto__){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto__){
return (function (state_10180){
var state_val_10181 = (state_10180[(1)]);
if((state_val_10181 === (7))){
var inst_10176 = (state_10180[(2)]);
var state_10180__$1 = state_10180;
var statearr_10182_10220 = state_10180__$1;
(statearr_10182_10220[(2)] = inst_10176);

(statearr_10182_10220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (20))){
var inst_10146 = (state_10180[(7)]);
var inst_10157 = (state_10180[(2)]);
var inst_10158 = cljs.core.next.call(null,inst_10146);
var inst_10132 = inst_10158;
var inst_10133 = null;
var inst_10134 = (0);
var inst_10135 = (0);
var state_10180__$1 = (function (){var statearr_10183 = state_10180;
(statearr_10183[(8)] = inst_10132);

(statearr_10183[(9)] = inst_10135);

(statearr_10183[(10)] = inst_10133);

(statearr_10183[(11)] = inst_10157);

(statearr_10183[(12)] = inst_10134);

return statearr_10183;
})();
var statearr_10184_10221 = state_10180__$1;
(statearr_10184_10221[(2)] = null);

(statearr_10184_10221[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (1))){
var state_10180__$1 = state_10180;
var statearr_10185_10222 = state_10180__$1;
(statearr_10185_10222[(2)] = null);

(statearr_10185_10222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (4))){
var inst_10121 = (state_10180[(13)]);
var inst_10121__$1 = (state_10180[(2)]);
var inst_10122 = (inst_10121__$1 == null);
var state_10180__$1 = (function (){var statearr_10186 = state_10180;
(statearr_10186[(13)] = inst_10121__$1);

return statearr_10186;
})();
if(cljs.core.truth_(inst_10122)){
var statearr_10187_10223 = state_10180__$1;
(statearr_10187_10223[(1)] = (5));

} else {
var statearr_10188_10224 = state_10180__$1;
(statearr_10188_10224[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (15))){
var state_10180__$1 = state_10180;
var statearr_10192_10225 = state_10180__$1;
(statearr_10192_10225[(2)] = null);

(statearr_10192_10225[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (21))){
var state_10180__$1 = state_10180;
var statearr_10193_10226 = state_10180__$1;
(statearr_10193_10226[(2)] = null);

(statearr_10193_10226[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (13))){
var inst_10132 = (state_10180[(8)]);
var inst_10135 = (state_10180[(9)]);
var inst_10133 = (state_10180[(10)]);
var inst_10134 = (state_10180[(12)]);
var inst_10142 = (state_10180[(2)]);
var inst_10143 = (inst_10135 + (1));
var tmp10189 = inst_10132;
var tmp10190 = inst_10133;
var tmp10191 = inst_10134;
var inst_10132__$1 = tmp10189;
var inst_10133__$1 = tmp10190;
var inst_10134__$1 = tmp10191;
var inst_10135__$1 = inst_10143;
var state_10180__$1 = (function (){var statearr_10194 = state_10180;
(statearr_10194[(8)] = inst_10132__$1);

(statearr_10194[(9)] = inst_10135__$1);

(statearr_10194[(10)] = inst_10133__$1);

(statearr_10194[(14)] = inst_10142);

(statearr_10194[(12)] = inst_10134__$1);

return statearr_10194;
})();
var statearr_10195_10227 = state_10180__$1;
(statearr_10195_10227[(2)] = null);

(statearr_10195_10227[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (22))){
var state_10180__$1 = state_10180;
var statearr_10196_10228 = state_10180__$1;
(statearr_10196_10228[(2)] = null);

(statearr_10196_10228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (6))){
var inst_10121 = (state_10180[(13)]);
var inst_10130 = f.call(null,inst_10121);
var inst_10131 = cljs.core.seq.call(null,inst_10130);
var inst_10132 = inst_10131;
var inst_10133 = null;
var inst_10134 = (0);
var inst_10135 = (0);
var state_10180__$1 = (function (){var statearr_10197 = state_10180;
(statearr_10197[(8)] = inst_10132);

(statearr_10197[(9)] = inst_10135);

(statearr_10197[(10)] = inst_10133);

(statearr_10197[(12)] = inst_10134);

return statearr_10197;
})();
var statearr_10198_10229 = state_10180__$1;
(statearr_10198_10229[(2)] = null);

(statearr_10198_10229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (17))){
var inst_10146 = (state_10180[(7)]);
var inst_10150 = cljs.core.chunk_first.call(null,inst_10146);
var inst_10151 = cljs.core.chunk_rest.call(null,inst_10146);
var inst_10152 = cljs.core.count.call(null,inst_10150);
var inst_10132 = inst_10151;
var inst_10133 = inst_10150;
var inst_10134 = inst_10152;
var inst_10135 = (0);
var state_10180__$1 = (function (){var statearr_10199 = state_10180;
(statearr_10199[(8)] = inst_10132);

(statearr_10199[(9)] = inst_10135);

(statearr_10199[(10)] = inst_10133);

(statearr_10199[(12)] = inst_10134);

return statearr_10199;
})();
var statearr_10200_10230 = state_10180__$1;
(statearr_10200_10230[(2)] = null);

(statearr_10200_10230[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (3))){
var inst_10178 = (state_10180[(2)]);
var state_10180__$1 = state_10180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10180__$1,inst_10178);
} else {
if((state_val_10181 === (12))){
var inst_10166 = (state_10180[(2)]);
var state_10180__$1 = state_10180;
var statearr_10201_10231 = state_10180__$1;
(statearr_10201_10231[(2)] = inst_10166);

(statearr_10201_10231[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (2))){
var state_10180__$1 = state_10180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10180__$1,(4),in$);
} else {
if((state_val_10181 === (23))){
var inst_10174 = (state_10180[(2)]);
var state_10180__$1 = state_10180;
var statearr_10202_10232 = state_10180__$1;
(statearr_10202_10232[(2)] = inst_10174);

(statearr_10202_10232[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (19))){
var inst_10161 = (state_10180[(2)]);
var state_10180__$1 = state_10180;
var statearr_10203_10233 = state_10180__$1;
(statearr_10203_10233[(2)] = inst_10161);

(statearr_10203_10233[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (11))){
var inst_10132 = (state_10180[(8)]);
var inst_10146 = (state_10180[(7)]);
var inst_10146__$1 = cljs.core.seq.call(null,inst_10132);
var state_10180__$1 = (function (){var statearr_10204 = state_10180;
(statearr_10204[(7)] = inst_10146__$1);

return statearr_10204;
})();
if(inst_10146__$1){
var statearr_10205_10234 = state_10180__$1;
(statearr_10205_10234[(1)] = (14));

} else {
var statearr_10206_10235 = state_10180__$1;
(statearr_10206_10235[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (9))){
var inst_10168 = (state_10180[(2)]);
var inst_10169 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_10180__$1 = (function (){var statearr_10207 = state_10180;
(statearr_10207[(15)] = inst_10168);

return statearr_10207;
})();
if(cljs.core.truth_(inst_10169)){
var statearr_10208_10236 = state_10180__$1;
(statearr_10208_10236[(1)] = (21));

} else {
var statearr_10209_10237 = state_10180__$1;
(statearr_10209_10237[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (5))){
var inst_10124 = cljs.core.async.close_BANG_.call(null,out);
var state_10180__$1 = state_10180;
var statearr_10210_10238 = state_10180__$1;
(statearr_10210_10238[(2)] = inst_10124);

(statearr_10210_10238[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (14))){
var inst_10146 = (state_10180[(7)]);
var inst_10148 = cljs.core.chunked_seq_QMARK_.call(null,inst_10146);
var state_10180__$1 = state_10180;
if(inst_10148){
var statearr_10211_10239 = state_10180__$1;
(statearr_10211_10239[(1)] = (17));

} else {
var statearr_10212_10240 = state_10180__$1;
(statearr_10212_10240[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (16))){
var inst_10164 = (state_10180[(2)]);
var state_10180__$1 = state_10180;
var statearr_10213_10241 = state_10180__$1;
(statearr_10213_10241[(2)] = inst_10164);

(statearr_10213_10241[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10181 === (10))){
var inst_10135 = (state_10180[(9)]);
var inst_10133 = (state_10180[(10)]);
var inst_10140 = cljs.core._nth.call(null,inst_10133,inst_10135);
var state_10180__$1 = state_10180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10180__$1,(13),out,inst_10140);
} else {
if((state_val_10181 === (18))){
var inst_10146 = (state_10180[(7)]);
var inst_10155 = cljs.core.first.call(null,inst_10146);
var state_10180__$1 = state_10180;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10180__$1,(20),out,inst_10155);
} else {
if((state_val_10181 === (8))){
var inst_10135 = (state_10180[(9)]);
var inst_10134 = (state_10180[(12)]);
var inst_10137 = (inst_10135 < inst_10134);
var inst_10138 = inst_10137;
var state_10180__$1 = state_10180;
if(cljs.core.truth_(inst_10138)){
var statearr_10214_10242 = state_10180__$1;
(statearr_10214_10242[(1)] = (10));

} else {
var statearr_10215_10243 = state_10180__$1;
(statearr_10215_10243[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto__))
;
return ((function (switch__8474__auto__,c__8564__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8475__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8475__auto____0 = (function (){
var statearr_10216 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10216[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8475__auto__);

(statearr_10216[(1)] = (1));

return statearr_10216;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8475__auto____1 = (function (state_10180){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_10180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e10217){if((e10217 instanceof Object)){
var ex__8478__auto__ = e10217;
var statearr_10218_10244 = state_10180;
(statearr_10218_10244[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10180);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10217;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10245 = state_10180;
state_10180 = G__10245;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8475__auto__ = function(state_10180){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8475__auto____1.call(this,state_10180);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8475__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8475__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto__))
})();
var state__8566__auto__ = (function (){var statearr_10219 = f__8565__auto__.call(null);
(statearr_10219[(6)] = c__8564__auto__);

return statearr_10219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto__))
);

return c__8564__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__10247 = arguments.length;
switch (G__10247) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__10250 = arguments.length;
switch (G__10250) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__10253 = arguments.length;
switch (G__10253) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8564__auto___10300 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___10300,out){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___10300,out){
return (function (state_10277){
var state_val_10278 = (state_10277[(1)]);
if((state_val_10278 === (7))){
var inst_10272 = (state_10277[(2)]);
var state_10277__$1 = state_10277;
var statearr_10279_10301 = state_10277__$1;
(statearr_10279_10301[(2)] = inst_10272);

(statearr_10279_10301[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10278 === (1))){
var inst_10254 = null;
var state_10277__$1 = (function (){var statearr_10280 = state_10277;
(statearr_10280[(7)] = inst_10254);

return statearr_10280;
})();
var statearr_10281_10302 = state_10277__$1;
(statearr_10281_10302[(2)] = null);

(statearr_10281_10302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10278 === (4))){
var inst_10257 = (state_10277[(8)]);
var inst_10257__$1 = (state_10277[(2)]);
var inst_10258 = (inst_10257__$1 == null);
var inst_10259 = cljs.core.not.call(null,inst_10258);
var state_10277__$1 = (function (){var statearr_10282 = state_10277;
(statearr_10282[(8)] = inst_10257__$1);

return statearr_10282;
})();
if(inst_10259){
var statearr_10283_10303 = state_10277__$1;
(statearr_10283_10303[(1)] = (5));

} else {
var statearr_10284_10304 = state_10277__$1;
(statearr_10284_10304[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10278 === (6))){
var state_10277__$1 = state_10277;
var statearr_10285_10305 = state_10277__$1;
(statearr_10285_10305[(2)] = null);

(statearr_10285_10305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10278 === (3))){
var inst_10274 = (state_10277[(2)]);
var inst_10275 = cljs.core.async.close_BANG_.call(null,out);
var state_10277__$1 = (function (){var statearr_10286 = state_10277;
(statearr_10286[(9)] = inst_10274);

return statearr_10286;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10277__$1,inst_10275);
} else {
if((state_val_10278 === (2))){
var state_10277__$1 = state_10277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10277__$1,(4),ch);
} else {
if((state_val_10278 === (11))){
var inst_10257 = (state_10277[(8)]);
var inst_10266 = (state_10277[(2)]);
var inst_10254 = inst_10257;
var state_10277__$1 = (function (){var statearr_10287 = state_10277;
(statearr_10287[(10)] = inst_10266);

(statearr_10287[(7)] = inst_10254);

return statearr_10287;
})();
var statearr_10288_10306 = state_10277__$1;
(statearr_10288_10306[(2)] = null);

(statearr_10288_10306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10278 === (9))){
var inst_10257 = (state_10277[(8)]);
var state_10277__$1 = state_10277;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10277__$1,(11),out,inst_10257);
} else {
if((state_val_10278 === (5))){
var inst_10257 = (state_10277[(8)]);
var inst_10254 = (state_10277[(7)]);
var inst_10261 = cljs.core._EQ_.call(null,inst_10257,inst_10254);
var state_10277__$1 = state_10277;
if(inst_10261){
var statearr_10290_10307 = state_10277__$1;
(statearr_10290_10307[(1)] = (8));

} else {
var statearr_10291_10308 = state_10277__$1;
(statearr_10291_10308[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10278 === (10))){
var inst_10269 = (state_10277[(2)]);
var state_10277__$1 = state_10277;
var statearr_10292_10309 = state_10277__$1;
(statearr_10292_10309[(2)] = inst_10269);

(statearr_10292_10309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10278 === (8))){
var inst_10254 = (state_10277[(7)]);
var tmp10289 = inst_10254;
var inst_10254__$1 = tmp10289;
var state_10277__$1 = (function (){var statearr_10293 = state_10277;
(statearr_10293[(7)] = inst_10254__$1);

return statearr_10293;
})();
var statearr_10294_10310 = state_10277__$1;
(statearr_10294_10310[(2)] = null);

(statearr_10294_10310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___10300,out))
;
return ((function (switch__8474__auto__,c__8564__auto___10300,out){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_10295 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10295[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_10295[(1)] = (1));

return statearr_10295;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_10277){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_10277);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e10296){if((e10296 instanceof Object)){
var ex__8478__auto__ = e10296;
var statearr_10297_10311 = state_10277;
(statearr_10297_10311[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10277);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10296;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10312 = state_10277;
state_10277 = G__10312;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_10277){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_10277);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___10300,out))
})();
var state__8566__auto__ = (function (){var statearr_10298 = f__8565__auto__.call(null);
(statearr_10298[(6)] = c__8564__auto___10300);

return statearr_10298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___10300,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__10314 = arguments.length;
switch (G__10314) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8564__auto___10380 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___10380,out){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___10380,out){
return (function (state_10352){
var state_val_10353 = (state_10352[(1)]);
if((state_val_10353 === (7))){
var inst_10348 = (state_10352[(2)]);
var state_10352__$1 = state_10352;
var statearr_10354_10381 = state_10352__$1;
(statearr_10354_10381[(2)] = inst_10348);

(statearr_10354_10381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (1))){
var inst_10315 = (new Array(n));
var inst_10316 = inst_10315;
var inst_10317 = (0);
var state_10352__$1 = (function (){var statearr_10355 = state_10352;
(statearr_10355[(7)] = inst_10316);

(statearr_10355[(8)] = inst_10317);

return statearr_10355;
})();
var statearr_10356_10382 = state_10352__$1;
(statearr_10356_10382[(2)] = null);

(statearr_10356_10382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (4))){
var inst_10320 = (state_10352[(9)]);
var inst_10320__$1 = (state_10352[(2)]);
var inst_10321 = (inst_10320__$1 == null);
var inst_10322 = cljs.core.not.call(null,inst_10321);
var state_10352__$1 = (function (){var statearr_10357 = state_10352;
(statearr_10357[(9)] = inst_10320__$1);

return statearr_10357;
})();
if(inst_10322){
var statearr_10358_10383 = state_10352__$1;
(statearr_10358_10383[(1)] = (5));

} else {
var statearr_10359_10384 = state_10352__$1;
(statearr_10359_10384[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (15))){
var inst_10342 = (state_10352[(2)]);
var state_10352__$1 = state_10352;
var statearr_10360_10385 = state_10352__$1;
(statearr_10360_10385[(2)] = inst_10342);

(statearr_10360_10385[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (13))){
var state_10352__$1 = state_10352;
var statearr_10361_10386 = state_10352__$1;
(statearr_10361_10386[(2)] = null);

(statearr_10361_10386[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (6))){
var inst_10317 = (state_10352[(8)]);
var inst_10338 = (inst_10317 > (0));
var state_10352__$1 = state_10352;
if(cljs.core.truth_(inst_10338)){
var statearr_10362_10387 = state_10352__$1;
(statearr_10362_10387[(1)] = (12));

} else {
var statearr_10363_10388 = state_10352__$1;
(statearr_10363_10388[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (3))){
var inst_10350 = (state_10352[(2)]);
var state_10352__$1 = state_10352;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10352__$1,inst_10350);
} else {
if((state_val_10353 === (12))){
var inst_10316 = (state_10352[(7)]);
var inst_10340 = cljs.core.vec.call(null,inst_10316);
var state_10352__$1 = state_10352;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10352__$1,(15),out,inst_10340);
} else {
if((state_val_10353 === (2))){
var state_10352__$1 = state_10352;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10352__$1,(4),ch);
} else {
if((state_val_10353 === (11))){
var inst_10332 = (state_10352[(2)]);
var inst_10333 = (new Array(n));
var inst_10316 = inst_10333;
var inst_10317 = (0);
var state_10352__$1 = (function (){var statearr_10364 = state_10352;
(statearr_10364[(10)] = inst_10332);

(statearr_10364[(7)] = inst_10316);

(statearr_10364[(8)] = inst_10317);

return statearr_10364;
})();
var statearr_10365_10389 = state_10352__$1;
(statearr_10365_10389[(2)] = null);

(statearr_10365_10389[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (9))){
var inst_10316 = (state_10352[(7)]);
var inst_10330 = cljs.core.vec.call(null,inst_10316);
var state_10352__$1 = state_10352;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10352__$1,(11),out,inst_10330);
} else {
if((state_val_10353 === (5))){
var inst_10316 = (state_10352[(7)]);
var inst_10320 = (state_10352[(9)]);
var inst_10317 = (state_10352[(8)]);
var inst_10325 = (state_10352[(11)]);
var inst_10324 = (inst_10316[inst_10317] = inst_10320);
var inst_10325__$1 = (inst_10317 + (1));
var inst_10326 = (inst_10325__$1 < n);
var state_10352__$1 = (function (){var statearr_10366 = state_10352;
(statearr_10366[(11)] = inst_10325__$1);

(statearr_10366[(12)] = inst_10324);

return statearr_10366;
})();
if(cljs.core.truth_(inst_10326)){
var statearr_10367_10390 = state_10352__$1;
(statearr_10367_10390[(1)] = (8));

} else {
var statearr_10368_10391 = state_10352__$1;
(statearr_10368_10391[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (14))){
var inst_10345 = (state_10352[(2)]);
var inst_10346 = cljs.core.async.close_BANG_.call(null,out);
var state_10352__$1 = (function (){var statearr_10370 = state_10352;
(statearr_10370[(13)] = inst_10345);

return statearr_10370;
})();
var statearr_10371_10392 = state_10352__$1;
(statearr_10371_10392[(2)] = inst_10346);

(statearr_10371_10392[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (10))){
var inst_10336 = (state_10352[(2)]);
var state_10352__$1 = state_10352;
var statearr_10372_10393 = state_10352__$1;
(statearr_10372_10393[(2)] = inst_10336);

(statearr_10372_10393[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10353 === (8))){
var inst_10316 = (state_10352[(7)]);
var inst_10325 = (state_10352[(11)]);
var tmp10369 = inst_10316;
var inst_10316__$1 = tmp10369;
var inst_10317 = inst_10325;
var state_10352__$1 = (function (){var statearr_10373 = state_10352;
(statearr_10373[(7)] = inst_10316__$1);

(statearr_10373[(8)] = inst_10317);

return statearr_10373;
})();
var statearr_10374_10394 = state_10352__$1;
(statearr_10374_10394[(2)] = null);

(statearr_10374_10394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___10380,out))
;
return ((function (switch__8474__auto__,c__8564__auto___10380,out){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_10375 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10375[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_10375[(1)] = (1));

return statearr_10375;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_10352){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_10352);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e10376){if((e10376 instanceof Object)){
var ex__8478__auto__ = e10376;
var statearr_10377_10395 = state_10352;
(statearr_10377_10395[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10352);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10376;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10396 = state_10352;
state_10352 = G__10396;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_10352){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_10352);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___10380,out))
})();
var state__8566__auto__ = (function (){var statearr_10378 = f__8565__auto__.call(null);
(statearr_10378[(6)] = c__8564__auto___10380);

return statearr_10378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___10380,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__10398 = arguments.length;
switch (G__10398) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__8564__auto___10468 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__8564__auto___10468,out){
return (function (){
var f__8565__auto__ = (function (){var switch__8474__auto__ = ((function (c__8564__auto___10468,out){
return (function (state_10440){
var state_val_10441 = (state_10440[(1)]);
if((state_val_10441 === (7))){
var inst_10436 = (state_10440[(2)]);
var state_10440__$1 = state_10440;
var statearr_10442_10469 = state_10440__$1;
(statearr_10442_10469[(2)] = inst_10436);

(statearr_10442_10469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (1))){
var inst_10399 = [];
var inst_10400 = inst_10399;
var inst_10401 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_10440__$1 = (function (){var statearr_10443 = state_10440;
(statearr_10443[(7)] = inst_10400);

(statearr_10443[(8)] = inst_10401);

return statearr_10443;
})();
var statearr_10444_10470 = state_10440__$1;
(statearr_10444_10470[(2)] = null);

(statearr_10444_10470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (4))){
var inst_10404 = (state_10440[(9)]);
var inst_10404__$1 = (state_10440[(2)]);
var inst_10405 = (inst_10404__$1 == null);
var inst_10406 = cljs.core.not.call(null,inst_10405);
var state_10440__$1 = (function (){var statearr_10445 = state_10440;
(statearr_10445[(9)] = inst_10404__$1);

return statearr_10445;
})();
if(inst_10406){
var statearr_10446_10471 = state_10440__$1;
(statearr_10446_10471[(1)] = (5));

} else {
var statearr_10447_10472 = state_10440__$1;
(statearr_10447_10472[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (15))){
var inst_10430 = (state_10440[(2)]);
var state_10440__$1 = state_10440;
var statearr_10448_10473 = state_10440__$1;
(statearr_10448_10473[(2)] = inst_10430);

(statearr_10448_10473[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (13))){
var state_10440__$1 = state_10440;
var statearr_10449_10474 = state_10440__$1;
(statearr_10449_10474[(2)] = null);

(statearr_10449_10474[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (6))){
var inst_10400 = (state_10440[(7)]);
var inst_10425 = inst_10400.length;
var inst_10426 = (inst_10425 > (0));
var state_10440__$1 = state_10440;
if(cljs.core.truth_(inst_10426)){
var statearr_10450_10475 = state_10440__$1;
(statearr_10450_10475[(1)] = (12));

} else {
var statearr_10451_10476 = state_10440__$1;
(statearr_10451_10476[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (3))){
var inst_10438 = (state_10440[(2)]);
var state_10440__$1 = state_10440;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_10440__$1,inst_10438);
} else {
if((state_val_10441 === (12))){
var inst_10400 = (state_10440[(7)]);
var inst_10428 = cljs.core.vec.call(null,inst_10400);
var state_10440__$1 = state_10440;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10440__$1,(15),out,inst_10428);
} else {
if((state_val_10441 === (2))){
var state_10440__$1 = state_10440;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_10440__$1,(4),ch);
} else {
if((state_val_10441 === (11))){
var inst_10408 = (state_10440[(10)]);
var inst_10404 = (state_10440[(9)]);
var inst_10418 = (state_10440[(2)]);
var inst_10419 = [];
var inst_10420 = inst_10419.push(inst_10404);
var inst_10400 = inst_10419;
var inst_10401 = inst_10408;
var state_10440__$1 = (function (){var statearr_10452 = state_10440;
(statearr_10452[(7)] = inst_10400);

(statearr_10452[(11)] = inst_10420);

(statearr_10452[(8)] = inst_10401);

(statearr_10452[(12)] = inst_10418);

return statearr_10452;
})();
var statearr_10453_10477 = state_10440__$1;
(statearr_10453_10477[(2)] = null);

(statearr_10453_10477[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (9))){
var inst_10400 = (state_10440[(7)]);
var inst_10416 = cljs.core.vec.call(null,inst_10400);
var state_10440__$1 = state_10440;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_10440__$1,(11),out,inst_10416);
} else {
if((state_val_10441 === (5))){
var inst_10408 = (state_10440[(10)]);
var inst_10401 = (state_10440[(8)]);
var inst_10404 = (state_10440[(9)]);
var inst_10408__$1 = f.call(null,inst_10404);
var inst_10409 = cljs.core._EQ_.call(null,inst_10408__$1,inst_10401);
var inst_10410 = cljs.core.keyword_identical_QMARK_.call(null,inst_10401,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_10411 = ((inst_10409) || (inst_10410));
var state_10440__$1 = (function (){var statearr_10454 = state_10440;
(statearr_10454[(10)] = inst_10408__$1);

return statearr_10454;
})();
if(cljs.core.truth_(inst_10411)){
var statearr_10455_10478 = state_10440__$1;
(statearr_10455_10478[(1)] = (8));

} else {
var statearr_10456_10479 = state_10440__$1;
(statearr_10456_10479[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (14))){
var inst_10433 = (state_10440[(2)]);
var inst_10434 = cljs.core.async.close_BANG_.call(null,out);
var state_10440__$1 = (function (){var statearr_10458 = state_10440;
(statearr_10458[(13)] = inst_10433);

return statearr_10458;
})();
var statearr_10459_10480 = state_10440__$1;
(statearr_10459_10480[(2)] = inst_10434);

(statearr_10459_10480[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (10))){
var inst_10423 = (state_10440[(2)]);
var state_10440__$1 = state_10440;
var statearr_10460_10481 = state_10440__$1;
(statearr_10460_10481[(2)] = inst_10423);

(statearr_10460_10481[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10441 === (8))){
var inst_10400 = (state_10440[(7)]);
var inst_10408 = (state_10440[(10)]);
var inst_10404 = (state_10440[(9)]);
var inst_10413 = inst_10400.push(inst_10404);
var tmp10457 = inst_10400;
var inst_10400__$1 = tmp10457;
var inst_10401 = inst_10408;
var state_10440__$1 = (function (){var statearr_10461 = state_10440;
(statearr_10461[(7)] = inst_10400__$1);

(statearr_10461[(8)] = inst_10401);

(statearr_10461[(14)] = inst_10413);

return statearr_10461;
})();
var statearr_10462_10482 = state_10440__$1;
(statearr_10462_10482[(2)] = null);

(statearr_10462_10482[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__8564__auto___10468,out))
;
return ((function (switch__8474__auto__,c__8564__auto___10468,out){
return (function() {
var cljs$core$async$state_machine__8475__auto__ = null;
var cljs$core$async$state_machine__8475__auto____0 = (function (){
var statearr_10463 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10463[(0)] = cljs$core$async$state_machine__8475__auto__);

(statearr_10463[(1)] = (1));

return statearr_10463;
});
var cljs$core$async$state_machine__8475__auto____1 = (function (state_10440){
while(true){
var ret_value__8476__auto__ = (function (){try{while(true){
var result__8477__auto__ = switch__8474__auto__.call(null,state_10440);
if(cljs.core.keyword_identical_QMARK_.call(null,result__8477__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8477__auto__;
}
break;
}
}catch (e10464){if((e10464 instanceof Object)){
var ex__8478__auto__ = e10464;
var statearr_10465_10483 = state_10440;
(statearr_10465_10483[(5)] = ex__8478__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_10440);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e10464;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__8476__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10484 = state_10440;
state_10440 = G__10484;
continue;
} else {
return ret_value__8476__auto__;
}
break;
}
});
cljs$core$async$state_machine__8475__auto__ = function(state_10440){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8475__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8475__auto____1.call(this,state_10440);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8475__auto____0;
cljs$core$async$state_machine__8475__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8475__auto____1;
return cljs$core$async$state_machine__8475__auto__;
})()
;})(switch__8474__auto__,c__8564__auto___10468,out))
})();
var state__8566__auto__ = (function (){var statearr_10466 = f__8565__auto__.call(null);
(statearr_10466[(6)] = c__8564__auto___10468);

return statearr_10466;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__8566__auto__);
});})(c__8564__auto___10468,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1530627894354
