
(ns ^{:author "Eduardo Julian",
      :doc "Voting utils."}
     eejp-web-dev0.voting
  (:require [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [clj-orient.query :as oq]
            [eejp-web-dev0.core :as $]))

(def +VOTES+ :votes)

(defn vote "" [user item up-or-down]
  (if-not (first (og/get-links user item [:votes]))
    (let [k (if up-or-down :_up-votes :_down-votes)]
      (oc/save! (og/link! user :votes {:up-or-down up-or-down, :date (java.util.Date.)} item))
      (oc/save! (oc/passoc! item k (inc (or (oc/pget item k) 0))))
      true)
    false))

(defn unvote "" [user item]
  (if-let [vote (first (og/get-links user item :votes))]
    (let [k (if (oc/pget vote :up-or-down) :_up-votes :_down-votes)]
      (oc/save! (oc/passoc! item k (dec (or (oc/pget item k) 0))))
      (oc/delete! vote)
      true)
    false))

(defn get-votes [item] [(or (oc/pget item :_up-votes) 0) (or (oc/pget item :_down-votes) 0)])

(defn vote-ratio "" [item] (double (/ (or (oc/pget item :_up-votes) 0) (apply + (get-votes item)))))

(oc/with-db ($/get-db)
  (oq/defsqlfn o-vote-ratio [item]
    (double (/ (or (oc/pget item :_up-votes) 0) (apply + (get-votes item))))))
