
(ns ^{:author "Eduardo Julian",
      :doc "Miscellaneous utilities."}
     eejp-web-dev0.utils)

(defn extract-urls "Extracts URLs from a string."
  [txt]
  (filter #(or (.startsWith % "http") (.startsWith % "www"))
          (re-seq #"[https?://|www\.|https?://www\.]\w+[\.\w+]+[:\d+]?[/\w*]*[\?\p{Graph}+]*" txt)))

(defn read-input-stream "Reads an input stream into a byte array."
  [in]
  (let [buff (make-array Byte/TYPE 10240)
        bout (java.io.ByteArrayOutputStream.)]
    (loop [size (.read in buff)]
      (when (pos? size)
        (.write bout buff 0 size)
        (recur (.read in buff))))
    (.toByteArray bout)))
