
(ns ^{:author "Eduardo Julian",
      :doc "File handling."}
     eejp-web-dev0.files
  (:require [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [eejp-web-dev0.core :as $]))

(def +FILE+ :File)
($/deffetch fetch-file +FILE+)

(def +UPLOADS+ :uploads)
(def +HAS_MEDIA+ :has-media)

(defn create-file "" [filename mime size data]
  (let [d (java.util.Date.)]
    (oc/save! (oc/document :File {:filename filename, :data (oc/record-bytes data), :mime-type mime, :size size,
                                  :date d, :last-updated d}))))

(defn set-user-img "" [user file]
  (if (oc/pget user :user-img) (oc/delete! (oc/pget user :user-img)))
  (oc/save! (oc/passoc! user :user-img file)))

(defn delete-user-img "" [user]
  (oc/delete! (oc/pget user :user-img))
  (oc/save! (oc/passoc! user :user-img nil)))

(defn associate-media [item media] (oc/save! (og/link! item +HAS_MEDIA+ {:date (java.util.Date.)} media)))
