
(ns ^{:author "Eduardo Julian",
      :doc "Asynchronous File uploading."}
     eejp-web-dev0.cljs.file-upload
  (:require [eejp-web-dev0.cljs.core :as $]
            [eejp-web-dev0.cljs.dom :as $dom]
            [goog.events :as events]))

(defn file-selected [e]
  (if-let [file (aget (.-files (.-target e)) 0)]
    (let [cont ($dom/parent (.-target e))
          fname (first ($dom/by-class "file-name" cont))
          fmime (first ($dom/by-class "file-mime" cont))
          fsize (first ($dom/by-class "file-size" cont))
          size-n (if (> (.-size file) (* 1024 1024))
                    (str (/ (Math/round (/ (* 100 (.-size file)) (* 1024 1024))) 100) "MB")
                    (str (/ (Math/round (/ (* 100 (.-size file)) 1024)) 100) "KB"))]
      ($dom/set-text fname (str "Name: " (.-name file)))
      ($dom/set-text fmime (str "Type: " (.-type file)))
      ($dom/set-text fsize (str "Size: " size-n)))))

(defn upload-complete-eh [e] (js/alert "The upload has completed succesfully."))
(defn upload-cancelled-eh [e])
(defn upload-failed-eh [e] (js/alert "There was an error attempting to upload the file."))
(defn upload-progress-eh [prog e]
  (if (.lengthComputable e)
    ($dom/set-text prog (str (Math/round (/ (* (.-loaded e) 100) (.-total e))) "%"))
    ($dom/set-text prog "Unable to Compute Percentage")))

(defn upload-file [cont prog kcluss id files]
  (when-let [file (aget files 0)]
    (let [ajax (js/XMLHttpRequest.)]
      (.. ajax -upload (addEventListener "progress" (partial upload-progress-eh prog) false))
      (.addEventListener ajax "load" upload-complete-eh false)
      (.addEventListener ajax "error" upload-failed-eh false)
      (.addEventListener ajax "abort" upload-cancelled-eh false)
      (.open ajax "POST" "/upload-file")
      (.send ajax (doto (js/FormData.)
                    (.append "file" (aget files 0))
                    (.append "kcluss" (str ":" (name kcluss)))
                    (.append "id" id)))
      )))

(defn init-uploaders "Initializes asynchronous uploading widgets."
  []
  (doseq [cont ($dom/by-class "upload-form")
          :let [btn (first ($dom/by-class "upload-btn" cont))
                field (first ($dom/by-class "file-field" cont))]]
    (events/listen field (.-CHANGE events/EventType)
                   file-selected)
    (events/listen btn (.-CLICK events/EventType)
                   #(upload-file cont (first ($dom/by-tag "progress" cont))
                                 (keyword ($dom/get cont :_kcluss)) (js/parseInt ($dom/get cont :_id)) (.-files field)))))
