
(ns eejp-web-dev0.cljs.comments
  (:require [eejp-web-dev0.cljs.core :as $]
            [eejp-web-dev0.cljs.dom :as $dom]
            [fetch.remotes :as remotes]
            [goog.events :as events]
            [cljs.reader :as reader])
  (:require-macros [fetch.macros :as fm]))

(defn post-comment [kcluss id text]
  (fm/remote (post-comment (@$/*globals* :user-id) (reader/read-string kcluss) (js/parseInt id) text) [posted?]
             nil))

(defn init-comments "Initializes comment widgets."
  []
  (doseq [cb ($dom/by-class "comment-box")
          :let [btn (first ($dom/by-tag "a" cb))
                txta (first ($dom/by-tag "textarea" cb))]]
    (events/listen btn (.-CLICK events/EventType) #(post-comment ($dom/get cb :_kcluss) ($dom/get cb :_id) (.-value txta)))))
