
(ns ^{:author "Eduardo Julian",
      :doc "Common remotes for usage by ClojureScript scripts."}
     eejp-web-dev0.remotes
  (:use noir.fetch.remotes)
  (:require [clj-orient.core :as oc]
            [clj-orient.query :as oq]
            [eejp-web-dev0.core :as $]
            [eejp-web-dev0.users :as $users]
            [eejp-web-dev0.comments :as $comments]
            [eejp-web-dev0.voting :as $vote]))

(defmacro defremote+ [sym args & body] `(defremote ~sym ~args (oc/with-db ($/get-db) ~@body)))

(defremote+ username-taken? [uname] (boolean (first (oq/sql-query "SELECT FROM User WHERE username = ?" [uname]))))
(defremote+ email-taken? [email] (boolean (first (oq/sql-query "SELECT FROM User WHERE email = ?" [email]))))

(defremote+ vote [uid kcluss id up-or-down] ($vote/vote ($users/fetch-user uid) ($/db-load kcluss id) up-or-down))
(defremote+ unvote [uid kcluss id] ($vote/unvote ($users/fetch-user uid) ($/db-load kcluss id)))

(defremote+ post-comment [uid kcluss id text] ($comments/post-comment ($users/fetch-user uid) text ($/db-load kcluss id)))
