
(ns eejp-web-dev0.cljs.comments
  (:require [eejp-web-dev0.cljs.core :as $]
            [eejp-web-dev0.cljs.dom :as $dom]
            [fetch.remotes :as remotes]
            [goog.events :as events])
  (:require-macros [fetch.macros :as fm]))

(defn post-comment [kcluss id text]
  (fm/remote (post-comment ($/*globals* :user-id) kcluss id text) [posted?]
             nil))

(defn init-comments "Initializes comment widgets."
  []
  (js/alert "init-comments")
  (doseq [cb ($dom/by-class "comments-box")
          :let [_ (js/alert (str "comments-box: " cb))
                btn (first ($dom/by-tag "a" cb))
                _ (js/alert (str "button: " cb))
                txta (first ($dom/by-tag "textarea" cb))
                _ (js/alert (str "textarea: " cb))]]
    (events/listen btn (.-CLICK events/EventType) #(post-comment ($dom/get cb :_kcluss) ($dom/get cb :_id) ($dom/get-text txta)))))
