
(ns ^{:author "Eduardo Julian",
      :doc "Miscellaneous utilities."}
     eejp-web-dev0.utils)

(defn extract-urls [txt]
  (filter (fn [x] (or (.startsWith x "http") (.startsWith x "www")))
          (re-seq #"[https?://|www\.|https?://www\.]\w+[\.\w+]+[:\d+]?[/\w*]*[\?\p{Graph}+]*" txt)))

(defn read-input-stream [in]
  (let [buff (make-array Byte/TYPE 10240)
        bout (java.io.ByteArrayOutputStream.)]
    (loop [size (.read in buff)]
      (when (pos? size)
        (.write bout buff 0 size)
        (recur (.read in buff))))
    (.toByteArray bout)))
