
(ns ^{:author "Eduardo Julian",
      :doc "User data primitives."}
     eejp-web-dev0.users
  (:require [noir.util.crypt :as crypt]
            [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [clj-orient.query :as oq]
            [eejp-web-dev0.core :as $]))

(def +USER+ :User)
($/deffetch fetch-user +USER+)

(defn sign-up "" [email password uname fname lname birthday nationality]
  (let [d (java.util.Date.)]
    (oc/save! (og/vertex +USER+
                         {:email email, :password (crypt/encrypt password),
                          :user-name uname, :first-name fname, :last-name lname,
                          :birthday birthday, :nationality nationality,
                          :user-img nil,
                          :joined-date d, :last-logged d,
                          :verification-code (crypt/encrypt (str email password uname fname lname d))
                          }))))

(defn verify-user "" [email code]
  (if-let [user (first (oq/sql-query "SELECT FROM User WHERE email = :email" {:email email}))]
    (if (= code (oc/pget user :verification-code))
      (-> user (oc/pdissoc! :verification-code) oc/save!))))

(defn password-change-code "" [email]
  (if-let [user (first (oq/sql-query "SELECT FROM User WHERE email = ?" [email]))]
    (crypt/encrypt (str (oc/pget user :email) (oc/pget user :password)))))

(defn allow-password-change? "" [email change-code]
  (if-let [user (first (oq/sql-query "SELECT FROM User WHERE email = ?" [email]))]
    (crypt/compare (str (oc/pget user :email) (oc/pget user :password)) change-code)))

(defn change-password "" [email password]
  (if-let [user (first (oq/sql-query "SELECT FROM User WHERE email = ?" [email]))]
    (oc/save! (oc/passoc! user :password (crypt/encrypt password))))
  nil)

(defn login "" [email password]
  (let [user (first (oq/sql-query "SELECT FROM User WHERE email = :email" {:email email}))]
    (if (and user (not (oc/pget user :verification-code)) (crypt/compare password (oc/pget user :password)))
      (-> user (oc/passoc! :last-logged (java.util.Date.)) oc/save!))))

(defn update-user [user email uname fname lname birthday nationality]
  (oc/save! ($/passoc!+ user :email email, :user-name uname, :first-name fname, :last-name lname,
                        :birthday birthday, :nationality nationality)))
