
(ns ^{:author "Eduardo Julian",
      :doc "Messaging between users."}
     eejp-web-dev0.messaging
  (:use clojure.template)
  (:require [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [eejp-web-dev0.core :as $]))

(def +MESSAGING+ :messages)
($/deffetch fetch-msg +MESSAGING+)

(defn send-message [user1 user2 title text]
  (oc/save! (og/link! user1 :messages {:title title, :text text, :date (java.util.Date.)} user2)))

(defn get-messages [user mode]
  (for [m (og/get-edges user (case mode, :sent :out, :received :in))
        :let [u (og/get-vertex m (case mode, :sent :in, :received :out))
              m (assoc (oc/doc->map m) :msg-id ($/real-id m))]]
    (assoc m :other-id ($/real-id u), :other-name (oc/pget u :user-name), :mode mode)))

(defn delete-message [user msg]
  (let [sender? (= user (og/get-vertex msg :out))
        receiver? (= user (og/get-vertex msg :in))]
    (cond
      (or (and receiver? (= (oc/pget msg :delete) :sender))
          (and sender? (= (oc/pget msg :delete) :receiver))) (oc/save! (oc/passoc! msg :delete :both))
      
      receiver? (oc/save! (oc/passoc! msg :delete :receiver))
      sender? (oc/save! (oc/passoc! msg :delete :sender)))
    nil))

($/set-var-root! #'get-messages ($/paginate get-messages 10))
