
(ns ^{:author "Eduardo Julian",
      :doc "Core functionality."}
     eejp-web-dev0.core
  (:use clojure.template)
  (:require [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [clj-orient.query :as oq]))

; [Constants]
; Visibility Levels
(def +private+ 0) ; only me and tagged users
(def +protected+ 1) ; me and friends
(def +public+ 2)
(def +anon+ 3) ; public & anonymous.

; [Global Vars]
(def ^:dynamic +conf-path+ "system.conf")
(def ^:dynamic *system-conf* {})

; [Utils]
(defmacro deffetch [sym kcluster]
  `(defn ~sym "" [item-id#]
     (if (integer? item-id#)
       (oc/load-item [(oc/get-cluster-id ~kcluster) item-id#])
       item-id#)))

(defn set-var-root! [var val] (alter-var-root var (fn [_] val)))

(defn get-db "" [] (og/open-graph-db! (:db-url *system-conf*) (:db-user *system-conf*) (:db-pass *system-conf*)))
(defn elog [& strs] (throw (Exception. (apply str strs))))
(defn real-id [d] (-> d oc/get-id oc/id->vec second))
(defn extract-page [results page-size page] (->> results (drop (* page-size (dec page))) (take page-size) doall))
(defn paginate [f page-size]
  (fn [page & args]
    (let [x (apply f args)]
      [(extract-page x page-size page) (count x)])))

(defn load-system-conf! []
  (set-var-root! #'*system-conf* (read-string (slurp +conf-path+))))

(defn db-wrap [f] (fn [& args] (oc/with-db (get-db) (apply f args))))
(defn tx-wrap [f] (fn [& args] (oc/with-tx (apply f args))))

; Data-type Declaration
(defn- declare-records! [group]
  (oc/with-db (get-db)
    (doseq [t group]
      (try (oc/create-class! t)
        (catch com.orientechnologies.orient.core.exception.OSchemaException e nil)))))

(do-template [sym parent]
  (defn- sym [group]
    (oc/with-db (get-db)
      (doseq [t group]
        (try (oc/create-class! t parent)
          (catch com.orientechnologies.orient.core.exception.OSchemaException e nil)))))
  declare-vertices! :OGraphVertex
  declare-edges! :OGraphEdge)

(defn declare-data-types! [data-types]
  (declare-records! (data-types :records))
  (declare-vertices! (data-types :vertices))
  (declare-edges! (data-types :edges)))

; Enhancements to clj-orient
(defn passoc!+
  ([d k v] (if v (oc/passoc! d k v) d))
  ([d k v & kvs] (reduce #(passoc!+ %1 (first %2) (second %2)) d (partition 2 (list* k v kvs)))))

; Execute some basic stuff:
(load-system-conf!)
