
(ns ^{:author "Eduardo Julian",
      :doc "Google Maps."}
     eejp-web-dev0.cljs.google-maps
  (:require [eejp-web-dev0.cljs.core :as $]))

; Basic geolocation.
(defn init-geo! [] (geo_position_js/init))

(defn get-coords [callback error]
  (geo_position_js/getCurrentPosition
    (fn [x] (callback [(.. x -coords -latitude), (.. x -coords -longitude)])) ; SUCCESS
    error ; ERROR
    (js* "{enableHighAccuracy: true}")))

; Google Maps specifics.
(defn lat-lng [ll] (if (vector? ll) (google.maps.LatLng. (first ll) (second ll)) ll))

(defn init-map! [container ll zoom] (google.maps.Map. container ($/map->jso {:center (lat-lng ll), :zoom zoom, :mapTypeId google.maps.MapTypeId.ROADMAP})))

(defn add-markers! [gmap & markers]
  (doseq [{:keys [coords title on-drag]} markers
          :let [mark (google.maps.Marker. ($/map->jso {:map gmap,
                                                       :title title,
                                                       :position (lat-lng coords),
                                                       :draggable (boolean on-drag)}))]]
    (do
      (if on-drag (.addListener mark "dragend" #(on-drag mark)))
      mark)))
