
(ns ^{:author "Eduardo Julian",
      :doc "Core functionality."}
     eejp-web-dev0.cljs.core
  (:require [goog.dom :as dom]))

; [Notifs and Errors]
(def +notifs+ {:verif-email-sent "The verification e-mail was sent. Please check your e-mail account."
               :verif-success "Your account was succesfully verified. You may now log in."
               :verif-error "Your account could not be verified. Either the code was wrong or that account was already accepted."
               :password-change-email-sent "The password-change email was sent to your account.Please click on the sent link to change your password."
               :pass-changed "Your password has been changed. You may now log in."
               :message-sent "The message has been sent succesfully."})

(def +errors+ {:login-error "There was a problem while login. Either your email or your password was mispelled."
               :no-user-email "There is no user with that e-mail address. Please try again and verify you wrote the right address."
               :invalid-code "The provided code is wrong. Is that code still valid?"
               :pass-repass "The retyped password must match the desired password."
               :require-login "What you are trying to do requires that you are logged in. Please log in and then proceed."
               :message-oneself "You cannot send a message to yourself."})

; [Globals]
(def *flashes* (atom {}))

; [Utils]
(defn map->jso "Makes a JavaScript object from a Clojure map."
  [cljmap]
  (if (map? cljmap)
    (let [out (js-obj)] (doseq [[k v] cljmap] (aset out (name k) (map->jso v)))
      out)
    cljmap))

(defn handle-flashes! "This handles flash-put! messages of all kinds."
  []
  (let [elems (dom/query ".flash-notif")]
    (doseq [i (range (.length elems))
            :let [x (.item elems i)
                  k (.getAttribute x "name")
                  v (.getAttribute x "value")]]
      (cond
        (= k "notif") (js/alert (str "Notificación: " (-> v keyword +notifs+)))
        (= k "error") (js/alert (str "Error: " (-> v keyword +errors+)))
        :else (swap! *flashes* assoc (keyword k) v)))
    ))

(defn nop [& args])
