
(ns ^{:author "Eduardo Julian",
      :doc "System data cleanup functionality."}
     eejp-web-dev0.cleanup
  (:require [clj-orient.core :as oc]
            [clj-orient.query :as oq]
            [eejp-web-dev0.core :as $]
            [eejp-web-dev0.schedules :as sched]))

; [Macros]
(defmacro delete-all! [query params]
  `(doseq [f# (oq/sql-query ~query ~params)]
     (oc/delete! f#)))

; [Resources]
(defn clean-late-unverified! []
  (delete-all! "SELECT FROM User WHERE verification-code IS NOT NULL AND joined-date < :limit"
               {:limit (java.util.Date. (- (.getTime (java.util.Date.)) (* 1000 60 60 24 30)))}))

(defn clean-deleted-messages! [] (delete-all! "SELECT FROM messages WHERE delete = :type" {:type "both"}))

(defn start-cleanup-daemon! [fns start delay]
  (let [wrapper (fn [] (oc/with-db ($/get-db) (doseq [f fns] (f))))]
    (sched/create-schedule! :_cleanup wrapper start delay)))
