
(ns ^{:author "Eduardo Julian",
      :doc "Address primitives."}
     eejp-web-dev0.addresses
  (:require [clj-orient.core :as oc]
            [clj-orient.graph :as og]
            [clj-orient.query :as oq]
            [eejp-web-dev0.core :as $]))

(def +ADDRESS+ :Address)
($/deffetch fetch-address +ADDRESS+)

(defn create-address "" [written-addr lat lng] (oc/save! (og/vertex +ADDRESS+ {:written written-addr, :lat lat, :lng lng})))
(defn get-addresses "" [item] (og/get-ends item :out :has-address))
(defn update-address "" [addr written-addr lat lng] (oc/save! ($/passoc!+ addr :written-addr written-addr, :lat lat, :lng lng)))
(defn associate-address "" [target addr] (oc/save! (og/link! target :has-address {:date (java.util.Date.)} addr)))
