/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.eecs.tac;

import com.botbox.util.ArrayUtils;
import edu.umich.eecs.tac.Parser;
import edu.umich.eecs.tac.Participant;
import edu.umich.eecs.tac.props.RetailCatalog;
import edu.umich.eecs.tac.props.SlotInfo;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Logger;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.logtool.LogReader;
import se.sics.tasim.logtool.ParticipantInfo;
import se.sics.tasim.props.ServerConfig;

public class TACAASimulationInfo
extends Parser {
    private static final Logger log = Logger.getLogger(TACAASimulationInfo.class.getName());
    private int simID;
    private int uniqueID;
    private String simType;
    private String simParams;
    private long startTime;
    private int simLength;
    private String serverName;
    private String serverVersion;
    private ServerConfig serverConfig;
    private SlotInfo slotInfo;
    private RetailCatalog retailCatalog;
    private Participant[] participants;
    private Hashtable participantTable;
    private int[] agentRoles;
    private Participant[][] agentsPerRole;
    private int agentRoleNumber;
    private int currentDate = 0;
    private boolean isParsingExtended = false;

    public TACAASimulationInfo(LogReader logReader) throws IOException, ParseException {
        super(logReader);
        ParticipantInfo[] infos = logReader.getParticipants();
        this.participants = new Participant[infos == null ? 0 : infos.length];
        this.participantTable = new Hashtable();
        int n = this.participants.length;
        for (int i = 0; i < n; ++i) {
            ParticipantInfo info = infos[i];
            if (info == null) continue;
            this.participants[i] = new Participant(info);
            this.participantTable.put(info.getAddress(), this.participants[i]);
        }
        this.simID = logReader.getSimulationID();
        this.uniqueID = logReader.getUniqueID();
        this.simType = logReader.getSimulationType();
        this.simParams = logReader.getSimulationParams();
        this.startTime = logReader.getStartTime();
        this.simLength = logReader.getSimulationLength();
        this.serverName = logReader.getServerName();
        this.serverVersion = logReader.getServerVersion();
        this.start();
        Participant[] advertisers = this.getParticipantsByRole(1);
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public int getUniqueID() {
        return this.uniqueID;
    }

    public int getSimulationID() {
        return this.simID;
    }

    public String getSimulationType() {
        return this.simType;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getSimulationLength() {
        return this.simLength;
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public Participant getParticipant(int agentIndex) {
        Participant p;
        if (agentIndex >= this.participants.length || (p = this.participants[agentIndex]) == null) {
            throw new IllegalArgumentException("no participant " + agentIndex);
        }
        return p;
    }

    public Participant getParticipant(String address) {
        Participant p = (Participant)this.participantTable.get(address);
        if (p == null) {
            throw new IllegalArgumentException("no participant " + address);
        }
        return p;
    }

    public int getParticipantCount() {
        return this.participants.length;
    }

    public Participant[] getParticipants() {
        return this.participants;
    }

    public Participant[] getParticipantsByRole(int role) {
        int index = ArrayUtils.indexOf((int[])this.agentRoles, (int)0, (int)this.agentRoleNumber, (int)role);
        if (index < 0) {
            if (this.agentRoles == null) {
                this.agentRoles = new int[5];
                this.agentsPerRole = new Participant[5][];
            } else if (this.agentRoleNumber == this.agentRoles.length) {
                this.agentRoles = ArrayUtils.setSize((int[])this.agentRoles, (int)(this.agentRoleNumber + 5));
                this.agentsPerRole = (Participant[][])ArrayUtils.setSize((Object[])this.agentsPerRole, (int)(this.agentRoleNumber + 5));
            }
            ArrayList<Participant> list = new ArrayList<Participant>();
            for (Participant a : this.participants) {
                if (a == null || a.getInfo().getRole() != role) continue;
                list.add(a);
            }
            index = this.agentRoleNumber;
            this.agentsPerRole[this.agentRoleNumber] = list.size() > 0 ? list.toArray(new Participant[list.size()]) : null;
            this.agentRoles[this.agentRoleNumber++] = role;
        }
        return this.agentsPerRole[index];
    }

    protected void messageToRole(int sender, int role, Transportable content) {
        int n = this.participants.length;
        for (int i = 0; i < n; ++i) {
            if (this.participants[i].getInfo().getRole() != role) continue;
            this.participants[i].messageReceived(this.currentDate, sender, content);
        }
        if (sender != 0) {
            this.getParticipant(sender).messageSentToRole(this.currentDate, role, content);
        }
    }

    protected void message(int sender, int receiver, Transportable content) {
        if (receiver != 0) {
            this.getParticipant(receiver).messageReceived(this.currentDate, sender, content);
            if (sender != 0) {
                this.getParticipant(sender).messageSent(this.currentDate, receiver, content);
            }
        }
    }

    protected void data(Transportable object) {
        if (object instanceof ServerConfig) {
            this.serverConfig = (ServerConfig)object;
        }
    }

    protected void dataUpdated(int agentIndex, int type, int value) {
        switch (type) {
            case 301: {
                this.impressions(agentIndex, value);
                break;
            }
            case 302: {
                this.clicks(agentIndex, value);
                break;
            }
            case 303: {
                this.conversions(agentIndex, value);
                break;
            }
            case 100: {
                Participant p = this.getParticipant(agentIndex);
                p.setResult(value);
            }
        }
    }

    protected void dataUpdated(int agentIndex, int type, long value) {
        if (type == 100) {
            Participant p = this.getParticipant(agentIndex);
            p.setResult(value);
        }
    }

    protected void dataUpdated(int agentIndex, int type, double value) {
        if (type == 100) {
            Participant p = this.getParticipant(agentIndex);
            p.setResult(value);
        }
    }

    protected void dataUpdated(int agent, int type, float value) {
    }

    protected void dataUpdated(int agent, int type, String value) {
    }

    protected void dataUpdated(int agent, int type, Transportable content) {
    }

    protected void dataUpdated(int type, Transportable object) {
        if (object instanceof SlotInfo) {
            this.slotInfo = (SlotInfo)object;
        } else if (object instanceof RetailCatalog) {
            this.retailCatalog = (RetailCatalog)object;
        }
    }

    protected void impressions(int agent, long amount) {
        Participant agentInfo = this.getParticipant(agent);
        agentInfo.addImpressions(amount);
    }

    protected void clicks(int agent, long amount) {
        Participant agentInfo = this.getParticipant(agent);
        agentInfo.addClicks(amount);
    }

    protected void conversions(int agent, long amount) {
        Participant agentInfo = this.getParticipant(agent);
        agentInfo.addConversions(amount);
    }

    protected void transaction(int source, int recipient, double amount) {
        Participant sourceParticipant = this.getParticipant(source);
        Participant recipientParticipant = this.getParticipant(recipient);
        recipientParticipant.addRevenue(amount);
        sourceParticipant.addCost(amount);
    }

    protected void nextDay(int date, long serverTime) {
        this.currentDate = date;
    }

    protected void unhandledNode(String nodeName) {
        log.warning("ignoring unhandled node '" + nodeName + '\'');
    }
}

