/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.eecs.tac;

import edu.umich.eecs.tac.props.AAInfo;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Logger;
import se.sics.isl.transport.TransportReader;
import se.sics.isl.transport.Transportable;
import se.sics.tasim.logtool.LogReader;
import se.sics.tasim.logtool.ParticipantInfo;
import se.sics.tasim.props.ServerConfig;

public abstract class Parser {
    private static final Logger log = Logger.getLogger(Parser.class.getName());
    private static final String CONFIG_NAME = new ServerConfig().getTransportName();
    private final LogReader logReader;

    protected Parser(LogReader logReader) {
        this.logReader = logReader;
        AAInfo aaInfo = new AAInfo();
        this.logReader.setContext(aaInfo.createContext());
    }

    protected LogReader getReader() {
        return this.logReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws IOException, ParseException {
        try {
            this.parseStarted();
            while (this.logReader.hasMoreChunks()) {
                TransportReader reader = this.logReader.nextChunk();
                this.handleNodes(reader);
            }
        }
        finally {
            this.stop();
        }
    }

    private void handleNodes(TransportReader reader) throws ParseException {
        while (reader.nextNode(false)) {
            if (reader.isNode("intUpdated")) {
                int type = reader.getAttributeAsInt("type", 0);
                int agentIndex = reader.getAttributeAsInt("agent", -1);
                int value = reader.getAttributeAsInt("value");
                if (agentIndex < 0) continue;
                this.dataUpdated(agentIndex, type, value);
                continue;
            }
            if (reader.isNode("longUpdated")) {
                int type = reader.getAttributeAsInt("type", 0);
                int agentIndex = reader.getAttributeAsInt("agent", -1);
                long value = reader.getAttributeAsLong("value");
                if (agentIndex < 0) continue;
                this.dataUpdated(agentIndex, type, value);
                continue;
            }
            if (reader.isNode("floatUpdated")) {
                int type = reader.getAttributeAsInt("type", 0);
                int agentIndex = reader.getAttributeAsInt("agent", -1);
                float value = reader.getAttributeAsFloat("value");
                if (agentIndex < 0) continue;
                this.dataUpdated(agentIndex, type, value);
                continue;
            }
            if (reader.isNode("doubleUpdated")) {
                int type = reader.getAttributeAsInt("type", 0);
                int agentIndex = reader.getAttributeAsInt("agent", -1);
                double value = reader.getAttributeAsDouble("value");
                if (agentIndex < 0) continue;
                this.dataUpdated(agentIndex, type, value);
                continue;
            }
            if (reader.isNode("stringUpdated")) {
                int type = reader.getAttributeAsInt("type", 0);
                int agentIndex = reader.getAttributeAsInt("agent", -1);
                String value = reader.getAttribute("value");
                if (agentIndex < 0) continue;
                this.dataUpdated(agentIndex, type, value);
                continue;
            }
            if (reader.isNode("messageToRole")) {
                int sender = reader.getAttributeAsInt("sender");
                int role = reader.getAttributeAsInt("role");
                reader.enterNode();
                reader.nextNode(true);
                Transportable content = reader.readTransportable();
                reader.exitNode();
                this.messageToRole(sender, role, content);
                continue;
            }
            if (reader.isNode("message")) {
                int receiver = reader.getAttributeAsInt("receiver");
                if (receiver == 0) continue;
                int sender = reader.getAttributeAsInt("sender");
                reader.enterNode();
                reader.nextNode(true);
                Transportable content = reader.readTransportable();
                reader.exitNode();
                this.message(sender, receiver, content);
                continue;
            }
            if (reader.isNode("objectUpdated")) {
                int agentIndex = reader.getAttributeAsInt("agent", -1);
                int type = reader.getAttributeAsInt("type", 0);
                reader.enterNode();
                reader.nextNode(true);
                Transportable content = reader.readTransportable();
                reader.exitNode();
                if (agentIndex >= 0) {
                    this.dataUpdated(agentIndex, type, content);
                    continue;
                }
                this.dataUpdated(type, content);
                continue;
            }
            if (reader.isNode("transaction")) {
                int source = reader.getAttributeAsInt("source");
                int recipient = reader.getAttributeAsInt("recipient");
                double amount = reader.getAttributeAsDouble("amount");
                this.transaction(source, recipient, amount);
                continue;
            }
            if (reader.isNode("nextTimeUnit")) {
                int date = reader.getAttributeAsInt("unit");
                long time = reader.getAttributeAsLong("time", 0L);
                this.nextDay(date, time);
                continue;
            }
            if (reader.isNode(CONFIG_NAME)) {
                Transportable content = reader.readTransportable();
                this.data(content);
                continue;
            }
            this.unhandledNode(reader.getNodeName());
        }
    }

    public final void stop() {
        this.logReader.close();
        this.parseStopped();
    }

    protected void parseStarted() {
    }

    protected void parseStopped() {
    }

    protected void messageToRole(int sender, int role, Transportable content) {
        ParticipantInfo[] infos = this.logReader.getParticipants();
        if (infos != null) {
            int n = infos.length;
            for (int i = 0; i < n; ++i) {
                if (infos[i].getRole() != role) continue;
                this.message(sender, infos[i].getIndex(), content);
            }
        }
    }

    protected abstract void message(int var1, int var2, Transportable var3);

    protected void data(Transportable object) {
    }

    protected void dataUpdated(int agent, int type, int value) {
    }

    protected void dataUpdated(int agent, int type, long value) {
    }

    protected void dataUpdated(int agent, int type, float value) {
    }

    protected void dataUpdated(int agent, int type, double value) {
    }

    protected void dataUpdated(int agent, int type, String value) {
    }

    protected void dataUpdated(int agent, int type, Transportable content) {
    }

    protected void dataUpdated(int type, Transportable content) {
    }

    protected void transaction(int source, int recipient, double amount) {
    }

    protected void nextDay(int date, long serverTime) {
    }

    protected void unhandledNode(String nodeName) {
        log.warning("ignoring unhandled node '" + nodeName + '\'');
    }
}

