/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.eecs.tac.props;

import edu.umich.eecs.tac.props.AbstractTransportableEntryListBacking;
import edu.umich.eecs.tac.props.KeyIterator;
import edu.umich.eecs.tac.props.KeyedEntry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyedEntryList<T, S extends KeyedEntry<T>>
extends AbstractTransportableEntryListBacking<S>
implements Iterable<T> {
    public final int indexForEntry(T key) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((KeyedEntry)this.getEntry((T)i)).getKey().equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final Iterator<T> iterator() {
        return new KeyIterator(this.getEntries().iterator());
    }

    public final boolean containsKey(T key) {
        return this.indexForEntry(key) > -1;
    }

    protected final int addKey(T key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        return this.addEntry(this.createEntry(key));
    }

    protected abstract S createEntry(T var1);

    public final Set<T> keys() {
        HashSet keys = new HashSet();
        for (int i = 0; i < this.size(); ++i) {
            keys.add(((KeyedEntry)this.getEntry((T)i)).getKey());
        }
        return keys;
    }

    protected final T getKey(int index) throws IndexOutOfBoundsException {
        return ((KeyedEntry)this.getEntry((T)index)).getKey();
    }

    protected final S getEntry(T key) {
        int index = this.indexForEntry(key);
        if (index < 0) {
            return null;
        }
        return (S)((KeyedEntry)this.getEntry((T)index));
    }
}

