/*
 * Decompiled with CFR 0.152.
 */
package edu.umich.eecs.tac.aa.agentware;

import com.botbox.util.ArrayQueue;
import edu.umich.eecs.tac.aa.agentware.ServerConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.sics.tasim.aw.Message;

public class MessageSender
extends Thread {
    private static final Logger log = Logger.getLogger(MessageSender.class.getName());
    private final ServerConnection connection;
    private ArrayQueue messageQueue = new ArrayQueue();
    private boolean isClosed = false;

    public MessageSender(ServerConnection connection, String name) {
        super(name);
        this.connection = connection;
        this.start();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.messageQueue.clear();
            this.messageQueue.add(null);
            this.notify();
        }
    }

    public synchronized boolean addMessage(Message message) {
        if (this.isClosed) {
            return false;
        }
        this.messageQueue.add((Object)message);
        this.notify();
        return true;
    }

    private synchronized Message nextMessage() {
        while (this.messageQueue.size() == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return (Message)this.messageQueue.remove(0);
    }

    public void run() {
        do {
            Message msg = null;
            try {
                msg = this.nextMessage();
                if (msg == null) continue;
                this.connection.deliverMessage(msg);
            }
            catch (ThreadDeath e) {
                log.log(Level.SEVERE, "message thread died", e);
                throw e;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "could not handle message " + msg, e);
            }
        } while (!this.isClosed);
    }
}

