/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples.javaDemo;

import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owlx.examples.javaDemo.model.Customer;
import edu.stanford.smi.protegex.owlx.examples.javaDemo.model.MyFactory;
import edu.stanford.smi.protegex.owlx.examples.javaDemo.model.Product;
import edu.stanford.smi.protegex.owlx.examples.javaDemo.model.Purchase;
import java.util.Iterator;

public class JavaDemoApplication {
    public static void main(String[] stringArray) throws Exception {
        String string = "http://www.owl-ontologies.com/javaDemo.owl";
        JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModelFromURI(string);
        OWLNamedClass oWLNamedClass = jenaOWLModel.getOWLNamedClass("Product");
        Product product = (Product)oWLNamedClass.createOWLIndividual("ProdcutA").as(Product.class);
        product.setPrice(41.99f);
        Product product2 = (Product)oWLNamedClass.createOWLIndividual("ProductB").as(Product.class);
        product2.setPrice(1.5f);
        Product product3 = (Product)oWLNamedClass.createOWLIndividual("ProductC").as(Product.class);
        product3.setPrice(2.5f);
        OWLNamedClass oWLNamedClass2 = jenaOWLModel.getOWLNamedClass("Customer");
        Customer customer = (Customer)oWLNamedClass2.createOWLIndividual("Hans").as(Customer.class);
        customer.setFirstName("Hans");
        customer.setLastName("Aldi");
        JavaDemoApplication.createPurchase(customer, product, "2005-01-01");
        JavaDemoApplication.createPurchase(customer, product2, "2005-01-02");
        JavaDemoApplication.createPurchase(customer, product3, "2005-01-03");
        JavaDemoApplication.createPurchase(customer, product, "2005-02-07");
        double d = customer.getPurchasesSum();
        System.out.println("Customer " + customer.getBrowserText() + " has spent $" + d);
    }

    private static Purchase createPurchase(Customer customer, Product product, String string) {
        OWLModel oWLModel = customer.getOWLModel();
        Purchase purchase = new MyFactory(oWLModel).createPurchase(null);
        purchase.setCustomer(customer);
        purchase.setProduct(product);
        RDFSDatatype rDFSDatatype = oWLModel.getRDFSDatatypeByName("xsd:date");
        purchase.setDate(oWLModel.createRDFSLiteral(string, rDFSDatatype));
        return purchase;
    }

    private static float getPurchasesSum(RDFIndividual rDFIndividual) {
        OWLModel oWLModel = rDFIndividual.getOWLModel();
        float f = 0.0f;
        RDFProperty rDFProperty = oWLModel.getRDFProperty("purchases");
        RDFProperty rDFProperty2 = oWLModel.getRDFProperty("product");
        RDFProperty rDFProperty3 = oWLModel.getRDFProperty("price");
        Iterator iterator = rDFIndividual.listPropertyValues(rDFProperty);
        while (iterator.hasNext()) {
            RDFIndividual rDFIndividual2 = (RDFIndividual)iterator.next();
            RDFIndividual rDFIndividual3 = (RDFIndividual)rDFIndividual2.getPropertyValue(rDFProperty2);
            Float f2 = (Float)rDFIndividual3.getPropertyValue(rDFProperty3);
            f += f2.floatValue();
        }
        return f;
    }
}

