/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SwingListExample {
    public static void main(String[] stringArray) throws Exception {
        String string = "http://www.owl-ontologies.com/travel.owl";
        JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModelFromURI(string);
        OWLNamedClass oWLNamedClass = jenaOWLModel.getOWLNamedClass("Destination");
        ListPanel listPanel = new ListPanel(oWLNamedClass);
        JFrame jFrame = new JFrame("Simple List Example");
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", listPanel);
        jFrame.setBounds(100, 100, 300, 300);
        jFrame.setVisible(true);
    }

    private static class ListPanel
    extends JPanel
    implements Disposable {
        private static final long serialVersionUID = -3004789529589202212L;
        private OWLNamedClass destinationClass;
        private JList list;
        private DefaultListModel listModel;
        private ModelListener modelListener = new ModelAdapter(){

            public void individualCreated(RDFResource rDFResource) {
                if (rDFResource.hasProtegeType(ListPanel.this.destinationClass, true)) {
                    ListPanel.this.handleDestinationAdded(rDFResource);
                }
            }
        };
        private OWLModel owlModel;

        ListPanel(OWLNamedClass oWLNamedClass) {
            this.destinationClass = oWLNamedClass;
            this.owlModel = oWLNamedClass.getOWLModel();
            this.owlModel.addModelListener(this.modelListener);
            this.listModel = new DefaultListModel();
            for (OWLIndividual oWLIndividual : oWLNamedClass.getInstances(true)) {
                this.listModel.addElement(oWLIndividual);
            }
            this.list = new JList(this.listModel);
            this.list.setCellRenderer(new ResourceRenderer());
            OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Destinations", new JScrollPane(this.list));
            oWLLabeledComponent.addHeaderButton(new AbstractAction("Add Destination...", OWLIcons.getAddIcon("RDFIndividual")){
                private static final long serialVersionUID = 5718620565773628276L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ListPanel.this.addDestination();
                }
            });
            this.setLayout(new BorderLayout());
            this.add("Center", (Component)((Object)oWLLabeledComponent));
        }

        private void addDestination() {
            String string;
            RDFSNamedClass rDFSNamedClass = ProtegeUI.getSelectionDialogFactory().selectClass((Component)this, this.owlModel, Collections.singleton(this.destinationClass), "Select type of new Destination");
            if (rDFSNamedClass != null && (string = JOptionPane.showInputDialog("Enter name of new " + rDFSNamedClass.getBrowserText())) != null) {
                rDFSNamedClass.createRDFIndividual(string);
            }
        }

        public void dispose() {
            this.owlModel.removeModelListener(this.modelListener);
        }

        private void handleDestinationAdded(RDFResource rDFResource) {
            this.listModel.addElement(rDFResource);
            this.list.setSelectedValue(rDFResource, true);
        }
    }
}

