/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protege.exception.OntologyLoadException;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import junit.framework.Assert;

public class RDFSDatatypeExamples {
    public static void main(String[] stringArray) throws OntologyLoadException {
        JenaOWLModel jenaOWLModel = ProtegeOWL.createJenaOWLModel();
        OWLNamedClass oWLNamedClass = jenaOWLModel.createOWLNamedClass("Class");
        OWLIndividual oWLIndividual = oWLNamedClass.createOWLIndividual("Individual");
        OWLDatatypeProperty oWLDatatypeProperty = jenaOWLModel.createOWLDatatypeProperty("stringProperty", jenaOWLModel.getXSDstring());
        oWLIndividual.setPropertyValue(oWLDatatypeProperty, "MyString");
        String string = (String)oWLIndividual.getPropertyValue(oWLDatatypeProperty);
        OWLDatatypeProperty oWLDatatypeProperty2 = jenaOWLModel.createOWLDatatypeProperty("booleanProperty", jenaOWLModel.getXSDboolean());
        oWLIndividual.setPropertyValue(oWLDatatypeProperty2, Boolean.TRUE);
        Boolean bl = (Boolean)oWLIndividual.getPropertyValue(oWLDatatypeProperty2);
        OWLDatatypeProperty oWLDatatypeProperty3 = jenaOWLModel.createOWLDatatypeProperty("floatProperty", jenaOWLModel.getXSDfloat());
        oWLIndividual.setPropertyValue(oWLDatatypeProperty3, new Float(4.2));
        Float f = (Float)oWLIndividual.getPropertyValue(oWLDatatypeProperty3);
        OWLDatatypeProperty oWLDatatypeProperty4 = jenaOWLModel.createOWLDatatypeProperty("intProperty", jenaOWLModel.getXSDint());
        oWLIndividual.setPropertyValue(oWLDatatypeProperty3, new Integer(42));
        Integer n = (Integer)oWLIndividual.getPropertyValue(oWLDatatypeProperty4);
        RDFSLiteral rDFSLiteral = oWLIndividual.getPropertyValueLiteral(oWLDatatypeProperty4);
        Assert.assertEquals((int)rDFSLiteral.getInt(), (int)n);
        Assert.assertTrue((boolean)rDFSLiteral.getDatatype().equals(jenaOWLModel.getXSDint()));
        RDFSDatatype rDFSDatatype = jenaOWLModel.getRDFSDatatypeByName("xsd:date");
        OWLDatatypeProperty oWLDatatypeProperty5 = jenaOWLModel.createOWLDatatypeProperty("dateProperty", rDFSDatatype);
        RDFSLiteral rDFSLiteral2 = jenaOWLModel.createRDFSLiteral("1971-07-06", rDFSDatatype);
        oWLIndividual.setPropertyValue(oWLDatatypeProperty5, rDFSLiteral2);
        RDFSLiteral rDFSLiteral3 = (RDFSLiteral)oWLIndividual.getPropertyValue(oWLDatatypeProperty5);
        System.out.println("Date: " + rDFSLiteral3);
        RDFSLiteral rDFSLiteral4 = jenaOWLModel.createRDFSLiteral("Wert", "de");
        oWLIndividual.setPropertyValue(oWLDatatypeProperty, rDFSLiteral4);
        RDFSLiteral rDFSLiteral5 = (RDFSLiteral)oWLIndividual.getPropertyValue(oWLDatatypeProperty);
        Assert.assertTrue((boolean)rDFSLiteral5.getLanguage().equals("de"));
        Assert.assertTrue((boolean)rDFSLiteral5.getString().equals("Wert"));
    }
}

