/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.util;

import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.Visitable;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.NativeValueComparator;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.InlineResourceChecker;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class Util {
    private static Set<String> excludedPropertyNames = new HashSet<String>();

    public static boolean isExcludedResource(RDFResource rDFResource) {
        if (rDFResource.isSystem() || rDFResource.isAnonymous()) {
            return true;
        }
        OWLModel oWLModel = rDFResource.getOWLModel();
        return rDFResource.hasDirectType(oWLModel.getSystemFrames().getOwlOntologyPointerClass());
    }

    public static void insertProperties(RDFResource rDFResource, TripleStore tripleStore, XMLWriter xMLWriter, boolean bl) throws IOException {
        TreeSet<RDFProperty> treeSet;
        if (bl) {
            treeSet = new TreeSet<RDFProperty>();
            for (RDFProperty rDFProperty : rDFResource.getRDFProperties()) {
                if (!(rDFProperty instanceof RDFProperty)) continue;
                treeSet.add(rDFProperty);
            }
        } else {
            treeSet = rDFResource.getRDFProperties();
        }
        for (RDFProperty rDFProperty : treeSet) {
            TreeSet treeSet2;
            if (excludedPropertyNames.contains(rDFProperty.getName())) continue;
            if (bl) {
                treeSet2 = new TreeSet(new NativeValueComparator());
                treeSet2.addAll(rDFResource.getPropertyValues(rDFProperty));
            } else {
                treeSet2 = rDFResource.getPropertyValues(rDFProperty);
            }
            for (Object e : treeSet2) {
                Visitable visitable;
                if (!tripleStore.contains(rDFResource, rDFProperty, e)) continue;
                if (e instanceof RDFResource || e instanceof RDFExternalResource) {
                    Util.insertResourceAsElement(rDFProperty, xMLWriter);
                    visitable = (Visitable)e;
                    Util.inlineObject(visitable, tripleStore, xMLWriter);
                    xMLWriter.writeEndElement();
                    continue;
                }
                Util.insertResourceAsElement(rDFProperty, xMLWriter);
                visitable = rDFResource.getOWLModel().asRDFSLiteral(e);
                if (visitable.getLanguage() != null) {
                    xMLWriter.writeAttribute("xml:lang", visitable.getLanguage());
                } else {
                    xMLWriter.writeAttribute("rdf:datatype", visitable.getDatatype().getURI());
                }
                xMLWriter.writeTextContent(visitable.toString());
                xMLWriter.writeEndElement();
            }
        }
    }

    public static void inlineObject(Visitable visitable, TripleStore tripleStore, XMLWriter xMLWriter) throws IOException {
        InlineResourceChecker inlineResourceChecker = new InlineResourceChecker();
        visitable.accept(inlineResourceChecker);
        if (inlineResourceChecker.isCanInline()) {
            if (visitable instanceof RDFResource) {
                RDFResource rDFResource = (RDFResource)visitable;
                Util.insertResourceAttribute(rDFResource, xMLWriter);
            } else if (visitable instanceof RDFExternalResource) {
                xMLWriter.writeAttribute("rdf:resource", ((RDFExternalResource)visitable).getResourceURI());
            }
        } else {
            new RDFResourceRenderer(visitable, tripleStore, xMLWriter).write();
        }
    }

    public static void insertAboutAttribute(RDFResource rDFResource, XMLWriter xMLWriter) throws IOException {
        xMLWriter.writeAttribute("rdf:about", Util.getResourceAttributeName(rDFResource, xMLWriter));
    }

    public static void insertIDOrAboutAttribute(RDFResource rDFResource, TripleStore tripleStore, XMLWriter xMLWriter) throws IOException {
        String string = Util.getResourceAttributeName(rDFResource, xMLWriter);
        if (string.startsWith("#")) {
            xMLWriter.writeAttribute("rdf:ID", string.substring(1, string.length()));
        } else {
            xMLWriter.writeAttribute("rdf:about", string);
        }
    }

    public static void insertResourceAttribute(RDFResource rDFResource, XMLWriter xMLWriter) throws IOException {
        xMLWriter.writeAttribute("rdf:resource", Util.getResourceAttributeName(rDFResource, xMLWriter));
    }

    public static String getResourceAttributeName(RDFResource rDFResource, XMLWriter xMLWriter) {
        String string = rDFResource.getURI().startsWith(xMLWriter.getXMLBase()) ? rDFResource.getURI().substring(xMLWriter.getXMLBase().length(), rDFResource.getURI().length()) : rDFResource.getURI();
        return string;
    }

    public static void insertResourceAsElement(RDFResource rDFResource, XMLWriter xMLWriter) throws IOException {
        xMLWriter.writeStartElement(rDFResource.getNamespace(), rDFResource.getLocalName());
    }

    public static boolean isInDefaultNamespace(RDFResource rDFResource, XMLWriter xMLWriter) {
        return xMLWriter.getNamespacePrefixes().getDefaultNamespace().equals(rDFResource.getNamespace());
    }

    public static XMLWriterNamespaceManager getNamespacePrefixes(NamespaceManager namespaceManager, String string) {
        XMLWriterNamespaceManager xMLWriterNamespaceManager = new XMLWriterNamespaceManager(string);
        for (String string2 : namespaceManager.getPrefixes()) {
            String string3 = namespaceManager.getNamespaceForPrefix(string2);
            if (string == null || string3.equals(string)) continue;
            xMLWriterNamespaceManager.setPrefix(string2, namespaceManager.getNamespaceForPrefix(string2));
        }
        String string4 = namespaceManager.getDefaultNamespace();
        if (string4 != null && !string4.equals(string)) {
            xMLWriterNamespaceManager.createPrefixForNamespace(string4);
        }
        return xMLWriterNamespaceManager;
    }

    public static void renderTypes(RDFResource rDFResource, TripleStore tripleStore, RDFResource rDFResource2, XMLWriter xMLWriter) throws IOException {
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFProperty(RDFNames.Slot.TYPE);
        Iterator iterator = tripleStore.listObjects(rDFResource, rDFProperty);
        while (iterator.hasNext()) {
            RDFResource rDFResource3 = (RDFResource)iterator.next();
            if (rDFResource3.equals(rDFResource2)) continue;
            xMLWriter.writeStartElement(Util.getPrefixedName(RDFNames.Slot.TYPE, tripleStore));
            Util.inlineObject(rDFResource3, tripleStore, xMLWriter);
            xMLWriter.writeEndElement();
        }
    }

    public static RDFResource getType(RDFResource rDFResource, TripleStore tripleStore) {
        RDFResource rDFResource2 = null;
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFProperty(RDFNames.Slot.TYPE);
        Iterator iterator = tripleStore.listObjects(rDFResource, rDFProperty);
        while (iterator.hasNext()) {
            RDFResource rDFResource3 = (RDFResource)iterator.next();
            if (rDFResource3.isAnonymous()) continue;
            rDFResource2 = rDFResource3;
            break;
        }
        return rDFResource2;
    }

    public static String getOntologyName(OWLModel oWLModel, TripleStore tripleStore) {
        return tripleStore.getName();
    }

    public static String getPrefixedName(String string, TripleStore tripleStore) {
        return NamespaceUtil.getPrefixedName(tripleStore.getNamespaceManager(), string);
    }

    static {
        excludedPropertyNames.add("http://www.w3.org/2000/01/rdf-schema#subClassOf");
        excludedPropertyNames.add(OWLNames.Slot.EQUIVALENT_CLASS);
        excludedPropertyNames.add(RDFNames.Slot.TYPE);
        excludedPropertyNames.add(ProtegeNames.Slot.CLASSIFICATION_STATUS);
        excludedPropertyNames.add(ProtegeNames.Slot.INFERRED_SUBCLASSES);
        excludedPropertyNames.add(ProtegeNames.Slot.INFERRED_SUPERCLASSES);
        excludedPropertyNames.add(ProtegeNames.Slot.INFERRED_TYPE);
        excludedPropertyNames.add(OWLNames.Slot.DISTINCT_MEMBERS);
        excludedPropertyNames.add(OWLNames.Slot.ALL_VALUES_FROM);
        excludedPropertyNames.add(OWLNames.Slot.CARDINALITY);
        excludedPropertyNames.add(OWLNames.Slot.COMPLEMENT_OF);
        excludedPropertyNames.add(OWLNames.Slot.HAS_VALUE);
        excludedPropertyNames.add(OWLNames.Slot.INTERSECTION_OF);
        excludedPropertyNames.add(OWLNames.Slot.MAX_CARDINALITY);
        excludedPropertyNames.add(OWLNames.Slot.MIN_CARDINALITY);
        excludedPropertyNames.add(OWLNames.Slot.ON_PROPERTY);
        excludedPropertyNames.add(OWLNames.Slot.ONE_OF);
        excludedPropertyNames.add(OWLNames.Slot.SOME_VALUES_FROM);
        excludedPropertyNames.add(OWLNames.Slot.UNION_OF);
        excludedPropertyNames.add("owl");
        excludedPropertyNames.add(OWLNames.Slot.ONTOLOGY_PREFIXES);
        excludedPropertyNames.add(OWLNames.Slot.OWL_ONTOLOGY_POINTER_PROPERTY);
        excludedPropertyNames.add(OWLNames.Slot.IMPORTS);
        excludedPropertyNames.add("http://www.w3.org/2000/01/rdf-schema#domain");
    }
}

