/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.renderer;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLNames;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import edu.stanford.smi.protegex.owl.model.visitor.Visitable;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLNames;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;

public class RDFResourceRenderer
extends OWLModelVisitorAdapter {
    private static boolean renderCardinalityAsInt = false;
    private Visitable resource;
    private XMLWriter writer;
    private TripleStore tripleStore;
    private boolean sort = false;

    public RDFResourceRenderer(Visitable visitable, TripleStore tripleStore, XMLWriter xMLWriter) {
        this.resource = visitable;
        this.tripleStore = tripleStore;
        this.writer = xMLWriter;
    }

    public RDFResourceRenderer(Visitable visitable, TripleStore tripleStore, XMLWriter xMLWriter, boolean bl) {
        this.resource = visitable;
        this.tripleStore = tripleStore;
        this.writer = xMLWriter;
        this.sort = bl;
    }

    public static void setRenderCardinalityAsInt(boolean bl) {
        renderCardinalityAsInt = bl;
    }

    public void write() {
        this.resource.accept(this);
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom oWLAllValuesFrom) {
        this.renderQuantifierRestriction(oWLAllValuesFrom, OWLNames.Slot.ALL_VALUES_FROM);
    }

    public void visitOWLAllDifferent(OWLAllDifferent oWLAllDifferent) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Cls.ALL_DIFFERENT, this.tripleStore));
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Slot.DISTINCT_MEMBERS, this.tripleStore));
            this.writer.writeAttribute("rdf:parseType", "Collection");
            for (RDFResource rDFResource : oWLAllDifferent.getDistinctMembers()) {
                rDFResource.accept(this);
            }
            this.writer.writeEndElement();
            this.insertProperties(oWLAllDifferent);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitOWLOntology(OWLOntology oWLOntology) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Cls.ONTOLOGY, this.tripleStore));
            this.writer.writeAttribute("rdf:about", Util.getResourceAttributeName(oWLOntology, this.writer));
            this.insertProperties(oWLOntology);
            for (String string : oWLOntology.getImports()) {
                this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Slot.IMPORTS, this.tripleStore));
                this.writer.writeAttribute("rdf:resource", string);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitOWLCardinality(OWLCardinality oWLCardinality) {
        this.renderCardinalityRestriction(oWLCardinality, OWLNames.Slot.CARDINALITY);
    }

    public void visitOWLComplementClass(OWLComplementClass oWLComplementClass) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Cls.NAMED_CLASS, this.tripleStore));
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Slot.COMPLEMENT_OF, this.tripleStore));
            RDFSClass rDFSClass = oWLComplementClass.getComplement();
            Util.inlineObject(rDFSClass, this.tripleStore, this.writer);
            this.writer.writeEndElement();
            this.insertProperties(oWLComplementClass);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Cls.NAMED_CLASS, this.tripleStore));
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Slot.ONE_OF, this.tripleStore));
            this.writer.writeAttribute(Util.getPrefixedName("rdf:parseType", this.tripleStore), "Collection");
            TreeSet treeSet = new TreeSet(new FrameComparator());
            treeSet.addAll(oWLEnumeratedClass.getOneOf());
            for (RDFResource rDFResource : treeSet) {
                new RDFResourceRenderer(rDFResource, this.tripleStore, this.writer).write();
            }
            this.writer.writeEndElement();
            this.insertProperties(oWLEnumeratedClass);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitOWLHasValue(OWLHasValue oWLHasValue) {
        try {
            this.writeRestrictionStart(oWLHasValue);
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Slot.HAS_VALUE, this.tripleStore));
            Object object = oWLHasValue.getHasValue();
            if (object instanceof RDFResource) {
                Util.inlineObject((RDFResource)object, this.tripleStore, this.writer);
            } else {
                RDFSLiteral rDFSLiteral = oWLHasValue.getOWLModel().asRDFSLiteral(object);
                if (rDFSLiteral.getLanguage() == null) {
                    this.writer.writeAttribute("rdf:datatype", rDFSLiteral.getDatatype().getURI());
                } else {
                    this.writer.writeAttribute("xml:lang", rDFSLiteral.getLanguage());
                }
                this.writer.writeTextContent(rDFSLiteral.toString());
            }
            this.writer.writeEndElement();
            this.insertProperties(oWLHasValue);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitOWLIndividual(OWLIndividual oWLIndividual) {
        try {
            if (!oWLIndividual.isAnonymous()) {
                this.writer.writeStartElement(Util.getPrefixedName(RDFNames.Cls.DESCRIPTION, this.tripleStore));
                Util.insertAboutAttribute(oWLIndividual, this.writer);
            } else {
                this.writer.writeStartElement(Util.getPrefixedName(RDFNames.Cls.DESCRIPTION, this.tripleStore));
                Util.renderTypes(oWLIndividual, this.tripleStore, oWLIndividual.getOWLModel().getOWLThingClass(), this.writer);
                this.insertProperties(oWLIndividual);
            }
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass oWLIntersectionClass) {
        this.renderNAryLogicalClass(oWLIntersectionClass, OWLNames.Slot.INTERSECTION_OF);
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality oWLMaxCardinality) {
        this.renderCardinalityRestriction(oWLMaxCardinality, OWLNames.Slot.MAX_CARDINALITY);
    }

    public void visitOWLMinCardinality(OWLMinCardinality oWLMinCardinality) {
        this.renderCardinalityRestriction(oWLMinCardinality, OWLNames.Slot.MIN_CARDINALITY);
    }

    public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Cls.NAMED_CLASS, this.tripleStore));
            Util.insertAboutAttribute(oWLNamedClass, this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom oWLSomeValuesFrom) {
        this.renderQuantifierRestriction(oWLSomeValuesFrom, OWLNames.Slot.SOME_VALUES_FROM);
    }

    public void visitOWLUnionClass(OWLUnionClass oWLUnionClass) {
        this.renderNAryLogicalClass(oWLUnionClass, OWLNames.Slot.UNION_OF);
    }

    public void visitOWLDataRange(OWLDataRange oWLDataRange) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Cls.DATA_RANGE, this.tripleStore));
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Slot.ONE_OF, this.tripleStore));
            this.renderValuesAsRDFList(oWLDataRange.getOneOfValueLiterals(), oWLDataRange.getOWLModel());
            this.writer.writeEndElement();
            this.insertProperties(oWLDataRange);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitRDFExternalResource(RDFExternalResource rDFExternalResource) {
        try {
            this.writer.writeStartElement("rdf:resource");
            this.writer.writeAttribute("rdf:about", rDFExternalResource.getResourceURI());
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitRDFDatatype(RDFSDatatype rDFSDatatype) {
        try {
            if (rDFSDatatype.isAnonymous()) {
                this.writer.writeStartElement(Util.getPrefixedName("http://www.w3.org/2000/01/rdf-schema#Datatype", this.tripleStore));
                Util.insertProperties(rDFSDatatype, this.tripleStore, this.writer, this.sort);
            } else {
                this.writer.writeAttribute(Util.getPrefixedName("rdf:resource", this.tripleStore), rDFSDatatype.getURI());
            }
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitRDFIndividual(RDFIndividual rDFIndividual) {
        try {
            Util.insertResourceAsElement(rDFIndividual.getRDFType(), this.writer);
            Util.insertAboutAttribute(rDFIndividual, this.writer);
            this.insertProperties(rDFIndividual);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    public void visitRDFList(RDFList rDFList) {
        this.renderValuesAsRDFList(rDFList.getValues(), rDFList.getOWLModel());
    }

    public void visitRDFSNamedClass(RDFSNamedClass rDFSNamedClass) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName("http://www.w3.org/2000/01/rdf-schema#Class", this.tripleStore));
            Util.insertAboutAttribute(rDFSNamedClass, this.writer);
            this.insertProperties(rDFSNamedClass);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void writeRestrictionStart(OWLRestriction oWLRestriction) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Cls.RESTRICTION, this.tripleStore));
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Slot.ON_PROPERTY, this.tripleStore));
            Util.insertResourceAttribute(oWLRestriction.getOnProperty(), this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void renderCardinalityRestriction(OWLCardinalityBase oWLCardinalityBase, String string) {
        try {
            this.writeRestrictionStart(oWLCardinalityBase);
            this.writer.writeStartElement(Util.getPrefixedName(string, this.tripleStore));
            this.writer.writeAttribute("rdf:datatype", renderCardinalityAsInt ? XSDDatatype.XSDint.getURI() : XSDDatatype.XSDnonNegativeInteger.getURI());
            this.writer.writeTextContent(Integer.toString(oWLCardinalityBase.getCardinality()));
            this.writer.writeEndElement();
            this.insertProperties(oWLCardinalityBase);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void renderNAryLogicalClass(OWLNAryLogicalClass oWLNAryLogicalClass, String string) {
        try {
            this.writer.writeStartElement(Util.getPrefixedName(OWLNames.Cls.NAMED_CLASS, this.tripleStore));
            this.writer.writeStartElement(Util.getPrefixedName(string, this.tripleStore));
            this.writer.writeAttribute("rdf:parseType", "Collection");
            TreeSet<RDFSClass> treeSet = new TreeSet<RDFSClass>((Comparator<RDFSClass>)new FrameComparator());
            treeSet.addAll(oWLNAryLogicalClass.getOperands());
            for (RDFResource rDFResource : treeSet) {
                new RDFResourceRenderer(rDFResource, this.tripleStore, this.writer).write();
            }
            this.writer.writeEndElement();
            this.insertProperties(oWLNAryLogicalClass);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void renderQuantifierRestriction(OWLQuantifierRestriction oWLQuantifierRestriction, String string) {
        try {
            this.writeRestrictionStart(oWLQuantifierRestriction);
            RDFResource rDFResource = oWLQuantifierRestriction.getFiller();
            this.writer.writeStartElement(Util.getPrefixedName(string, this.tripleStore));
            Util.inlineObject(rDFResource, this.tripleStore, this.writer);
            this.writer.writeEndElement();
            this.insertProperties(oWLQuantifierRestriction);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void renderValuesAsRDFList(Collection collection, OWLModel oWLModel) {
        this.renderValuesAsRDFList(collection, oWLModel, RDFNames.Cls.LIST);
    }

    private void renderValuesAsSWRLAtomList(Collection collection, OWLModel oWLModel) {
        this.renderValuesAsRDFList(collection, oWLModel, SWRLNames.Cls.ATOM_LIST);
    }

    private void renderValuesAsRDFList(Collection collection, OWLModel oWLModel, String string) {
        try {
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.writer.writeStartElement(Util.getPrefixedName(string, this.tripleStore));
                this.writer.writeStartElement(Util.getPrefixedName(RDFNames.Slot.FIRST, this.tripleStore));
                Object e = iterator.next();
                if (e instanceof RDFResource) {
                    Util.inlineObject((RDFResource)e, this.tripleStore, this.writer);
                } else {
                    RDFSLiteral rDFSLiteral = oWLModel.asRDFSLiteral(e);
                    this.writer.writeAttribute("rdf:datatype", rDFSLiteral.getDatatype().getURI());
                    this.writer.writeTextContent(rDFSLiteral.getPlainValue() != null ? rDFSLiteral.getPlainValue().toString() : rDFSLiteral.getString());
                }
                this.writer.writeEndElement();
                this.writer.writeStartElement(Util.getPrefixedName(RDFNames.Slot.REST, this.tripleStore));
                if (!iterator.hasNext()) {
                    this.writer.writeAttribute("rdf:resource", oWLModel.getRDFNil().getURI());
                }
                ++n;
            }
            for (int i = 0; i < n; ++i) {
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void insertProperties(RDFResource rDFResource) throws IOException {
        Util.insertProperties(rDFResource, this.tripleStore, this.writer, this.sort);
    }

    public void visitSWRLIndividual(SWRLIndividual sWRLIndividual) {
        this.visitOWLIndividual(sWRLIndividual);
    }

    public void visitSWRLAtomListIndividual(SWRLAtomList sWRLAtomList) {
        this.renderValuesAsSWRLAtomList(sWRLAtomList.getValues(), sWRLAtomList.getOWLModel());
    }
}

