/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFResourceCollectionContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLDocumentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterFactory;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;

public class RDFResourceCollectionWriter {
    private RDFResourceCollectionContentWriter collectionContentWriter;
    private boolean enclose;
    private XMLWriter xmlWriter;

    public RDFResourceCollectionWriter(OWLModel oWLModel, TripleStore tripleStore, Collection collection, Writer writer, boolean bl) {
        String string = Util.getOntologyName(oWLModel, tripleStore);
        String string2 = oWLModel.getNamespaceManager().getDefaultNamespace();
        if (string2 == null) {
            string2 = tripleStore.getName() + "#";
        }
        XMLWriterNamespaceManager xMLWriterNamespaceManager = Util.getNamespacePrefixes(oWLModel.getNamespaceManager(), string2);
        this.xmlWriter = XMLWriterFactory.getInstance().createXMLWriter(writer, xMLWriterNamespaceManager, string);
        this.enclose = bl;
        this.collectionContentWriter = new RDFResourceCollectionContentWriter(collection, tripleStore);
    }

    public RDFResourceCollectionWriter(OWLModel oWLModel, TripleStore tripleStore, Collection collection, XMLWriter xMLWriter, boolean bl) {
        this.xmlWriter = xMLWriter;
        this.enclose = bl;
        this.collectionContentWriter = new RDFResourceCollectionContentWriter(collection, tripleStore);
    }

    public void write() throws IOException {
        if (this.enclose) {
            RDFXMLDocumentWriter rDFXMLDocumentWriter = new RDFXMLDocumentWriter(this.xmlWriter, Collections.singleton(this.collectionContentWriter));
            rDFXMLDocumentWriter.writeDocument();
        } else {
            this.collectionContentWriter.writeContent(this.xmlWriter);
        }
    }
}

